/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.controllers;

import org.easymock.EasyMock;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.ui.ridgets.annotation.processor.RidgetContainerAnnotationProcessor;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonUITestCase
public abstract class AbstractSubModuleControllerTest<C extends IController>
extends RienaTestCase {
    private C controller;
    private final INavigationProcessor mockNavigationProcessor = (INavigationProcessor)EasyMock.createMock(INavigationProcessor.class);

    protected void setUp() throws Exception {
        super.setUp();
        System.getProperties().put("riena.test", Boolean.TRUE.toString());
        SwtControlRidgetMapper.getInstance();
        Display display = Display.getDefault();
        Realm realm = SWTObservables.getRealm((Display)display);
        AbstractSubModuleControllerTest.assertNotNull((Object)realm);
        ReflectionUtils.invokeHidden((Object)realm, (String)"setDefault", (Object[])new Object[]{realm});
        ModuleNode module = new ModuleNode();
        SubModuleNode node = new SubModuleNode();
        node.setParent((INavigationNode)module);
        module.addChild((INavigationNode)node);
        node.setNavigationProcessor(this.getMockNavigationProcessor());
        this.controller = this.createController((ISubModuleNode)node);
        this.controller.configureRidgets();
        this.controller.afterBind();
        RidgetContainerAnnotationProcessor.getInstance().processAnnotations(this.controller);
    }

    protected void tearDown() throws Exception {
        System.getProperties().put("riena.test", "false");
        super.tearDown();
    }

    protected C getController() {
        return this.controller;
    }

    protected INavigationProcessor getMockNavigationProcessor() {
        return this.mockNavigationProcessor;
    }

    protected abstract C createController(ISubModuleNode var1);
}

