/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.riena.navigation.ui.swt.views.AbstractNavigationCompositeDeligation;
import org.eclipse.riena.navigation.ui.swt.views.IModuleNavigationComponentProvider;
import org.eclipse.riena.navigation.ui.swt.views.ScrollBarSupport;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class ScrollBarNavigationCompositeDeligation
extends AbstractNavigationCompositeDeligation {
    private ScrolledComposite sc;

    public ScrollBarNavigationCompositeDeligation(Composite superParent, Composite parent, IModuleNavigationComponentProvider navigationProvider) {
        super(superParent, parent, navigationProvider);
    }

    protected ScrolledComposite getScrolledComposite() {
        return this.sc;
    }

    public void updateSize(int height) {
        super.updateSize(height);
        int width = this.getNavigationComposite().getSize().x;
        this.sc.setMinSize(width, height);
    }

    protected Composite createNavigationComposite(Composite parent) {
        this.sc = new ScrolledComposite(parent, 512);
        Composite naviComp = super.createNavigationComposite((Composite)this.sc);
        this.sc.setContent((Control)naviComp);
        this.sc.setBackground(NAVIGATION_BACKGROUND);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.setShowFocusedControl(false);
        SWTFacade.getDefault().setIncrement(this.sc.getVerticalBar(), 10);
        this.setScrollingSupport(new ScrollBarSupport(this.sc, this.getNavigationProvider()));
        return naviComp;
    }

    public Point getVerticalScrollBarSize() {
        if (SwtUtilities.isDisposed((Widget)this.getScrolledComposite())) {
            return super.getVerticalScrollBarSize();
        }
        if (!SwtUtilities.isDisposed((Widget)this.getScrolledComposite().getVerticalBar()) && this.getScrolledComposite().getVerticalBar().isVisible()) {
            return this.getScrolledComposite().getVerticalBar().getSize();
        }
        return super.getVerticalScrollBarSize();
    }
}

