/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import java.util.Collection;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.navigation.ui.Activator;
import org.eclipse.riena.navigation.INavigationNodeController;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.ui.controllers.NavigationNodeController;
import org.eclipse.riena.navigation.ui.controllers.NodeEventDelegation;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComplexRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IUIProcessRidget;
import org.eclipse.riena.ui.ridgets.IVisualContextManager;
import org.eclipse.riena.ui.ridgets.SubModuleUtils;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.WorkareaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubApplicationController
extends NavigationNodeController<ISubApplicationNode> {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SubApplicationController.class);
    private IUIProcessRidget uiProcessRidget;
    private final NodeEventDelegation contextUpdater = new NodeEventDelegation();

    public SubApplicationController(ISubApplicationNode pSubApplication) {
        super(pSubApplication);
    }

    public void configureRidgets() {
        NavigationTreeObserver navigationTreeObserver = new NavigationTreeObserver();
        navigationTreeObserver.addListener((ISubModuleNodeListener)new MySubModuleNodeListener());
        navigationTreeObserver.addListenerTo((ISubApplicationNode)this.getNavigationNode());
    }

    @Override
    public void afterBind() {
        super.afterBind();
        this.initUiProcessRidget();
    }

    private void initUiProcessRidget() {
        if (this.uiProcessRidget == null) {
            this.uiProcessRidget = (IUIProcessRidget)this.getRidget("uiProcessRidget");
            if (this.uiProcessRidget == null) {
                return;
            }
        }
        this.uiProcessRidget.setContextLocator((IVisualContextManager)this.contextUpdater);
    }

    public IActionRidget getMenuActionRidget(String id) {
        String menuItemId = "menuAction." + id;
        return this.getActionRidget(menuItemId);
    }

    public IActionRidget getToolbarActionRidget(String id) {
        String menuItemId = "toolbarAction." + id;
        return this.getActionRidget(menuItemId);
    }

    private IActionRidget getActionRidget(String id) {
        Object ridget = this.getRidget(id);
        if (ridget instanceof IActionRidget) {
            return (IActionRidget)ridget;
        }
        return null;
    }

    public IUIProcessRidget getUiProcessRidget() {
        return this.uiProcessRidget;
    }

    public void setUiProcessRidget(IUIProcessRidget uiProcessRidget) {
        this.uiProcessRidget = uiProcessRidget;
    }

    private void prepareController(ISubModuleNode source) {
        IWorkareaDefinition definition = WorkareaManager.getInstance().getDefinition((Object)source);
        if (definition == null) {
            String message = String.format("cannnot find definition for %s", source);
            LOGGER.log(1, message);
            return;
        }
        try {
            SubModuleController controller;
            if (!definition.isRequiredPreparation()) {
                String message = String.format("controller for class %s will be prepared, although required preparation flag is not set", definition.getControllerClass());
                LOGGER.log(2, message);
            }
            if ((controller = (SubModuleController)definition.createController()) == null && definition.getControllerClass() == null) {
                String message = String.format("no controller class is define for %s", source);
                LOGGER.log(4, message);
                return;
            }
            controller.setNavigationNode(source);
            source.setNavigationNodeController((INavigationNodeController)controller);
            controller.configureRidgets();
            controller.setConfigured(true);
            Collection<IRidget> ridgets = controller.getRidgets();
            for (IRidget ridget : ridgets) {
                if (!(ridget instanceof IComplexRidget)) continue;
                IComplexRidget complexRidget = (IComplexRidget)ridget;
                complexRidget.configureRidgets();
                complexRidget.setConfigured(true);
            }
        }
        catch (Exception ex) {
            String message = String.format("cannnot create controller for class %s", definition.getControllerClass());
            LOGGER.log(1, message, (Throwable)ex);
        }
    }

    private class MySubModuleNodeListener
    extends SubModuleNodeListener {
        private MySubModuleNodeListener() {
        }

        public void prepared(ISubModuleNode source) {
            if (!SubModuleUtils.isPrepareView() && source.getNavigationNodeController() == null) {
                SubApplicationController.this.prepareController(source);
            }
        }
    }
}

