/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.core.injector.service.DepOne;
import org.eclipse.riena.core.injector.service.DepTwo;
import org.eclipse.riena.core.injector.service.IRanking;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target {
    private final Map<String, List<Class<?>>> deps = new HashMap();
    private IRanking ranking;

    public void bind(DepOne dep) {
        this.called("bind", DepOne.class, dep);
        this.add("bind", DepOne.class);
    }

    public void unbind(DepOne dep) {
        this.called("unbind", DepOne.class, dep);
        this.remove("bind", DepOne.class);
    }

    public void bind(DepTwo dep) {
        this.called("bind", DepTwo.class, dep);
        this.add("bind", DepTwo.class);
    }

    public void unbind(DepTwo dep) {
        this.called("unbind", DepTwo.class, dep);
        this.remove("bind", DepTwo.class);
    }

    public void binde(DepOne dep) {
        this.called("binde", DepOne.class, dep);
        this.add("binde", DepOne.class);
    }

    public void entbinde(DepOne dep) {
        this.called("entbinde", DepOne.class, dep);
        this.remove("binde", DepOne.class);
    }

    public void bind(IRanking dep) {
        this.called("bind", IRanking.class, dep);
        this.add("bind", IRanking.class);
        this.ranking = dep;
    }

    public void unbind(IRanking dep) {
        this.called("unbind", IRanking.class, dep);
        this.remove("bind", IRanking.class);
    }

    private void called(String methodName, Class<?> type, Object object) {
        System.out.println(String.valueOf(methodName) + "(" + type.getSimpleName() + ") -> " + object.getClass().getSimpleName());
    }

    public int count(String method, Class<?> clazz) {
        List<Class<?>> deps4method = this.deps.get(this.key(method, clazz));
        if (deps4method != null) {
            return deps4method.size();
        }
        return 0;
    }

    public int getDepRanking() {
        return this.ranking.getRanking();
    }

    private void add(String method, Class<?> depClass) {
        List<Class<?>> deps4method = this.deps.get(this.key(method, depClass));
        if (deps4method == null) {
            deps4method = new ArrayList();
            this.deps.put(this.key(method, depClass), deps4method);
        }
        deps4method.add(depClass);
    }

    private void remove(String method, Class<?> depClass) {
        List<Class<?>> deps4method = this.deps.get(this.key(method, depClass));
        if (deps4method != null) {
            deps4method.remove(depClass);
        }
    }

    private String key(String methodKey, Class<?> type) {
        return String.valueOf(methodKey) + "(" + type.getName() + ")";
    }
}

