/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class IterTest
extends RienaTestCase {
    public void testIteratorTyped() {
        Scanner scanner = new Scanner("this is a test");
        String result = "";
        for (String s : Iter.able((Iterator)scanner)) {
            result = String.valueOf(result) + s;
        }
        IterTest.assertEquals((String)"thisisatest", (String)result);
    }

    public void testIteratorUntyped() {
        UntypedIteratorReturner utr = new UntypedIteratorReturner(new String[]{"1", "2"});
        String result = "";
        for (String s : Iter.able((Iterator)utr.getIterator(), String.class)) {
            result = String.valueOf(result) + s;
        }
        IterTest.assertEquals((String)"12", (String)result);
    }

    public void testNullIterator() {
        String result = "";
        for (String s : Iter.able(null)) {
            result = String.valueOf(result) + s;
        }
        IterTest.assertEquals((String)"", (String)result);
    }

    public void testEnumerationTyped() {
        Vector<String> v = new Vector<String>();
        v.add("1");
        v.add("2");
        String result = "";
        for (String o : Iter.able(v.elements())) {
            result = String.valueOf(result) + o;
        }
        IterTest.assertEquals((String)"12", (String)result);
    }

    public void testArray() {
        Object[] strings = new String[]{"a", "b", "c"};
        String result = "";
        for (String o : Iter.able((Object[])strings)) {
            result = String.valueOf(result) + o;
        }
        IterTest.assertEquals((String)"abc", (String)result);
    }

    public void testEmptyArray() {
        Object[] strings = new String[]{};
        String result = "";
        for (String o : Iter.able((Object[])strings)) {
            result = String.valueOf(result) + o;
        }
        IterTest.assertEquals((String)"", (String)result);
    }

    public void testNullArray() {
        Object[] strings = null;
        String result = "";
        for (String o : Iter.able((Object[])strings)) {
            result = String.valueOf(result) + o;
        }
        IterTest.assertEquals((String)"", (String)result);
    }

    public void testEnumerationUntyped() {
        StringTokenizer st = new StringTokenizer("this is a test");
        String result = "";
        for (String str : Iter.able((Enumeration)st, String.class)) {
            result = String.valueOf(result) + str;
        }
        IterTest.assertEquals((String)"thisisatest", (String)result);
    }

    public void testNullEnumeration() {
        String result = "";
        for (Object o : Iter.able(null)) {
            result = String.valueOf(result) + o;
        }
        IterTest.assertEquals((String)"", (String)result);
    }

    public void testCollection() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("1");
        strings.add("2");
        String result = "";
        for (Object o : Iter.able(strings)) {
            result = String.valueOf(result) + o;
        }
        IterTest.assertEquals((String)"12", (String)result);
    }

    public void testNullCollection() {
        Iterable strings = null;
        String result = "";
        for (Object o : Iter.able(strings)) {
            result = String.valueOf(result) + o;
        }
        IterTest.assertEquals((String)"", (String)result);
    }

    public void testAndNowSomethingCompletlyDifferent() throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> enumeration = classLoader.getResources("META-INF/hivemodule.xml");
        for (URL jarUrl : Iter.able(enumeration)) {
            this.println(jarUrl.toString());
        }
    }

    public void testReverseIterating() {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        ints.add(1);
        ints.add(2);
        ints.add(3);
        int expected = 3;
        for (Integer i : Iter.ableReverse(ints)) {
            IterTest.assertEquals((int)expected--, (int)i);
        }
    }

    public void testReverseIteratingWithNull() {
        List ints = null;
        for (Integer i : Iter.ableReverse(ints)) {
            IterTest.fail((String)("Unfortunately " + i + " could be reached which should not happen!."));
        }
    }

    private static class UntypedIteratorReturner {
        private final String[] strings;

        public UntypedIteratorReturner(String[] strings) {
            this.strings = strings;
        }

        public Iterator getIterator() {
            return new Iterator(){
                private int i = 0;

                public boolean hasNext() {
                    return this.i < UntypedIteratorReturner.this.strings.length;
                }

                public Object next() {
                    if (this.i == UntypedIteratorReturner.this.strings.length) {
                        throw new NoSuchElementException();
                    }
                    return UntypedIteratorReturner.this.strings[this.i++];
                }

                public void remove() {
                }
            };
        }
    }
}

