/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.Collections;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.core.util.Literal;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

@NonUITestCase
public class StringUtilsTest
extends TestCase {
    public void testIsEmpty() {
        StringUtilsTest.assertTrue((boolean)StringUtils.isEmpty(null));
        StringUtilsTest.assertTrue((boolean)StringUtils.isEmpty((CharSequence)""));
        StringUtilsTest.assertFalse((boolean)StringUtils.isEmpty((CharSequence)" "));
        StringUtilsTest.assertFalse((boolean)StringUtils.isEmpty((CharSequence)" a "));
    }

    public void testIsGiven() {
        StringUtilsTest.assertFalse((boolean)StringUtils.isGiven(null));
        StringUtilsTest.assertFalse((boolean)StringUtils.isGiven((CharSequence)""));
        StringUtilsTest.assertTrue((boolean)StringUtils.isGiven((CharSequence)" "));
        StringUtilsTest.assertTrue((boolean)StringUtils.isGiven((CharSequence)" a "));
    }

    public void testIsDeepEmpty() {
        StringUtilsTest.assertTrue((boolean)StringUtils.isDeepEmpty(null));
        StringUtilsTest.assertTrue((boolean)StringUtils.isDeepEmpty((String)""));
        StringUtilsTest.assertTrue((boolean)StringUtils.isDeepEmpty((String)" "));
        StringUtilsTest.assertFalse((boolean)StringUtils.isDeepEmpty((String)" a "));
    }

    public void testEquals() {
        StringUtilsTest.assertTrue((boolean)StringUtils.equals(null, null));
        StringUtilsTest.assertFalse((boolean)StringUtils.equals(null, (CharSequence)""));
        StringUtilsTest.assertFalse((boolean)StringUtils.equals((CharSequence)"", null));
        StringUtilsTest.assertTrue((boolean)StringUtils.equals((CharSequence)"c", (CharSequence)"c"));
        StringUtilsTest.assertTrue((boolean)StringUtils.equals((CharSequence)"c", (CharSequence)"c"));
        StringUtilsTest.assertFalse((boolean)StringUtils.equals(null, (CharSequence)"a"));
        StringUtilsTest.assertFalse((boolean)StringUtils.equals((CharSequence)"a", null));
        StringUtilsTest.assertFalse((boolean)StringUtils.equals((CharSequence)"b", (CharSequence)"a"));
        StringUtilsTest.assertFalse((boolean)StringUtils.equals((CharSequence)"a", (CharSequence)"b"));
    }

    public void testCount() {
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.count((String)"abb", (char)'a'));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.count((String)"bba", (char)'a'));
        StringUtilsTest.assertEquals((int)1, (int)StringUtils.count((String)"bab", (char)'a'));
        StringUtilsTest.assertEquals((int)3, (int)StringUtils.count((String)"aaa", (char)'a'));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.count((String)"", (char)'a'));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.count(null, (char)'a'));
        StringUtilsTest.assertEquals((int)0, (int)StringUtils.count((String)"bcd", (char)'a'));
    }

    public void testCapitalize() {
        StringUtilsTest.assertEquals(null, (String)StringUtils.capitalize(null));
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.capitalize((String)""));
        StringUtilsTest.assertEquals((String)"!a", (String)StringUtils.capitalize((String)"!a"));
        StringUtilsTest.assertEquals((String)"A", (String)StringUtils.capitalize((String)"A"));
        StringUtilsTest.assertEquals((String)"A", (String)StringUtils.capitalize((String)"a"));
        StringUtilsTest.assertEquals((String)"Veritas", (String)StringUtils.capitalize((String)"veritas"));
    }

    public void testJoinNull() {
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join(null, (CharSequence)"-"));
    }

    public void testJoinEmpty() {
        StringUtilsTest.assertEquals((String)"", (String)StringUtils.join((Iterable)Iter.able((Object[])new Object[0]), (CharSequence)"-"));
    }

    public void testJoinOne() {
        StringUtilsTest.assertEquals((String)"one", (String)StringUtils.join((Iterable)Iter.able((Object[])new Object[]{"one"}), (CharSequence)"-"));
    }

    public void testJoinTwo() {
        StringUtilsTest.assertEquals((String)"one-two", (String)StringUtils.join((Iterable)Iter.able((Object[])new Object[]{"one", "two"}), (CharSequence)"-"));
    }

    public void testJoinFourMorePersons() {
        LinkedList<Person> persons = new LinkedList<Person>();
        LinkedList<String> pToString = new LinkedList<String>();
        int i = 0;
        while (i < 4) {
            String pref = String.valueOf(i);
            Person person = new Person(String.valueOf(pref) + "last", String.valueOf(pref) + "firstname");
            persons.add(person);
            pToString.add(person.toString());
            ++i;
        }
        String joined = StringUtils.join(persons, (CharSequence)"%");
        StringUtilsTest.assertFalse((boolean)joined.startsWith("%"));
        String[] split = joined.split("%");
        StringUtilsTest.assertEquals((int)4, (int)split.length);
        StringUtilsTest.assertEquals((int)(joined.length() - 1 - ((Person)persons.get(3)).toString().length()), (int)joined.lastIndexOf("%"));
    }

    public void testSplit() {
        StringUtilsTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)StringUtils.split(null, (char)','));
        StringUtilsTest.assertEquals((Object)Literal.list((Object)""), (Object)StringUtils.split((String)"", (char)','));
        StringUtilsTest.assertEquals((Object)Literal.list((Object)"1"), (Object)StringUtils.split((String)"1", (char)','));
        StringUtilsTest.assertEquals((Object)Literal.list((Object)"1").list((Object)"2"), (Object)StringUtils.split((String)"1,2", (char)','));
        StringUtilsTest.assertEquals((Object)Literal.list((Object)"1").list((Object)"2").list((Object)""), (Object)StringUtils.split((String)"1,2,", (char)','));
    }
}

