/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.swt.utils;

import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import junit.framework.Assert;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public final class TestUtils {
    private TestUtils() {
    }

    public static void assertColumnWidths(Control control, int numberOfCols) {
        int expected = control.getSize().x / numberOfCols;
        Assert.assertTrue((String)String.valueOf(expected), (expected > 0 ? 1 : 0) != 0);
        int column = 0;
        while (column < numberOfCols) {
            int actual = TestUtils.getColumnWidth(control, column);
            String message = String.format("col %d, expected %d <= x <= %d but was %d", column, expected, expected + 1, actual);
            Assert.assertTrue((String)message, (expected <= actual && actual <= expected + 1 ? 1 : 0) != 0);
            ++column;
        }
    }

    public static void assertMandatoryMarker(IMarkableRidget ridget, int expectedCount, boolean disabledState) {
        Collection markers = ridget.getMarkersOfType(MandatoryMarker.class);
        Assert.assertEquals((int)expectedCount, (int)markers.size());
        Iterator iter = markers.iterator();
        while (iter.hasNext()) {
            boolean isDisabled = ((MandatoryMarker)iter.next()).isDisabled();
            Assert.assertEquals((boolean)disabledState, (boolean)isDisabled);
        }
    }

    public static void assertMessageCount(IMarkable ridget, Class markerType, int count) {
        Collection collection = ridget.getMarkersOfType(markerType);
        if (count != collection.size()) {
            System.out.println(String.format("assertion failed on message count -- expected %d, got %d:", count, collection.size()));
            for (IMessageMarker messageMarker : collection) {
                System.out.println("\t" + messageMarker.getMessage());
            }
        }
        Assert.assertEquals((int)count, (int)collection.size());
    }

    public static void assertMessage(IMarkable ridget, Class markerType, String message) {
        Collection collection = ridget.getMarkersOfType(markerType);
        boolean wasFound = false;
        Iterator iter = collection.iterator();
        while (!wasFound && iter.hasNext()) {
            IMessageMarker marker = (IMessageMarker)iter.next();
            wasFound = message.equals(marker.getMessage());
        }
        Assert.assertEquals((String)String.format("Message '%s'", message), (boolean)true, (boolean)wasFound);
    }

    public static void assertText(Text control, String before, String keySeq, String after) {
        TestUtils.forceText(control, before);
        TestUtils.checkText(control, before);
        TestUtils.checkSelection(control, before);
        TestUtils.checkCaret(control, before);
        control.setFocus();
        UITestHelper.sendString((Display)control.getDisplay(), (String)keySeq);
        TestUtils.checkText(control, after);
        TestUtils.checkCaret(control, after);
    }

    public static void assertText(Text control, String before, int keyCode, String after) {
        TestUtils.forceText(control, before);
        TestUtils.checkText(control, before);
        TestUtils.checkSelection(control, before);
        TestUtils.checkCaret(control, before);
        control.setFocus();
        UITestHelper.sendKeyAction((Display)control.getDisplay(), (int)keyCode);
        TestUtils.checkText(control, after);
        TestUtils.checkCaret(control, after);
    }

    public static boolean isArabLocaleAvailable() {
        Locale arabLocale = new Locale("ar", "AE");
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale availableLocale = localeArray[n2];
            if (availableLocale.equals(arabLocale)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getLocalizedNumber(String number) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        char decimalSep = dfs.getDecimalSeparator();
        char groupingSep = dfs.getGroupingSeparator();
        String result = number.replace('.', '_').replace(',', decimalSep).replace('_', groupingSep);
        return result;
    }

    public static void printMarkers(IMarkable markable) {
        Collection markers = markable.getMarkers();
        System.out.println(String.format("Have %d markers::", markers.size()));
        for (IMarker m : markers) {
            System.out.println(m.toString());
        }
    }

    private static void checkText(Text control, String input) {
        String expected = TestUtils.removePositionMarkers(input);
        Assert.assertEquals((String)expected, (String)control.getText());
    }

    private static void checkSelection(Text control, String input) {
        int start = input.indexOf(94);
        int end = input.lastIndexOf(94);
        String expected = "";
        if (start < end) {
            expected = input.substring(start + 1, end);
        }
        Assert.assertEquals((String)expected, (String)control.getSelectionText());
    }

    private static void checkCaret(Text control, String input) {
        int start = input.indexOf(94);
        if (start != -1) {
            int end = input.lastIndexOf(94);
            int expected = start < end ? end - 1 : end;
            Assert.assertEquals((int)expected, (int)control.getCaretPosition());
        }
    }

    private static int getColumnWidth(Control control, int colIndex) {
        if (control instanceof Tree) {
            return ((Tree)control).getColumn(colIndex).getWidth();
        }
        if (control instanceof Table) {
            return ((Table)control).getColumn(colIndex).getWidth();
        }
        if (control instanceof Grid) {
            return ((Grid)control).getColumn(colIndex).getWidth();
        }
        throw new IllegalArgumentException("unsupported control: " + control);
    }

    private static String removePositionMarkers(String input) {
        StringBuilder result = new StringBuilder(input.length());
        int i = 0;
        while (i < input.length()) {
            char ch = input.charAt(i);
            if (ch != '^') {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    private static void forceText(Text control, String text) {
        int start = text.indexOf(94);
        int end = text.lastIndexOf(94);
        SWTFacade facade = SWTFacade.getDefault();
        Object[] listeners = facade.removeListeners((Control)control, 25);
        control.setText(TestUtils.removePositionMarkers(text));
        facade.addListeners((Control)control, 25, listeners);
        control.setFocus();
        if (start == end) {
            control.setSelection(start, start);
        } else {
            control.setSelection(start, end - 1);
        }
    }
}

