/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.IModuleGroupNodeExtension;
import org.eclipse.riena.navigation.IModuleNodeExtension;
import org.eclipse.riena.navigation.INavigationAssembler;
import org.eclipse.riena.navigation.INavigationAssemblyExtension;
import org.eclipse.riena.navigation.ISubApplicationNodeExtension;
import org.eclipse.riena.navigation.ISubModuleNodeExtension;
import org.eclipse.riena.navigation.extension.IModuleGroupNode2Extension;
import org.eclipse.riena.navigation.extension.IModuleNode2Extension;
import org.eclipse.riena.navigation.extension.INavigationAssembly2Extension;
import org.eclipse.riena.navigation.extension.ISubApplicationNode2Extension;
import org.eclipse.riena.navigation.model.AssembliesConverter;
import org.eclipse.riena.navigation.model.TestSecondModuleGroupNodeAssembler;
import org.eclipse.riena.ui.ridgets.controller.IController;

@NonUITestCase
public class AssembliesConverterTest
extends TestCase {
    public void testConvertINavigationAssemblyExtension() {
        INavigationAssemblyExtension legacyAssembly = new INavigationAssemblyExtension(){

            public ISubApplicationNodeExtension getSubApplicationNode() {
                return null;
            }

            public IModuleGroupNodeExtension getModuleGroupNode() {
                return new IModuleGroupNodeExtension(){

                    public String getTypeId() {
                        return "typeMg1";
                    }

                    public String getInstanceId() {
                        return null;
                    }

                    public INavigationAssemblyExtension[] getAssemblies() {
                        return null;
                    }

                    public IModuleNodeExtension[] getModuleNodes() {
                        return null;
                    }

                    public IModuleNodeExtension[] getChildNodes() {
                        return null;
                    }
                };
            }

            public IModuleNodeExtension getModuleNode() {
                return null;
            }

            public ISubModuleNodeExtension getSubModuleNode() {
                return null;
            }

            public INavigationAssembler createNavigationAssembler() {
                return new TestSecondModuleGroupNodeAssembler();
            }

            public String getNavigationAssembler() {
                return "dummyAssembler";
            }

            public String getParentNodeId() {
                return "0815";
            }

            public int getStartOrder() {
                return 123;
            }

            public String getId() {
                return "4711";
            }
        };
        INavigationAssembly2Extension assembly2 = AssembliesConverter.convert((INavigationAssemblyExtension)legacyAssembly);
        AssembliesConverterTest.assertNotNull((Object)assembly2);
        AssembliesConverterTest.assertEquals((String)"4711", (String)assembly2.getId());
        AssembliesConverterTest.assertEquals((String)"0815", (String)assembly2.getParentNodeId());
        AssembliesConverterTest.assertEquals((int)123, (int)assembly2.getStartOrder());
        AssembliesConverterTest.assertEquals((String)"dummyAssembler", (String)assembly2.getNavigationAssembler());
        AssembliesConverterTest.assertTrue((boolean)(assembly2.createNavigationAssembler() instanceof TestSecondModuleGroupNodeAssembler));
        AssembliesConverterTest.assertEquals((int)0, (int)assembly2.getSubApplications().length);
        AssembliesConverterTest.assertEquals((int)1, (int)assembly2.getModuleGroups().length);
        AssembliesConverterTest.assertEquals((String)"typeMg1", (String)assembly2.getModuleGroups()[0].getNodeId());
        AssembliesConverterTest.assertEquals((int)0, (int)assembly2.getModules().length);
        AssembliesConverterTest.assertEquals((int)0, (int)assembly2.getSubModules().length);
    }

    public void testConvertISubApplicationNodeExtension() {
        ISubApplicationNodeExtension legacySubApp = new ISubApplicationNodeExtension(){

            public String getLabel() {
                return "subAppLabel";
            }

            public String getIcon() {
                return "subAppIcon";
            }

            public String getViewId() {
                return "p2";
            }

            public IModuleGroupNodeExtension[] getModuleGroupNodes() {
                return this.getChildNodes();
            }

            public IModuleGroupNodeExtension[] getChildNodes() {
                return new IModuleGroupNodeExtension[]{new IModuleGroupNodeExtension(){

                    public IModuleNodeExtension[] getModuleNodes() {
                        return null;
                    }

                    public IModuleNodeExtension[] getChildNodes() {
                        return null;
                    }

                    public String getTypeId() {
                        return "mgId";
                    }

                    public String getInstanceId() {
                        return null;
                    }

                    public INavigationAssemblyExtension[] getAssemblies() {
                        return null;
                    }
                }};
            }

            public String getTypeId() {
                return "subAppId";
            }

            public String getInstanceId() {
                return null;
            }

            public INavigationAssemblyExtension[] getAssemblies() {
                return null;
            }
        };
        ISubApplicationNode2Extension subApp2 = (ISubApplicationNode2Extension)ReflectionUtils.invokeHidden(AssembliesConverter.class, (String)"convert", (Object[])new Object[]{legacySubApp});
        AssembliesConverterTest.assertNotNull((Object)subApp2);
        AssembliesConverterTest.assertEquals((String)"subAppLabel", (String)subApp2.getName());
        AssembliesConverterTest.assertEquals((String)"subAppIcon", (String)subApp2.getIcon());
        AssembliesConverterTest.assertEquals((String)"p2", (String)subApp2.getPerspectiveId());
        AssembliesConverterTest.assertEquals((String)"subAppId", (String)subApp2.getNodeId());
        AssembliesConverterTest.assertEquals((int)1, (int)subApp2.getChildNodes().length);
        AssembliesConverterTest.assertEquals((String)"mgId", (String)subApp2.getChildNodes()[0].getNodeId());
    }

    public void testConvertIModuleGroupNodeExtension() {
        IModuleGroupNodeExtension legacy = new IModuleGroupNodeExtension(){

            public IModuleNodeExtension[] getModuleNodes() {
                return this.getChildNodes();
            }

            public IModuleNodeExtension[] getChildNodes() {
                return new IModuleNodeExtension[]{new IModuleNodeExtension(){

                    public String getLabel() {
                        return null;
                    }

                    public String getIcon() {
                        return null;
                    }

                    public boolean isUnclosable() {
                        return false;
                    }

                    public ISubModuleNodeExtension[] getSubModuleNodes() {
                        return null;
                    }

                    public ISubModuleNodeExtension[] getChildNodes() {
                        return null;
                    }

                    public String getTypeId() {
                        return "m1";
                    }

                    public String getInstanceId() {
                        return null;
                    }

                    public INavigationAssemblyExtension[] getAssemblies() {
                        return null;
                    }
                }};
            }

            public String getTypeId() {
                return "mgId";
            }

            public String getInstanceId() {
                return null;
            }

            public INavigationAssemblyExtension[] getAssemblies() {
                return null;
            }
        };
        IModuleGroupNode2Extension mg2 = (IModuleGroupNode2Extension)ReflectionUtils.invokeHidden(AssembliesConverter.class, (String)"convert", (Object[])new Object[]{legacy});
        AssembliesConverterTest.assertNotNull((Object)mg2);
        AssembliesConverterTest.assertNull((Object)mg2.getName());
        AssembliesConverterTest.assertNull((Object)mg2.getIcon());
        AssembliesConverterTest.assertEquals((String)"mgId", (String)mg2.getNodeId());
        AssembliesConverterTest.assertEquals((int)1, (int)mg2.getChildNodes().length);
        AssembliesConverterTest.assertEquals((String)"m1", (String)mg2.getChildNodes()[0].getNodeId());
    }

    public void testConvertIModuleNodeExtension() {
        IModuleNodeExtension legacy = new IModuleNodeExtension(){

            public ISubModuleNodeExtension[] getSubModuleNodes() {
                return this.getChildNodes();
            }

            public ISubModuleNodeExtension[] getChildNodes() {
                return new ISubModuleNodeExtension[]{new ISubModuleNodeExtension(){

                    public String getLabel() {
                        return null;
                    }

                    public String getIcon() {
                        return null;
                    }

                    public String getViewId() {
                        return null;
                    }

                    public boolean isShared() {
                        return false;
                    }

                    public ISubModuleNodeExtension[] getSubModuleNodes() {
                        return null;
                    }

                    public ISubModuleNodeExtension[] getChildNodes() {
                        return null;
                    }

                    public boolean isSelectable() {
                        return false;
                    }

                    public boolean isRequiresPreparation() {
                        return false;
                    }

                    public String getTypeId() {
                        return "sm1";
                    }

                    public String getInstanceId() {
                        return null;
                    }

                    public INavigationAssemblyExtension[] getAssemblies() {
                        return null;
                    }

                    public IController createController() {
                        return null;
                    }
                }};
            }

            public String getTypeId() {
                return "mId";
            }

            public String getInstanceId() {
                return null;
            }

            public INavigationAssemblyExtension[] getAssemblies() {
                return null;
            }

            public String getLabel() {
                return "mLabel";
            }

            public String getIcon() {
                return "mIcon";
            }

            public boolean isUnclosable() {
                return true;
            }
        };
        IModuleNode2Extension m2 = (IModuleNode2Extension)ReflectionUtils.invokeHidden(AssembliesConverter.class, (String)"convert", (Object[])new Object[]{legacy});
        AssembliesConverterTest.assertNotNull((Object)m2);
        AssembliesConverterTest.assertEquals((String)"mLabel", (String)m2.getName());
        AssembliesConverterTest.assertEquals((String)"mIcon", (String)m2.getIcon());
        AssembliesConverterTest.assertFalse((boolean)m2.isClosable());
        AssembliesConverterTest.assertEquals((String)"mId", (String)m2.getNodeId());
        AssembliesConverterTest.assertEquals((int)1, (int)m2.getChildNodes().length);
        AssembliesConverterTest.assertEquals((String)"sm1", (String)m2.getChildNodes()[0].getNodeId());
    }
}

