/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ui.swt.views.AbstractScrollingSupport;
import org.eclipse.riena.navigation.ui.swt.views.IModuleNavigationComponentProvider;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.navigation.ui.swt.views.ScrollBarNavigationCompositeDeligation;
import org.eclipse.riena.navigation.ui.swt.views.ScrollBarSupport;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class ScrollBarNavigationCompositeDeligationTest
extends TestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
        super.tearDown();
    }

    public void testCreateNavigationComposite() {
        ScrollBarNavigationCompositeDeligation deligation = new ScrollBarNavigationCompositeDeligation(null, (Composite)this.shell, (IModuleNavigationComponentProvider)new MockModuleNavigationComponentProvider());
        Composite comp = (Composite)ReflectionUtils.invokeHidden((Object)deligation, (String)"createNavigationComposite", (Object[])new Object[]{this.shell});
        ScrollBarNavigationCompositeDeligationTest.assertEquals(ScrolledComposite.class, comp.getParent().getClass());
        ScrolledComposite sc = (ScrolledComposite)comp.getParent();
        ScrollBarNavigationCompositeDeligationTest.assertSame((Object)comp, (Object)sc.getContent());
        AbstractScrollingSupport scrollingSupport = (AbstractScrollingSupport)ReflectionUtils.invokeHidden((Object)deligation, (String)"getScrollingSupport", (Object[])new Object[0]);
        ScrollBarNavigationCompositeDeligationTest.assertEquals(ScrollBarSupport.class, scrollingSupport.getClass());
    }

    public void testUpdateSize() {
        MockModuleNavigationComponentProvider navigationProvider = new MockModuleNavigationComponentProvider();
        ScrollBarNavigationCompositeDeligation deligation = new ScrollBarNavigationCompositeDeligation(null, (Composite)this.shell, (IModuleNavigationComponentProvider)navigationProvider);
        deligation.updateSize(123);
        ScrolledComposite scrolledComposite = (ScrolledComposite)ReflectionUtils.invokeHidden((Object)deligation, (String)"getScrolledComposite", (Object[])new Object[0]);
        ScrollBarNavigationCompositeDeligationTest.assertEquals((int)123, (int)scrolledComposite.getMinHeight());
        int width = deligation.getNavigationComposite().getSize().x;
        ScrollBarNavigationCompositeDeligationTest.assertEquals((int)width, (int)scrolledComposite.getMinWidth());
    }

    public void testGetScrolledComposite() {
        MockModuleNavigationComponentProvider navigationProvider = new MockModuleNavigationComponentProvider();
        ScrollBarNavigationCompositeDeligation deligation = new ScrollBarNavigationCompositeDeligation(null, (Composite)this.shell, (IModuleNavigationComponentProvider)navigationProvider);
        ScrolledComposite scrolledComposite = (ScrolledComposite)ReflectionUtils.invokeHidden((Object)deligation, (String)"getScrolledComposite", (Object[])new Object[0]);
        ScrollBarNavigationCompositeDeligationTest.assertNotNull((Object)scrolledComposite);
        ScrollBarNavigationCompositeDeligationTest.assertEquals(ScrolledComposite.class, scrolledComposite.getClass());
    }

    private class MockModuleNavigationComponentProvider
    implements IModuleNavigationComponentProvider {
        private MockModuleNavigationComponentProvider() {
        }

        public Composite getNavigationComponent() {
            return ScrollBarNavigationCompositeDeligationTest.this.shell;
        }

        public Composite getScrolledComponent() {
            return null;
        }

        public int calculateHeight() {
            return 0;
        }

        public ModuleGroupView getModuleGroupViewForNode(IModuleGroupNode moduleGroupNode) {
            return null;
        }

        public ModuleView getModuleViewForNode(IModuleNode moduleGroupNode) {
            return null;
        }

        public IModuleGroupNode getActiveModuleGroupNode() {
            return null;
        }

        public ISubApplicationNode getSubApplicationNode() {
            return null;
        }
    }
}

