/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.CComboRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.ComboRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.CompletionComboRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.eclipse.riena.ui.swt.facades.internal.CompletionComboRCP;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

@UITestCase
public class FocusManagerTest
extends TestCase {
    private Shell shell;
    private DefaultRealm realm;

    protected void setUp() throws Exception {
        super.setUp();
        this.realm = new DefaultRealm();
        this.shell = new Shell(147456);
        this.shell.setLayout((Layout)new RowLayout(512));
        this.shell.setSize(130, 100);
        this.shell.setLocation(0, 0);
        this.shell.open();
    }

    protected void tearDown() throws Exception {
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
        if (this.realm != null) {
            this.realm.dispose();
            this.realm = null;
        }
        super.tearDown();
    }

    public void testIsFocusable() {
        TextRidget textRidget = new TextRidget();
        textRidget.setUIControl((Object)new Text((Composite)this.shell, 2048));
        textRidget.setFocusable(true);
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)textRidget.getFocusManager(), (String)"isFocusable", (Object[])new Object[0]);
        FocusManagerTest.assertTrue((boolean)ret);
        textRidget.setFocusable(false);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)textRidget.getFocusManager(), (String)"isFocusable", (Object[])new Object[0]);
        FocusManagerTest.assertFalse((boolean)ret);
        textRidget.setFocusable(true);
        textRidget.setOutputOnly(true);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)textRidget.getFocusManager(), (String)"isFocusable", (Object[])new Object[0]);
        FocusManagerTest.assertFalse((boolean)ret);
        Event event = new Event();
        event.widget = textRidget.getUIControl();
        textRidget.getFocusManager().mouseDown(new MouseEvent(event));
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)textRidget.getFocusManager(), (String)"isFocusable", (Object[])new Object[0]);
        FocusManagerTest.assertTrue((boolean)ret);
    }

    public void testUpdateShowComboListFlag() {
        ComboRidget comboRidget = new ComboRidget();
        comboRidget.setUIControl((Object)new Combo((Composite)this.shell, 8));
        comboRidget.setFocusable(true);
        ReflectionUtils.invokeHidden((Object)comboRidget.getFocusManager(), (String)"updateShowComboListFlag", (Object[])new Object[]{comboRidget.getUIControl()});
        boolean showComboList = (Boolean)ReflectionUtils.getHidden((Object)comboRidget.getFocusManager(), (String)"showComboList");
        FocusManagerTest.assertFalse((boolean)showComboList);
        comboRidget.setFocusable(false);
        ReflectionUtils.invokeHidden((Object)comboRidget.getFocusManager(), (String)"updateShowComboListFlag", (Object[])new Object[]{comboRidget.getUIControl()});
        showComboList = (Boolean)ReflectionUtils.getHidden((Object)comboRidget.getFocusManager(), (String)"showComboList");
        FocusManagerTest.assertTrue((boolean)showComboList);
        CComboRidget ccomboRidget = new CComboRidget();
        ccomboRidget.setUIControl((Object)new CCombo((Composite)this.shell, 8));
        ccomboRidget.setFocusable(true);
        ReflectionUtils.invokeHidden((Object)ccomboRidget.getFocusManager(), (String)"updateShowComboListFlag", (Object[])new Object[]{ccomboRidget.getUIControl()});
        showComboList = (Boolean)ReflectionUtils.getHidden((Object)ccomboRidget.getFocusManager(), (String)"showComboList");
        FocusManagerTest.assertFalse((boolean)showComboList);
        ccomboRidget.setFocusable(false);
        ReflectionUtils.invokeHidden((Object)ccomboRidget.getFocusManager(), (String)"updateShowComboListFlag", (Object[])new Object[]{ccomboRidget.getUIControl()});
        showComboList = (Boolean)ReflectionUtils.getHidden((Object)ccomboRidget.getFocusManager(), (String)"showComboList");
        FocusManagerTest.assertTrue((boolean)showComboList);
        CompletionComboRidget completionComboRidget = new CompletionComboRidget();
        completionComboRidget.setUIControl((Object)new CompletionComboRCP((Composite)this.shell, 8));
        completionComboRidget.setFocusable(true);
        ReflectionUtils.invokeHidden((Object)completionComboRidget.getFocusManager(), (String)"updateShowComboListFlag", (Object[])new Object[]{completionComboRidget.getUIControl()});
        showComboList = (Boolean)ReflectionUtils.getHidden((Object)completionComboRidget.getFocusManager(), (String)"showComboList");
        FocusManagerTest.assertFalse((boolean)showComboList);
        completionComboRidget.setFocusable(false);
        ReflectionUtils.invokeHidden((Object)completionComboRidget.getFocusManager(), (String)"updateShowComboListFlag", (Object[])new Object[]{completionComboRidget.getUIControl()});
        showComboList = (Boolean)ReflectionUtils.getHidden((Object)completionComboRidget.getFocusManager(), (String)"showComboList");
        FocusManagerTest.assertFalse((boolean)showComboList);
        TextRidget textRidget = new TextRidget();
        textRidget.setUIControl((Object)new Text((Composite)this.shell, 2048));
        textRidget.setFocusable(true);
        ReflectionUtils.invokeHidden((Object)textRidget.getFocusManager(), (String)"updateShowComboListFlag", (Object[])new Object[]{textRidget.getUIControl()});
        showComboList = (Boolean)ReflectionUtils.getHidden((Object)textRidget.getFocusManager(), (String)"showComboList");
        FocusManagerTest.assertFalse((boolean)showComboList);
        textRidget.setFocusable(false);
        ReflectionUtils.invokeHidden((Object)textRidget.getFocusManager(), (String)"updateShowComboListFlag", (Object[])new Object[]{textRidget.getUIControl()});
        showComboList = (Boolean)ReflectionUtils.getHidden((Object)textRidget.getFocusManager(), (String)"showComboList");
        FocusManagerTest.assertFalse((boolean)showComboList);
    }

    public void testShowComboList() {
        CComboRidget ccomboRidget = new CComboRidget();
        ccomboRidget.setUIControl((Object)new CCombo((Composite)this.shell, 8));
        ReflectionUtils.setHidden((Object)ccomboRidget.getFocusManager(), (String)"showComboList", (Object)true);
        ReflectionUtils.invokeHidden((Object)ccomboRidget.getFocusManager(), (String)"showComboList", (Object[])new Object[]{ccomboRidget.getUIControl()});
        FocusManagerTest.assertTrue((boolean)ccomboRidget.getUIControl().getListVisible());
        boolean showComboList = (Boolean)ReflectionUtils.getHidden((Object)ccomboRidget.getFocusManager(), (String)"showComboList");
        FocusManagerTest.assertFalse((boolean)showComboList);
        ccomboRidget.getUIControl().setListVisible(false);
        ReflectionUtils.invokeHidden((Object)ccomboRidget.getFocusManager(), (String)"showComboList", (Object[])new Object[]{ccomboRidget.getUIControl()});
        FocusManagerTest.assertFalse((boolean)ccomboRidget.getUIControl().getListVisible());
    }
}

