/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt.optional;

import org.eclipse.core.runtime.Assert;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.DefaultCellRenderer;
import org.eclipse.riena.internal.ui.ridgets.swt.optional.GridRidget;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Widget;

public class GridRidgetCellRenderer
extends DefaultCellRenderer {
    private final GridRidget ridget;
    private static final Color BORDER_COLOR = LnfManager.getLnf().getColor("errorMarker.borderColor");
    private static final int BORDER_THICKNESS = LnfManager.getLnf().getIntegerSetting("rwErrorMarker.borderthickness", Integer.valueOf(1));

    public GridRidgetCellRenderer(GridRidget ridget) {
        this.ridget = ridget;
    }

    public void paint(GC gc, Object value) {
        Assert.isTrue((boolean)(value instanceof GridItem));
        GridItem item = (GridItem)value;
        Grid grid = item.getParent();
        super.paint(gc, value);
        if (!grid.isEnabled()) {
            gc.setBackground(this.getDisplay().getSystemColor(22));
            gc.fillRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        } else if (this.isMarked(item)) {
            this.markRow(gc, item);
        }
    }

    private boolean isMarked(GridItem item) {
        if (this.ridget == null) {
            return false;
        }
        return this.ridget.isErrorMarked((Widget)item);
    }

    private void markRow(GC gc, GridItem item) {
        Color oldForeground = gc.getForeground();
        gc.setForeground(BORDER_COLOR);
        try {
            int i;
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            int colCount = this.ridget.getColumnCount();
            if (colCount > 0) {
                i = 0;
                while (i < colCount) {
                    Rectangle bounds = item.getBounds(i);
                    if (i == 0) {
                        x = bounds.x;
                        y = bounds.y;
                    }
                    width += bounds.width;
                    height = Math.max(height, bounds.height);
                    ++i;
                }
                width = Math.max(0, width - 1);
                height = Math.max(0, height - 1);
            }
            if (width > 0) {
                i = 0;
                while (i < BORDER_THICKNESS) {
                    int arc = 3;
                    if (i > 0) {
                        arc = 0;
                    }
                    gc.drawRoundRectangle(x + i, y + i, width - 2 * i, height - 2 * i, arc, arc);
                    ++i;
                }
            }
        }
        finally {
            gc.setForeground(oldForeground);
        }
    }
}

