/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.ui.ridgets.ICComboRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractComboRidget;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

public class CComboRidget
extends AbstractComboRidget
implements ICComboRidget {
    private static final String ORIGINAL_BACKGROUND_KEY = "CCR.orBaKe";
    private final ModifyListener modifyListener = new CComboModifyListener();

    public CComboRidget() {
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (CComboRidget.this.getUIControl() != null) {
                    boolean isEnabled = (Boolean)evt.getNewValue();
                    CComboRidget.this.updateBgColor(isEnabled);
                }
            }
        });
    }

    public CCombo getUIControl() {
        return (CCombo)super.getUIControl();
    }

    protected void addSelectionListener(SelectionListener listener) {
        this.getUIControl().addSelectionListener(listener);
    }

    protected void addTextModifyListener() {
        this.getUIControl().addModifyListener(this.modifyListener);
    }

    protected void bindUIControl() {
        super.bindUIControl();
        if (this.getUIControl() != null) {
            this.updateBgColor(this.isEnabled());
        }
    }

    protected void checkUIControl(Object uiControl) {
        int style;
        this.checkType(uiControl, CCombo.class);
        if (uiControl != null && ((style = ((CCombo)uiControl).getStyle()) & 8) == 0) {
            throw new BindingException("Combo must be READ_ONLY");
        }
    }

    protected void clearUIControlListSelection() {
        this.getUIControl().deselectAll();
        this.getUIControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                CCombo combo = CComboRidget.this.getUIControl();
                if (combo != null && !combo.isDisposed()) {
                    combo.clearSelection();
                }
            }
        });
    }

    protected String[] getUIControlItems() {
        return this.getUIControl().getItems();
    }

    protected IObservableList getUIControlItemsObservable() {
        return SWTObservables.observeItems((Control)this.getUIControl());
    }

    protected ISWTObservableValue getUIControlSelectionObservable() {
        return SWTObservables.observeSelection((Control)this.getUIControl());
    }

    protected String getUIControlText() {
        return this.getUIControl().getText();
    }

    protected int indexOfInUIControl(String item) {
        return this.getUIControl().indexOf(item);
    }

    protected void removeAllFromUIControl() {
        this.getUIControl().removeAll();
    }

    protected void removeSelectionListener(SelectionListener listener) {
        this.getUIControl().removeSelectionListener(listener);
    }

    protected void removeTextModifyListener() {
        this.getUIControl().removeModifyListener(this.modifyListener);
    }

    protected void selectInUIControl(int index) {
        this.getUIControl().select(index);
    }

    protected void setItemsToControl(String[] arrItems) {
        this.getUIControl().setItems(arrItems);
    }

    protected void setTextToControl(String text) {
        this.getUIControl().setText(text);
    }

    protected void updateEditable() {
    }

    private void updateBgColor(boolean isEnabled) {
        CCombo control = this.getUIControl();
        if (isEnabled) {
            if (control.getData(ORIGINAL_BACKGROUND_KEY) != null) {
                control.setBackground((Color)control.getData(ORIGINAL_BACKGROUND_KEY));
                control.setData(ORIGINAL_BACKGROUND_KEY, null);
            }
        } else {
            if (control.getData(ORIGINAL_BACKGROUND_KEY) == null) {
                control.setData(ORIGINAL_BACKGROUND_KEY, (Object)control.getBackground());
            }
            Color disabledBg = control.getDisplay().getSystemColor(22);
            control.setBackground(disabledBg);
        }
        this.updateMarkers();
    }

    private final class CComboModifyListener
    implements ModifyListener {
        private CComboModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (!CComboRidget.this.isOutputOnly()) {
                CComboRidget.this.setText(CComboRidget.this.getUIControlText());
            }
        }
    }
}

