/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.internal.ui.ridgets.swt.AbstractTraverseRidget;
import org.eclipse.riena.ui.ridgets.ISliderRidget;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Slider;

public class SliderRidget
extends AbstractTraverseRidget
implements ISliderRidget {
    private int thumb = Integer.MIN_VALUE;

    public void checkUIControl(Object uiControl) {
        this.checkType(uiControl, Slider.class);
    }

    public int getThumb() {
        return this.thumb;
    }

    public Slider getUIControl() {
        return (Slider)super.getUIControl();
    }

    public void setThumb(int thumb) {
        this.checkThumb(thumb);
        Integer oldValue = this.thumb;
        this.thumb = thumb;
        this.updateUIThumb();
        this.firePropertyChange("thumb", oldValue, this.thumb);
    }

    protected void addSelectionListener(Control control, SelectionListener listener) {
        ((Slider)control).addSelectionListener(listener);
    }

    protected void checkMaximum(int maximum) {
        if (!this.initialized) {
            return;
        }
        if (this.calcInternalMaximum(maximum) <= this.getMinimum()) {
            new Message("The maximum value subtract thumb (%d - %d) must be greater than the minimum value of %d", maximum, this.getThumb(), this.getMinimum()).push();
        }
        if (maximum <= 0) {
            new Message("The maximum value of %d must be greater than zero", maximum, this.getThumb(), this.getMinimum()).push();
        }
    }

    protected void checkMinimum(int minimum) {
        if (!this.initialized) {
            return;
        }
        if (minimum >= this.calcInternalMaximum()) {
            new Message("The minimum value of %d must be lower than the maximum value subtract thumb (%d - %d)", minimum, this.getMaximum(), this.getThumb()).push();
        }
        if (minimum < 0) {
            new Message("The minimum value of %d must be greater than zero", minimum).push();
        }
    }

    protected void checkThumb(int thumb) {
        if (thumb <= 0) {
            new Message("The thumb value of %d must be greater than zero", thumb).push();
        }
        if (thumb >= this.getMaximum() - this.getMinimum()) {
            new Message("The thumb value of %d must be lower than maximum subtract minimum (%d - %d)", thumb, this.getMaximum(), this.getMinimum()).push();
        }
    }

    protected int getValue(Control control) {
        return this.getUIControl() != null ? this.getUIControl().getSelection() : 0;
    }

    protected void initAdditionalsFromUIControl() {
        Slider slider = this.getUIControl();
        if (slider != null && this.getThumb() == Integer.MIN_VALUE) {
            this.setThumb(slider.getThumb());
        }
    }

    protected int preSetIncrement(int increment) {
        if (!this.initialized) {
            return increment;
        }
        if (increment <= 0) {
            increment = 1;
        } else if (increment > this.calcInternalMaximum() - this.getMinimum()) {
            increment = this.calcInternalMaximum() - this.getMinimum();
        }
        return increment;
    }

    protected int preSetMaximum(int maximum) {
        int deltaMaxMin;
        if (!this.initialized) {
            return maximum;
        }
        if (this.calcInternalMaximum(maximum) < this.getValue()) {
            this.setValue(this.calcInternalMaximum(maximum));
        }
        if ((deltaMaxMin = this.calcInternalMaximum(maximum) - this.getMinimum()) < this.getIncrement()) {
            this.setIncrement(deltaMaxMin);
        }
        if (deltaMaxMin < this.getPageIncrement()) {
            this.setPageIncrement(deltaMaxMin);
        }
        return maximum;
    }

    protected int preSetMinimum(int minimum) {
        int deltaMaxMin;
        if (!this.initialized) {
            return minimum;
        }
        if (this.getValue() < minimum) {
            this.setValue(minimum);
        }
        if ((deltaMaxMin = this.calcInternalMaximum() - minimum) < this.getIncrement()) {
            this.setIncrement(deltaMaxMin);
        }
        if (deltaMaxMin < this.getPageIncrement()) {
            this.setPageIncrement(deltaMaxMin);
        }
        return minimum;
    }

    protected int preSetPageIncrement(int pageIncrement) {
        if (!this.initialized) {
            return pageIncrement;
        }
        if (pageIncrement <= 0) {
            pageIncrement = 1;
        } else if (pageIncrement > this.calcInternalMaximum() - this.getMinimum()) {
            pageIncrement = this.calcInternalMaximum() - this.getMinimum();
        }
        return pageIncrement;
    }

    protected int preSetValue(int value) {
        if (!this.initialized) {
            return value;
        }
        if (value < 0 || value < this.getMinimum()) {
            value = this.getMinimum();
        }
        if (value > this.calcInternalMaximum()) {
            value = this.calcInternalMaximum();
        }
        return value;
    }

    protected void removeSelectionListener(Control control, SelectionListener listener) {
        ((Slider)control).removeSelectionListener(listener);
    }

    protected void updateUIControl() {
        this.updateUIMaximum();
        this.updateUIThumb();
        this.updateUIMinimum();
        this.updateUIIncrement();
        this.updateUIPageIncrement();
        this.updateUIValue();
    }

    protected void updateUIIncrement() {
        Slider control = this.getUIControl();
        if (control != null) {
            control.setIncrement(this.getIncrement());
        }
    }

    protected void updateUIMaximum() {
        Slider control = this.getUIControl();
        if (control != null) {
            control.setMaximum(this.getMaximum());
        }
    }

    protected void updateUIMinimum() {
        Slider control = this.getUIControl();
        if (control != null) {
            control.setMinimum(this.getMinimum());
        }
    }

    protected void updateUIPageIncrement() {
        Slider control = this.getUIControl();
        if (control != null) {
            control.setPageIncrement(this.getPageIncrement());
        }
    }

    protected void updateUIThumb() {
        Slider control = this.getUIControl();
        if (control != null) {
            control.setThumb(this.getThumb());
        }
    }

    protected void updateUIValue() {
        Slider control = this.getUIControl();
        if (control != null) {
            control.setSelection(this.getValue());
        }
    }

    private int calcInternalMaximum() {
        return this.calcInternalMaximum(this.getMaximum());
    }

    private int calcInternalMaximum(int maximum) {
        return maximum - this.getThumb();
    }

    protected int getUIControlIncrement() {
        return this.getUIControl().getIncrement();
    }

    protected int getUIControlMaximum() {
        return this.getUIControl().getMaximum();
    }

    protected int getUIControlMinimum() {
        return this.getUIControl().getMinimum();
    }

    protected int getUIControlPageIncrement() {
        return this.getUIControl().getPageIncrement();
    }

    protected int getUIControlSelection() {
        return this.getUIControl().getSelection();
    }

    protected static class Message
    extends AbstractTraverseRidget.Message {
        public static final String MAX_LE_MIN = "The maximum value subtract thumb (%d - %d) must be greater than the minimum value of %d";
        public static final String MIN_GE_MAX = "The minimum value of %d must be lower than the maximum value subtract thumb (%d - %d)";
        public static final String THUMB_LE_ZERO = "The thumb value of %d must be greater than zero";
        public static final String THUMB_GE_RANGE = "The thumb value of %d must be lower than maximum subtract minimum (%d - %d)";

        public Message(String msgConstant, Object ... attributes) {
            super(msgConstant, attributes);
        }
    }
}

