/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.marker.AbstractMarker;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.RAPDetector;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.ICustomMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.NegativeMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IControlDecoration;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractActionRidget;
import org.eclipse.riena.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.riena.ui.swt.CompletionCombo;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerSupport
extends BasicMarkerSupport {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), MarkerSupport.class);
    private static final String PRE_MANDATORY_BACKGROUND_KEY = "MaSu.preMaBa";
    private static final String PRE_OUTPUT_BACKGROUND_KEY = "MaSu.preOuBa";
    private static final String PRE_OUTPUT_FOREGROUND_KEY = "MaSu.preOuFo";
    private static final String PRE_NEGATIVE_FOREGROUND_KEY = "MaSu.preNeFo";
    private static final String ERROR_DECORATION_FOR_CONTROL_KEY = "MaSu.errDe";
    private static final long FLASH_DURATION_MS = 300L;
    private static final boolean HIDE_DISABLED_RIDGET_CONTENT = Boolean.parseBoolean(System.getProperty("HIDE_DISABLED_RIDGET_CONTENT", Boolean.FALSE.toString()));
    private static Boolean hideDisabledRidgetContent;
    private boolean isFlashInProgress;
    private final Map<String, Object> internalData = new HashMap<String, Object>();

    public static boolean isHideDisabledRidgetContent() {
        if (hideDisabledRidgetContent == null) {
            hideDisabledRidgetContent = LnfManager.getLnf().getBooleanSetting("DisabledMarker.advancedContent", HIDE_DISABLED_RIDGET_CONTENT);
        }
        return hideDisabledRidgetContent;
    }

    public MarkerSupport() {
    }

    public MarkerSupport(IBasicMarkableRidget ridget, PropertyChangeSupport propertyChangeSupport) {
        super(ridget, propertyChangeSupport);
    }

    public final synchronized void flash() {
        final Control control = this.getUIControl();
        if (!this.isFlashInProgress && control != null) {
            this.isFlashInProgress = true;
            IControlDecoration errorDecoration = this.getOrCreateErrorDecorationForControl(control);
            boolean isShowing = errorDecoration.isVisible();
            if (isShowing) {
                errorDecoration.hide();
            } else {
                errorDecoration.show();
            }
            final Display display = control.getDisplay();
            Runnable op = new Runnable(){

                public void run() {
                    block5: {
                        try {
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException interruptedException) {
                                Nop.reason((String)"ignore");
                                display.syncExec(new Runnable(control){
                                    private final /* synthetic */ Control val$control;
                                    {
                                        this.val$control = control;
                                    }

                                    public void run() {
                                        if (!this.val$control.isDisposed()) {
                                            MarkerSupport.this.updateError(this.val$control);
                                        }
                                    }
                                });
                                MarkerSupport.this.isFlashInProgress = false;
                                break block5;
                            }
                        }
                        catch (Throwable throwable) {
                            display.syncExec(new /* invalid duplicate definition of identical inner class */);
                            MarkerSupport.this.isFlashInProgress = false;
                            throw throwable;
                        }
                        display.syncExec(new /* invalid duplicate definition of identical inner class */);
                        MarkerSupport.this.isFlashInProgress = false;
                    }
                }
            };
            new Thread(op).start();
        }
    }

    protected void addError(Control control) {
        this.getOrCreateErrorDecorationForControl(control).show();
    }

    protected void addMandatory(Control control) {
        if (this.getData(PRE_MANDATORY_BACKGROUND_KEY) == null) {
            this.setData(PRE_MANDATORY_BACKGROUND_KEY, this.getControlBackground(control));
        }
        Color color = this.getMandatoryBackground();
        if (control instanceof CompletionCombo) {
            ((CompletionCombo)control).setTextBackground(color);
        } else {
            control.setBackground(color);
        }
    }

    protected void addOutput(Control control, Color foreground, Color background) {
        if (foreground != null && this.getData(PRE_OUTPUT_FOREGROUND_KEY) == null) {
            Color preForeground = this.getControlForeground(control);
            this.setData(PRE_OUTPUT_FOREGROUND_KEY, preForeground);
            control.setForeground(foreground);
        }
        if (background != null && this.getData(PRE_OUTPUT_BACKGROUND_KEY) == null) {
            Color preBackground = this.getControlBackground(control);
            this.setData(PRE_OUTPUT_BACKGROUND_KEY, preBackground);
            control.setBackground(background);
        }
    }

    private Color getControlBackground(Control control) {
        Control backgroundControl = this.getControlWithColor(control);
        return backgroundControl.getBackground();
    }

    private Color getControlForeground(Control control) {
        Control foregroundControl = this.getControlWithColor(control);
        return foregroundControl.getForeground();
    }

    private Control getControlWithColor(Control control) {
        if (control instanceof CCombo && !RAPDetector.isRAPavailable()) {
            try {
                Control list = (Control)ReflectionUtils.getHidden((Object)control, (String)"list");
                return list;
            }
            catch (RuntimeException ex) {
                LOGGER.log(2, "Unexpected error when accessing field 'list' in CCombo.", (Throwable)ex);
            }
        }
        return control;
    }

    @Override
    protected void clearAllMarkers(Control control) {
        super.clearAllMarkers(control);
        this.clearError(control);
        this.clearMandatory(control);
        this.clearNegative(control);
        this.clearOutput(control);
    }

    protected void clearError(Control control) {
        IControlDecoration errorDecoration = this.getErrorDecorationForControl(control);
        if (errorDecoration != null) {
            errorDecoration.hide();
        }
    }

    protected void clearMandatory(Control control) {
        if (this.getData(PRE_MANDATORY_BACKGROUND_KEY) != null) {
            control.setBackground((Color)this.getData(PRE_MANDATORY_BACKGROUND_KEY));
            this.setData(PRE_MANDATORY_BACKGROUND_KEY, null);
        }
    }

    protected void clearOutput(Control control) {
        Color data;
        if (this.getData(PRE_OUTPUT_FOREGROUND_KEY) != null) {
            data = (Color)this.getData(PRE_OUTPUT_FOREGROUND_KEY);
            control.setForeground(data);
            this.setData(PRE_OUTPUT_FOREGROUND_KEY, null);
        }
        if (this.getData(PRE_OUTPUT_BACKGROUND_KEY) != null) {
            data = (Color)this.getData(PRE_OUTPUT_BACKGROUND_KEY);
            control.setBackground(data);
            this.setData(PRE_OUTPUT_BACKGROUND_KEY, null);
        }
    }

    protected IControlDecoration createErrorDecoration(Control control) {
        return new MarkerControlDecoration(control);
    }

    protected IMarkableRidget getRidget() {
        return (IMarkableRidget)super.getRidget();
    }

    @Override
    protected void updateUIControl(Control control) {
        super.updateUIControl(control);
        this.updateOutput(control);
        this.updateMandatory(control);
        this.updateError(control);
        this.updateNegative(control);
    }

    private IControlDecoration getErrorDecorationForControl(Control control) {
        return (IControlDecoration)control.getData(ERROR_DECORATION_FOR_CONTROL_KEY);
    }

    private IControlDecoration getOrCreateErrorDecorationForControl(Control control) {
        if (this.getErrorDecorationForControl(control) == null) {
            control.setData(ERROR_DECORATION_FOR_CONTROL_KEY, (Object)this.createErrorDecoration(control));
        }
        return this.getErrorDecorationForControl(control);
    }

    private void addNegative(Control control) {
        if (this.getData(PRE_NEGATIVE_FOREGROUND_KEY) == null) {
            this.setData(PRE_NEGATIVE_FOREGROUND_KEY, control.getForeground());
            control.setForeground(this.getNegativeForeground());
        }
    }

    private void clearNegative(Control control) {
        if (this.getData(PRE_NEGATIVE_FOREGROUND_KEY) != null) {
            control.setForeground((Color)this.getData(PRE_NEGATIVE_FOREGROUND_KEY));
            this.setData(PRE_NEGATIVE_FOREGROUND_KEY, null);
        }
    }

    private Object getData(String key) {
        return this.internalData.get(key);
    }

    private boolean isButton(Control control) {
        return control instanceof Button || this.getRidget() instanceof AbstractActionRidget;
    }

    private boolean isHidden(Class<? extends IMarker> type) {
        for (Class marker : this.getHiddenMarkerTypes()) {
            if (!marker.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    private boolean isMandatory(IMarkableRidget ridget) {
        boolean result = false;
        Iterator iter = this.getRidget().getMarkersOfType(MandatoryMarker.class).iterator();
        while (!result && iter.hasNext()) {
            boolean bl = result = !((MandatoryMarker)iter.next()).isDisabled();
        }
        return result;
    }

    private void setData(String key, Object value) {
        this.internalData.put(key, value);
    }

    private void updateError(Control control) {
        if (this.getRidget().isErrorMarked() && this.getRidget().isEnabled() && this.getRidget().isVisible() && !this.isHidden(ErrorMarker.class)) {
            if (!this.isButton(control) || !this.getRidget().isOutputOnly()) {
                this.addError(control);
            } else {
                this.clearError(control);
            }
        } else {
            this.clearError(control);
        }
    }

    private void updateMandatory(Control control) {
        if (this.isMandatory(this.getRidget()) && !this.getRidget().isOutputOnly() && this.getRidget().isEnabled() && !this.isHidden(MandatoryMarker.class)) {
            this.addMandatory(control);
        } else {
            this.clearMandatory(control);
        }
    }

    private void updateNegative(Control control) {
        if (!this.getRidget().getMarkersOfType(NegativeMarker.class).isEmpty() && this.getRidget().isEnabled()) {
            this.addNegative(control);
        } else {
            this.clearNegative(control);
        }
    }

    private void updateOutput(Control control) {
        if (this.getRidget().isOutputOnly() && this.getRidget().isEnabled()) {
            this.clearMandatory(control);
            this.clearOutput(control);
            RienaDefaultLnf lnf = LnfManager.getLnf();
            if (this.isMandatory(this.getRidget()) && !this.isHidden(MandatoryMarker.class)) {
                Color bgColor = lnf.getColor("mandatoryOutputMarker.background");
                if (bgColor == null) {
                    bgColor = Activator.getSharedColor(control.getDisplay(), "COLOR_MANDATORY_OUTPUT");
                }
                this.addOutput(control, null, bgColor);
            } else if (!(control instanceof Button)) {
                Color fgColor = this.getOutputForeground();
                Color bgColor = this.getOutputBackground();
                this.addOutput(control, fgColor, bgColor);
            }
        } else {
            this.clearOutput(control);
        }
    }

    private Color getOutputForeground() {
        return this.getCustomForeground(OutputMarker.class);
    }

    private Color getOutputBackground() {
        Color color = this.getCustomBackground(OutputMarker.class);
        if (color == null) {
            RienaDefaultLnf lnf = LnfManager.getLnf();
            color = lnf.getColor("outputMarker.background");
        }
        return color;
    }

    private Color getMandatoryBackground() {
        RienaDefaultLnf lnf;
        Color color = this.getCustomBackground(MandatoryMarker.class);
        if (color == null && (color = (lnf = LnfManager.getLnf()).getColor("mandatoryMarker.background")) == null) {
            color = Activator.getSharedColor(this.getUIControl().getDisplay(), "COLOR_MANDATORY");
        }
        return color;
    }

    private Color getNegativeForeground() {
        Color color = this.getCustomForeground(NegativeMarker.class);
        if (color == null) {
            color = this.getUIControl().getDisplay().getSystemColor(3);
        }
        return color;
    }

    private Color getCustomForeground(Class<? extends AbstractMarker> type) {
        Collection markers = this.getRidget().getMarkersOfType(type);
        Color fgColor = null;
        for (IMarker marker : markers) {
            Object color;
            if (!(marker instanceof ICustomMarker) || !((color = ((ICustomMarker)marker).getForeground((IMarkable)this.getRidget())) instanceof Color)) continue;
            fgColor = (Color)color;
        }
        return fgColor;
    }

    private Color getCustomBackground(Class<? extends AbstractMarker> type) {
        Collection markers = this.getRidget().getMarkersOfType(type);
        Color bgColor = null;
        for (IMarker marker : markers) {
            Object color;
            if (!(marker instanceof ICustomMarker) || !((color = ((ICustomMarker)marker).getBackground((IMarkable)this.getRidget())) instanceof Color)) continue;
            bgColor = (Color)color;
        }
        return bgColor;
    }

    private static class MarkerControlDecoration
    extends ControlDecoration
    implements IControlDecoration {
        public MarkerControlDecoration(Control control) {
            super(control, MarkerControlDecoration.getDecorationPosition(), (Composite)MarkerControlDecoration.getScrolledComposite(control));
            this.setMarginWidth(MarkerControlDecoration.getErrorMarginWidth());
            this.setImage(MarkerControlDecoration.getDecorationImage());
            if (SWTFacade.isRCP()) {
                ReflectionUtils.invokeHidden((Object)((Object)this), (String)"update", null);
            }
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MarkerControlDecoration.this.dispose();
                }
            });
        }

        private static Image getDecorationImage() {
            Image result = null;
            RienaDefaultLnf lnf = LnfManager.getLnf();
            if (Platform.getBundle((String)"org.eclipse.riena.ui.ridgets.swt") != null) {
                result = lnf.getImage("ControlErrorMarker");
            }
            if (result == null) {
                result = Activator.getSharedImage("IMG_ERROR_DECO");
            }
            return result;
        }

        private static int getDecorationPosition() {
            int result = 0;
            RienaDefaultLnf lnf = LnfManager.getLnf();
            int hPos = lnf.getIntegerSetting("errorMarker.horizontalPosition", Integer.valueOf(16384));
            if (hPos == 131072 || hPos == 16384) {
                result |= hPos;
            } else {
                LOGGER.log(2, "Invalid horizonal error marker position!");
                result |= 0x4000;
            }
            int vPos = lnf.getIntegerSetting("errorMarker.verticalPosition", Integer.valueOf(128));
            if (vPos == 128 || vPos == 0x1000000 || vPos == 1024) {
                result |= vPos;
            } else {
                LOGGER.log(2, "Invalid vertical error marker position!");
                result |= 0x80;
            }
            return result;
        }

        private static int getErrorMarginWidth() {
            RienaDefaultLnf lnf = LnfManager.getLnf();
            return lnf.getIntegerSetting("errorMarker.margin", Integer.valueOf(1));
        }

        private static ScrolledComposite getScrolledComposite(Control control) {
            if (control == null) {
                return null;
            }
            if (control instanceof ScrolledComposite) {
                return (ScrolledComposite)control;
            }
            return MarkerControlDecoration.getScrolledComposite((Control)control.getParent());
        }
    }
}

