/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.holder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.ridgets.databinding.ConverterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectableListHolder<T> {
    public static final String PROP_LIST = "items";
    public static final String SELECTION_PROPERTY = "selection";
    private final List<T> items;
    private Class<T> guessedType;
    private T selection;
    protected static final Object EMPTY = new Object(){

        public String toString() {
            return "";
        }
    };

    public SelectableListHolder() {
        this(false);
    }

    public SelectableListHolder(boolean withEmtpy) {
        this.items = this.init(withEmtpy, null);
    }

    public SelectableListHolder(T ... items) {
        this(false, items);
    }

    public SelectableListHolder(boolean withEmtpy, T ... items) {
        this.items = this.init(withEmtpy, Arrays.asList(items));
    }

    public SelectableListHolder(List<T> items) {
        this(false, items);
    }

    public SelectableListHolder(boolean withEmtpy, List<T> items) {
        this.items = this.init(withEmtpy, items);
    }

    private List<T> init(boolean withEmpty, List<T> items) {
        this.guessedType = items != null && items.size() > 0 ? items.get(0).getClass() : EMPTY.getClass();
        ArrayList<Object> list = new ArrayList<Object>();
        if (withEmpty) {
            list.add(EMPTY);
        }
        if (items != null) {
            list.addAll(items);
        }
        return list;
    }

    public List<T> getItems() {
        return this.items;
    }

    public T getSelection() {
        return this.selection == EMPTY ? null : (T)this.selection;
    }

    public void setSelection(T selection) {
        this.selection = selection;
    }

    public void sortItems(Comparator<? super T> comparator) {
        Collections.sort(this.items, comparator);
    }

    public Class<?> getGuessedType() {
        return this.guessedType;
    }

    public ConverterFactory<T, String> getConverterFactory(String renderMethodName) {
        ConverterFactory<T, String> factory = new ConverterFactory<T, String>(this.guessedType, String.class);
        Method renderer = this.getRenderer(renderMethodName);
        for (T item : this.getItems()) {
            try {
                factory.add(item, item == EMPTY ? EMPTY.toString() : renderer.invoke(item, new Object[0]).toString());
            }
            catch (Exception e) {
                throw new BindingException("Invoking render method for type " + this.guessedType.getName() + " failed.", (Throwable)e);
            }
        }
        return factory;
    }

    private Method getRenderer(String renderMethodName) {
        try {
            Method renderMethod = this.guessedType.getMethod(StringUtils.isGiven((CharSequence)renderMethodName) ? renderMethodName : "toString", new Class[0]);
            if (renderMethod.getReturnType() != String.class) {
                throw new BindingException("Render method for type " + this.guessedType.getName() + " has not String as return type.");
            }
            return renderMethod;
        }
        catch (Exception e) {
            throw new BindingException("Could not find render method for type " + this.guessedType.getName(), (Throwable)e);
        }
    }
}

