/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.uibinding;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.core.util.ReflectionFailure;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.ui.ridgets.Activator;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.ridgets.IComplexRidget;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.SubModuleUtils;
import org.eclipse.riena.ui.ridgets.uibinding.CorrespondingLabelMapper;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingPropertyLocator;
import org.eclipse.riena.ui.ridgets.uibinding.IControlRidgetMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBindingManager
implements IBindingManager {
    private final IBindingPropertyLocator propertyStrategy;
    private final IControlRidgetMapper<Object> mapper;

    public DefaultBindingManager(IBindingPropertyLocator propertyStrategy, IControlRidgetMapper<Object> mapper) {
        this.propertyStrategy = propertyStrategy;
        this.mapper = mapper;
    }

    @Override
    public void injectRidgets(IRidgetContainer ridgetContainer, List<Object> uiControls) {
        CorrespondingLabelMapper ridgetMapper = new CorrespondingLabelMapper(ridgetContainer);
        if (Activator.getDefault() != null) {
            Wire.instance((Object)ridgetMapper).andStart(Activator.getDefault().getContext());
        }
        HashMap<String, IRidget> controls = new HashMap<String, IRidget>();
        for (Object control : uiControls) {
            String bindingProperty = this.propertyStrategy.locateBindingProperty(control);
            if (bindingProperty == null) continue;
            IRidget ridget = null;
            if (!SubModuleUtils.isPrepareView()) {
                ridget = (IRidget)ridgetContainer.getRidget(bindingProperty);
            }
            if (ridget == null) {
                ridget = this.createRidget(control);
            }
            this.injectRidget(ridgetContainer, bindingProperty, ridget);
            if (!(ridget instanceof ILabelRidget)) {
                controls.put(bindingProperty, ridget);
            }
            if (!(control instanceof IComplexComponent)) continue;
            IComplexRidget complexRidget = (IComplexRidget)ridget;
            IComplexComponent complexComponent = (IComplexComponent)control;
            this.injectRidgets(complexRidget, complexComponent.getUIControls());
        }
        for (Map.Entry entry : controls.entrySet()) {
            ridgetMapper.connectCorrespondingLabel((IRidget)entry.getValue(), (String)entry.getKey());
        }
        if (Activator.getDefault() != null) {
            Wire.instance((Object)ridgetContainer).andStart(Activator.getDefault().getContext());
        }
        if (!ridgetContainer.isConfigured() || SubModuleUtils.isPrepareView()) {
            ridgetContainer.configureRidgets();
            ridgetContainer.setConfigured(true);
        }
    }

    protected void injectRidget(IRidgetContainer ridgetContainer, String bindingProperty, IRidget ridget) {
        ridgetContainer.addRidget(bindingProperty, ridget);
        ridget.setController(ridgetContainer);
    }

    @Override
    public IRidget createRidget(Object control) throws ReflectionFailure {
        Class<IRidget> ridgetClass = this.mapper.getRidgetClass(control);
        try {
            return ridgetClass.newInstance();
        }
        catch (Exception e) {
            throw new ReflectionFailure(String.format("Could not instantiate ridget '%s' for control '%s'", ridgetClass, control), (Throwable)e);
        }
    }

    protected <R extends IRidget> R getRidget(String bindingProperty, IRidgetContainer controller) {
        return controller.getRidget(bindingProperty);
    }

    @Override
    public void bind(IRidgetContainer controller, List<Object> uiControls) {
        this.updateBindings(controller, uiControls, false);
    }

    @Override
    public void unbind(IRidgetContainer controller, List<Object> uiControls) {
        this.updateBindings(controller, uiControls, true);
    }

    private void updateBindings(IRidgetContainer controller, List<Object> uiControls, boolean unbind) {
        for (Object control : uiControls) {
            String bindingProperty = this.propertyStrategy.locateBindingProperty(control);
            if (bindingProperty == null) continue;
            if (control instanceof IComplexComponent) {
                IComplexComponent complexComponent = (IComplexComponent)control;
                IComplexRidget complexRidget = (IComplexRidget)this.getRidget(bindingProperty, controller);
                if (complexRidget == null) continue;
                this.updateBindings(complexRidget, complexComponent.getUIControls(), unbind);
                this.bindRidget(complexRidget, complexComponent, unbind);
                continue;
            }
            Object ridget = this.getRidget(bindingProperty, controller);
            if (ridget == null) continue;
            this.bindRidget((IRidget)ridget, control, unbind);
        }
    }

    private void bindRidget(IRidget ridget, Object uiControl, boolean unbind) {
        if (unbind) {
            ridget.setUIControl(null);
        } else {
            ridget.setUIControl(uiControl);
        }
    }
}

