/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.facades.internal;

import org.eclipse.riena.ui.swt.EmbeddedTitleBar;
import org.eclipse.riena.ui.swt.facades.internal.AbstractNavigationToolTip;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.EmbeddedTitlebarRenderer;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class EmbeddedTitleBarToolTip
extends AbstractNavigationToolTip {
    private final EmbeddedTitleBar embeddedTitleBar;

    public EmbeddedTitleBarToolTip(EmbeddedTitleBar parent) {
        super((Control)parent);
        this.embeddedTitleBar = parent;
        this.setShift(new Point(0, 0));
    }

    public Point getLocation(Point tipSize, Event event) {
        GC gc = new GC((Drawable)this.embeddedTitleBar);
        try {
            Point location;
            Rectangle bounds = this.getLnfTitlebarRenderer().computeTextBounds(gc);
            Point point = location = this.embeddedTitleBar.toDisplay(bounds.x, 0);
            return point;
        }
        finally {
            gc.dispose();
        }
    }

    protected boolean shouldCreateToolTip(Event event) {
        boolean should = super.shouldCreateToolTip(event);
        if (should) {
            if (this.embeddedTitleBar.getToolTipText() != null) {
                return true;
            }
            should = this.embeddedTitleBar.isTextClipped();
        }
        return should;
    }

    protected String getToolTipText(Event event) {
        String toolTipText = this.embeddedTitleBar.getToolTipText();
        if (toolTipText == null) {
            toolTipText = this.embeddedTitleBar.getTitle();
        }
        return toolTipText;
    }

    protected Integer getLnfDelay(RienaDefaultLnf lnf) {
        return lnf.getIntegerSetting("ModuleItemToolTip.popupDelay");
    }

    protected Font getLnfFont(RienaDefaultLnf lnf) {
        return lnf.getFont("ModuleItemToolTip.font");
    }

    protected Color getLnfBackground(RienaDefaultLnf lnf) {
        return lnf.getColor("ModuleItemToolTip.background");
    }

    protected Color getLnfForeground(RienaDefaultLnf lnf) {
        return lnf.getColor("ModuleItemToolTip.foreground");
    }

    private EmbeddedTitlebarRenderer getLnfTitlebarRenderer() {
        EmbeddedTitlebarRenderer renderer = (EmbeddedTitlebarRenderer)LnfManager.getLnf().getRenderer("SubModuleView.titlebarRenderer");
        if (renderer == null) {
            renderer = new EmbeddedTitlebarRenderer();
        }
        return renderer;
    }
}

