/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.ridgets.IControlDecoration;
import org.eclipse.riena.ui.swt.BorderDrawer;
import org.eclipse.riena.ui.swt.DatePickerComposite;
import org.eclipse.riena.ui.swt.IDecorationActivationStrategy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;

public class BorderControlDecoration
implements IControlDecoration {
    private final BorderDrawer borderDrawer;
    private boolean visible;

    public BorderControlDecoration(Control control) {
        this(control, 1);
    }

    public BorderControlDecoration(Control control, int borderWidth) {
        this(control, borderWidth, null);
    }

    public BorderControlDecoration(Control control, int borderWidth, Color borderColor) {
        this(control, borderWidth, borderColor, null);
    }

    public BorderControlDecoration(Control control, int borderWidth, Color borderColor, final IDecorationActivationStrategy activationStrategy) {
        this.borderDrawer = new BorderDrawer(this.getBorderControl(control), this.checkBorderWidth(borderWidth), borderColor, new IDecorationActivationStrategy(){

            public boolean isActive() {
                return BorderControlDecoration.this.visible && (activationStrategy == null || activationStrategy.isActive());
            }
        });
        this.borderDrawer.register();
    }

    public void dispose() {
        this.borderDrawer.dispose();
    }

    public Color getBorderColor() {
        return this.borderDrawer.getBorderColor();
    }

    public int getBorderWidth() {
        return this.borderDrawer.getBorderWidth();
    }

    public void hide() {
        if (this.visible) {
            this.visible = false;
            this.borderDrawer.update(true);
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setBorderColor(Color borderColor) {
        this.borderDrawer.setBorderColor(borderColor);
        this.borderDrawer.update(false);
    }

    public void show() {
        if (!this.visible) {
            this.visible = true;
            this.borderDrawer.update(true);
        }
    }

    private static void logWarning(String message) {
        Logger logger = Log4r.getLogger((IRienaActivator)Activator.getDefault(), BorderControlDecoration.class);
        logger.log(2, message);
    }

    private int checkBorderWidth(int candidate) {
        int result = candidate;
        if (candidate < 0) {
            BorderControlDecoration.logWarning("BorderWidth is lower than 0: " + candidate);
            result = 0;
        }
        return result;
    }

    private Control getBorderControl(Control control) {
        Control result = control;
        if (control.getParent() instanceof DatePickerComposite) {
            result = control.getParent();
        }
        return result;
    }
}

