/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.swt.IFlashDelegate;
import org.eclipse.riena.ui.swt.facades.ClipboardFacade;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class CompletionCombo
extends Composite {
    private static final SWTFacade SWT_FACADE = SWTFacade.getDefault();
    private final Set<Character> inputChars;
    private Label label;
    private Text text;
    private Control list;
    private Shell popup;
    private Button arrow;
    private Listener listener;
    private Listener filter;
    private Color listForeground;
    private Color listBackground;
    private Font font;
    private Shell _shell;
    private int visibleItemCount;
    private boolean hasFocus;
    private boolean isEnabled;
    private boolean ignoreFocusOut;
    private AutoCompletionMode autoCompletionMode;
    private IFlashDelegate flashDelegate;
    private Menu systemContextMenu;
    private Menu emptyContextMenu;

    static int checkStyle(int style) {
        return 0x80000 | style & 0x6800808;
    }

    protected CompletionCombo(Composite parent, int style) {
        int[] arrowEvents;
        int[] textEvents;
        int[] comboEvents;
        style = CompletionCombo.checkStyle(style);
        super(parent, style);
        this.inputChars = new HashSet<Character>();
        this.visibleItemCount = 5;
        this.isEnabled = true;
        this._shell = super.getShell();
        int textStyle = 4;
        if ((style & 8) != 0) {
            textStyle |= 8;
        }
        if ((style & 0x800000) != 0) {
            textStyle |= 0x800000;
        }
        this.label = this.createLabel(this);
        this.text = new Text((Composite)this, textStyle);
        this.text.setBackground(this.getBackground());
        this.systemContextMenu = this.text.getMenu();
        this.emptyContextMenu = new Menu((Control)this.text);
        int arrowStyle = 1028;
        if ((style & 0x800000) != 0) {
            arrowStyle |= 0x800000;
        }
        this.arrow = new Button((Composite)this, arrowStyle);
        this.listener = new Listener(){

            public void handleEvent(final Event event) {
                if (CompletionCombo.this.isDisposed()) {
                    return;
                }
                if (CompletionCombo.this.popup == event.widget) {
                    CompletionCombo.this.popupEvent(event);
                    return;
                }
                if (CompletionCombo.this.text == event.widget) {
                    CompletionCombo.this.textEvent(event);
                    return;
                }
                if (CompletionCombo.this.list == event.widget) {
                    CompletionCombo.this.listEvent(event);
                    return;
                }
                if (CompletionCombo.this.arrow == event.widget) {
                    CompletionCombo.this.arrowEvent(event);
                    return;
                }
                if (CompletionCombo.this == event.widget) {
                    CompletionCombo.this.comboEvent(event);
                    return;
                }
                if (CompletionCombo.this.getShell() == event.widget) {
                    CompletionCombo.this.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if (CompletionCombo.this.isDisposed()) {
                                return;
                            }
                            if (event.type == 27) {
                                CompletionCombo.this.closeDropDownAfterDeactivatingShell();
                            }
                            CompletionCombo.this.handleFocus(16);
                        }
                    });
                }
            }
        };
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                if (CompletionCombo.this.isDisposed()) {
                    return;
                }
                Shell shell = ((Control)event.widget).getShell();
                if (shell == CompletionCombo.this.getShell()) {
                    if (event.type == 3 && !this.isClickedInCombo()) {
                        CompletionCombo.this.dropDown(false);
                        CompletionCombo.this.defaultTextSelection();
                    } else if (!CompletionCombo.this.ignoreFocusOut) {
                        CompletionCombo.this.handleFocus(16);
                    }
                }
            }

            private boolean isClickedInCombo() {
                Point point = CompletionCombo.this.toControl(CompletionCombo.this.getDisplay().getCursorLocation());
                Point size = CompletionCombo.this.getSize();
                Rectangle rect = new Rectangle(0, 0, size.x, size.y);
                return rect.contains(point);
            }
        };
        int[] nArray = comboEvents = new int[]{12, 15, 16, 10, 11};
        int n = comboEvents.length;
        int n2 = 0;
        while (n2 < n) {
            int comboEvent = nArray[n2];
            this.addListener(comboEvent, this.listener);
            ++n2;
        }
        int[] nArray2 = textEvents = new int[]{14, 29, 1, 2, 35, 24, 3, 4, 8, 6, 7, 32, 5, 37, 31, 15, 25};
        int n3 = textEvents.length;
        n = 0;
        while (n < n3) {
            int textEvent = nArray2[n];
            this.text.addListener(textEvent, this.listener);
            ++n;
        }
        int[] nArray3 = arrowEvents = new int[]{29, 3, 6, 7, 32, 5, 4, 37, 13, 15};
        int n4 = arrowEvents.length;
        n3 = 0;
        while (n3 < n4) {
            int arrowEvent = nArray3[n3];
            this.arrow.addListener(arrowEvent, this.listener);
            ++n3;
        }
        this.createPopup(null, null, -1);
        this.setAutoCompletionMode(AutoCompletionMode.NO_MISSMATCH);
    }

    protected abstract Label createLabel(Composite var1);

    protected abstract Control createList(Composite var1);

    protected abstract void deselectAll(Control var1);

    protected abstract Image getImage(Control var1, int var2);

    protected abstract String getItem(Control var1, int var2);

    protected abstract int getItemHeight(Control var1);

    protected abstract Image[] getImages(Control var1);

    protected abstract String[] getItems(Control var1);

    protected abstract int getItemCount(Control var1);

    protected abstract int getSelectionIndex(Control var1);

    protected abstract int getTopIndex(Control var1);

    protected abstract int indexOf(Control var1, String var2, int var3);

    protected abstract void removeAll(Control var1);

    protected abstract void setItems(Control var1, String[] var2, Image[] var3);

    protected abstract void setSelection(Control var1, int var2);

    protected abstract void setTopIndex(Control var1, int var2);

    protected Button getButtonControl() {
        return this.arrow;
    }

    protected Control getListControl() {
        return this.list;
    }

    protected Text getTextControl() {
        return this.text;
    }

    public abstract void addModifyListener(ModifyListener var1);

    public abstract void addSelectionListener(SelectionListener var1);

    public abstract void addVerifyListener(VerifyListener var1);

    void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 29: 
            case 32: {
                Point pt = this.getDisplay().map((Control)this.arrow, (Control)this, event.x, event.y);
                event.x = pt.x;
                event.y = pt.y;
                this.notifyListeners(event.type, event);
                event.type = 0;
                break;
            }
            case 37: {
                Point pt = this.getDisplay().map((Control)this.arrow, (Control)this, event.x, event.y);
                event.x = pt.x;
                event.y = pt.y;
                this.notifyListeners(37, event);
                event.type = 0;
                if (this.isDisposed() || !event.doit || event.count == 0) break;
                event.doit = false;
                int oldIndex = this.getSelectionIndex();
                if (event.count > 0) {
                    this.select(Math.max(oldIndex - 1, 0));
                } else {
                    this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                }
                if (oldIndex != this.getSelectionIndex()) {
                    Event e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(13, e);
                }
                if (!this.isDisposed()) break;
                break;
            }
            case 13: {
                this.dropDown(!this.isDropped());
                this.setFocus();
                break;
            }
        }
    }

    public void clearSelection() {
        this.checkWidget();
        this.text.clearSelection();
    }

    void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                this.removeListener(12, this.listener);
                this.notifyListeners(12, event);
                event.type = 0;
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.list.removeListener(12, this.listener);
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                this.popup = null;
                this.text = null;
                this.list = null;
                this.arrow = null;
                this._shell = null;
                break;
            }
            case 15: {
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.arrow || focusControl == this.list) {
                    return;
                }
                this.setFocus();
                break;
            }
            case 16: {
                if (this.autoCompletionMode == AutoCompletionMode.FIRST_LETTER_MATCH) {
                    this.text.setSelection(0, 0);
                }
                if (!this.isDropped()) break;
                this.dropDown(false);
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout(false);
                break;
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        String[] items = this.getItems(this.list);
        GC gc = new GC((Drawable)this.text);
        int spacer = gc.stringExtent((String)" ").x;
        int textWidth = gc.stringExtent((String)this.text.getText()).x;
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            textWidth = Math.max(gc.stringExtent((String)item).x, textWidth);
            ++n2;
        }
        gc.dispose();
        Point labelSize = this.label != null ? this.label.computeSize(-1, -1) : new Point(0, 0);
        Point textSize = this.text.computeSize(-1, -1, changed);
        Point arrowSize = this.arrow.computeSize(-1, -1, changed);
        Point listSize = this.list.computeSize(-1, -1, changed);
        int borderWidth = this.getBorderWidth();
        height = Math.max(textSize.y, arrowSize.y);
        height = Math.max(height, labelSize.y);
        width = Math.max(textWidth + 2 * spacer + arrowSize.x + 2 * borderWidth, listSize.x);
        if (this.label != null) {
            width += labelSize.x + 2 * spacer;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width + 2 * borderWidth, height + 2 * borderWidth);
    }

    void createPopup(String[] items, Image[] images, int selectionIndex) {
        int[] listEvents;
        int[] popupEvents;
        this.popup = new Shell(this.getShell(), 16392);
        this.list = this.createList((Composite)this.popup);
        if (this.font != null) {
            this.list.setFont(this.font);
        }
        if (this.listForeground != null) {
            this.list.setForeground(this.listForeground);
        }
        if (this.listBackground != null) {
            this.list.setBackground(this.listBackground);
        }
        int[] nArray = popupEvents = new int[]{21, 9, 27};
        int n = popupEvents.length;
        int n2 = 0;
        while (n2 < n) {
            int popupEvent = nArray[n2];
            this.popup.addListener(popupEvent, this.listener);
            ++n2;
        }
        int[] nArray2 = listEvents = new int[]{4, 13, 31, 1, 2, 15, 37, 12};
        int n3 = listEvents.length;
        n = 0;
        while (n < n3) {
            int listEvent = nArray2[n];
            this.list.addListener(listEvent, this.listener);
            ++n;
        }
        if (items != null) {
            this.setItems(this.list, items, images);
        }
        if (selectionIndex != -1) {
            this.setSelection(this.list, selectionIndex);
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.getItemCount(this.list) && index == this.getSelectionIndex(this.list) && this.text.getText().equals(this.getItem(this.list, index))) {
            this.clearImage();
            this.text.setText("");
            this.deselectAll(this.list);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.clearImage();
        this.text.setText("");
        this.deselectAll(this.list);
    }

    void dropDown(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.popup.setVisible(false);
            if (!this.isDisposed() && this.isFocusControl()) {
                this.setFocus();
            }
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        if (this.getShell() != this.popup.getParent()) {
            String[] items = this.getItems(this.list);
            Image[] images = this.getImages(this.list);
            int selectionIndex = this.getSelectionIndex(this.list);
            this.list.removeListener(12, this.listener);
            this.popup.dispose();
            this.popup = null;
            this.list = null;
            this.createPopup(items, images, selectionIndex);
        }
        Point size = this.getSize();
        int itemCount = this.getItemCount(this.list);
        itemCount = itemCount == 0 ? this.visibleItemCount : Math.min(this.visibleItemCount, itemCount);
        int itemHeight = this.getItemHeight(this.list) * itemCount;
        Point listSize = this.list.computeSize(-1, itemHeight, false);
        this.list.setBounds(1, 1, Math.max(size.x - 2, listSize.x), listSize.y);
        int index = this.getSelectionIndex(this.list);
        if (index != -1) {
            this.setTopIndex(this.list, index);
        }
        Display display = this.getDisplay();
        Rectangle listRect = this.list.getBounds();
        Rectangle parentRect = display.map((Control)this.getParent(), null, this.getBounds());
        Point comboSize = this.getSize();
        Rectangle displayRect = this.getMonitor().getClientArea();
        int width = Math.max(comboSize.x, listRect.width + 2);
        int height = listRect.height + 2;
        int x = parentRect.x;
        int y = parentRect.y + comboSize.y;
        if (y + height > displayRect.y + displayRect.height) {
            y = parentRect.y - height;
        }
        if (x + width > displayRect.x + displayRect.width) {
            x = displayRect.x + displayRect.width - listRect.width;
        }
        this.popup.setBounds(x, y, width, height);
        this.popup.setVisible(true);
        if (this.isFocusControl()) {
            this.setFocus();
        }
    }

    public Color getListBackground() {
        return this.listBackground != null ? this.listBackground : this.getBackground();
    }

    public Color getTextBackground() {
        return this.text.getBackground();
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public String getItem(int index) {
        this.checkWidget();
        return this.getItem(this.list, index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.getItemCount(this.list);
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.getItemHeight(this.list);
    }

    public String[] getItems() {
        this.checkWidget();
        return this.getItems(this.list);
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.isDropped();
    }

    public Menu getMenu() {
        return this.text.getMenu();
    }

    public Point getSelection() {
        this.checkWidget();
        return this.text.getSelection();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.getSelectionIndex(this.list);
    }

    public Shell getShell() {
        this.checkWidget();
        Shell shell = super.getShell();
        if (shell != this._shell) {
            if (this._shell != null && !this._shell.isDisposed()) {
                this._shell.removeListener(27, this.listener);
            }
            this._shell = shell;
        }
        return this._shell;
    }

    public int getStyle() {
        int style = super.getStyle();
        style &= 0xFFFFFFF7;
        if (!this.text.getEditable()) {
            style |= 8;
        }
        return style;
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.text.getTextLimit();
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleItemCount;
    }

    void handleFocus(int type) {
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.defaultTextSelection();
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                display.removeFilter(3, this.filter);
                display.addFilter(3, this.filter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.arrow || focusControl == this.list || focusControl == this.text) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.removeFilter(3, this.filter);
                Event e = new Event();
                this.notifyListeners(16, e);
                break;
            }
        }
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        return this.indexOf(this.list, string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        return this.indexOf(this.list, string, start);
    }

    protected boolean isDropped() {
        return !SwtUtilities.isDisposed((Widget)this.popup) && this.popup.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.text.isFocusControl() || this.arrow.isFocusControl() || this.list.isFocusControl() || this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    void internalLayout(boolean changed) {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point arrowSize = this.arrow.computeSize(-1, height, changed);
        if (this.label != null) {
            Point labelSize = this.arrow.computeSize(16, height, changed);
            labelSize.x += 3;
            this.label.setBounds(3, 0, labelSize.x - 3, height);
            this.text.setBounds(labelSize.x, 0, width - arrowSize.x - labelSize.x, height);
            this.arrow.setBounds(width - arrowSize.x, 0, arrowSize.x, arrowSize.y);
        } else {
            this.text.setBounds(0, 0, width - arrowSize.x, height);
            this.arrow.setBounds(width - arrowSize.x, 0, arrowSize.x, arrowSize.y);
        }
    }

    void listEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.getShell() == this.popup.getParent()) break;
                String[] items = this.getItems(this.list);
                Image[] images = this.getImages(this.list);
                int selectionIndex = this.getSelectionIndex(this.list);
                this.popup = null;
                this.list = null;
                this.createPopup(items, images, selectionIndex);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                this.dropDown(false);
                break;
            }
            case 13: {
                int index = this.getSelectionIndex(this.list);
                if (index == -1) {
                    return;
                }
                this.setImage(index);
                this.text.setText(this.getItem(this.list, index));
                this.defaultTextSelection();
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: 
                    case 16: {
                        event.doit = SWT_FACADE.traverse((Control)this.text, event.detail);
                        event.detail = 0;
                        if (event.doit) {
                            this.dropDown(false);
                        }
                        return;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                SWT_FACADE.copyEventKeyLocation(event, e);
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                SWT_FACADE.copyEventKeyLocation(event, e);
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                event.doit = e.doit;
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if ((event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDown(false);
                }
                if ((event.character == '\u007f' || event.character == '\b') && this.autoCompletionMode == AutoCompletionMode.FIRST_LETTER_MATCH) {
                    this.clearImage();
                    this.text.setText("");
                    this.deselectAll(this.list);
                    this.dropDown(false);
                    this.sendSelectionEvent();
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                SWT_FACADE.copyEventKeyLocation(event, e);
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                event.doit = e.doit;
                break;
            }
            case 37: {
                if (this.autoCompletionMode != AutoCompletionMode.FIRST_LETTER_MATCH) break;
                event.doit = false;
                int selection = this.getSelectionIndex(this.list);
                if (selection > -1) {
                    int newIndex;
                    int n = newIndex = event.count < 0 ? selection + 1 : selection - 1;
                    if (newIndex <= -1 || newIndex >= this.getItemCount(this.list)) break;
                    this.setSelection(this.list, newIndex);
                    break;
                }
                this.setSelection(this.list, this.getTopIndex(this.list));
                break;
            }
        }
    }

    void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle listRect = this.list.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width + 1, listRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                this.dropDown(false);
                break;
            }
        }
    }

    public void redraw() {
        super.redraw();
        this.text.redraw();
        this.arrow.redraw();
        if (!SwtUtilities.isDisposed((Widget)this.popup) && this.popup.isVisible()) {
            this.list.redraw();
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        super.redraw(x, y, width, height, true);
    }

    public void removeAll() {
        this.checkWidget();
        this.clearImage();
        this.text.setText("");
        this.removeAll(this.list);
    }

    public abstract void removeModifyListener(ModifyListener var1);

    public abstract void removeSelectionListener(SelectionListener var1);

    public abstract void removeVerifyListener(VerifyListener var1);

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            this.clearImage();
            this.text.setText("");
            this.deselectAll(this.list);
            return;
        }
        if (index >= 0 && index < this.getItemCount(this.list) && index != this.getSelectionIndex()) {
            this.setImage(index);
            this.text.setText(this.getItem(this.list, index));
            this.defaultTextSelection();
            this.setSelection(this.list, index);
        }
    }

    public void setAutoCompletionMode(AutoCompletionMode autoCompletionMode) {
        Assert.isNotNull((Object)((Object)autoCompletionMode));
        this.autoCompletionMode = autoCompletionMode;
        if (this.autoCompletionMode == AutoCompletionMode.ALLOW_MISSMATCH) {
            this.text.setMenu(this.systemContextMenu);
        } else {
            this.text.setMenu(this.emptyContextMenu);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.setTextBackground(color);
        this.setListBackground(color);
    }

    public void setListBackground(Color color) {
        this.listBackground = color;
        if (this.list != null && !this.list.isDisposed()) {
            this.list.setBackground(color);
        }
    }

    public void setTextBackground(Color color) {
        if (this.label != null && !this.label.isDisposed()) {
            this.label.setBackground(color);
        }
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setBackground(color);
        }
        if (this.arrow != null && !this.arrow.isDisposed()) {
            this.arrow.setBackground(color);
        }
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.text.setEditable(editable);
        this.arrow.setEnabled(this.isEnabled && editable);
    }

    public void setFlashDelegate(IFlashDelegate delegate) {
        this.flashDelegate = delegate;
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
        boolean editable = enabled && this.text.getEditable();
        this.arrow.setEnabled(editable);
        if (!editable && !SwtUtilities.isDisposed((Widget)this.popup)) {
            this.popup.setVisible(editable);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        return this.text.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        this.text.setFont(font);
        this.list.setFont(font);
        this.internalLayout(true);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.listForeground = color;
        if (this.text != null && !this.text.isDisposed()) {
            this.text.setForeground(color);
        }
        if (this.list != null && !this.list.isDisposed()) {
            this.list.setForeground(color);
        }
        if (this.arrow != null && !this.arrow.isDisposed()) {
            this.arrow.setForeground(color);
        }
    }

    public void setItems(String[] items) {
        this.setItems(items, null);
    }

    public void setItems(String[] items, Image[] images) {
        this.checkWidget();
        if (images != null) {
            Assert.isLegal((items.length == images.length ? 1 : 0) != 0, (String)"Number of items and images does not match");
        }
        this.setItems(this.list, items, images);
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.updateInputChars(item);
            ++n2;
        }
        if (!this.text.getEditable()) {
            this.clearImage();
            this.text.setText("");
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setListVisible(boolean visible) {
        this.checkWidget();
        this.dropDown(visible);
    }

    public void setMenu(Menu menu) {
        this.text.setMenu(menu);
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error((int)4);
        }
        this.text.setSelection(selection.x, selection.y);
    }

    public void setText(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        if ((index = this.indexOf(this.list, string, 0)) == -1) {
            this.deselectAll(this.list);
            this.clearImage();
            this.text.setText(string);
            return;
        }
        this.setImage(index);
        this.text.setText(string);
        this.defaultTextSelection();
        this.setSelection(this.list, index);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        this.text.setTextLimit(limit);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.arrow.setToolTipText(string);
        this.text.setToolTipText(string);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.isDisposed()) {
            return;
        }
        if (this.popup == null || this.popup.isDisposed()) {
            return;
        }
        if (!visible) {
            this.popup.setVisible(false);
        }
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        this.visibleItemCount = count;
    }

    void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 14: {
                this.dropDown(false);
                this.defaultTextSelection();
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                this.notifyListeners(14, e);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 29: 
            case 32: {
                Point pt = this.getDisplay().map((Control)this.text, (Control)this, event.x, event.y);
                event.x = pt.x;
                event.y = pt.y;
                this.notifyListeners(event.type, event);
                event.type = 0;
                break;
            }
            case 1: {
                Event keyEvent = new Event();
                keyEvent.time = event.time;
                keyEvent.character = event.character;
                keyEvent.keyCode = event.keyCode;
                SWT_FACADE.copyEventKeyLocation(event, keyEvent);
                keyEvent.stateMask = event.stateMask;
                this.notifyListeners(1, keyEvent);
                if (this.isDisposed() || !this.getEditable()) break;
                if (this.autoCompletionMode == AutoCompletionMode.FIRST_LETTER_MATCH) {
                    this.handleFirstLetterMatch(event);
                } else {
                    this.handleAutoCompletion(event);
                }
                if (!event.doit) break;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                    break;
                }
                if (event.keyCode != 0x1000001 && event.keyCode != 0x1000002) break;
                event.doit = false;
                if ((event.stateMask & 0x10000) != 0) {
                    boolean dropped = this.isDropped();
                    this.defaultTextSelection();
                    if (!dropped) {
                        this.setFocus();
                    }
                    this.dropDown(!dropped);
                    break;
                }
                int oldIndex = this.getSelectionIndex();
                if (event.keyCode == 0x1000001) {
                    this.select(Math.max(oldIndex - 1, 0));
                } else {
                    this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                }
                if (oldIndex != this.getSelectionIndex()) {
                    Event e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(13, e);
                }
                if (!this.isDisposed()) break;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                SWT_FACADE.copyEventKeyLocation(event, e);
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                event.doit = e.doit;
                break;
            }
            case 35: {
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(35, e);
                break;
            }
            case 24: {
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 3: {
                Point pt = this.getDisplay().map((Control)this.text, (Control)this, event.x, event.y);
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = pt.x;
                mouseEvent.y = pt.y;
                this.notifyListeners(3, mouseEvent);
                if (this.isDisposed()) break;
                event.doit = mouseEvent.doit;
                if (!event.doit) break;
                if (!this.isDropped()) {
                    this.dropDown(true);
                    this.ignoreFocusOut = true;
                    this.setFocus();
                    this.ignoreFocusOut = false;
                }
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                boolean dropped = this.isDropped();
                this.defaultTextSelection();
                if (!dropped) {
                    this.setFocus();
                }
                this.dropDown(!dropped);
                break;
            }
            case 4: {
                Point pt = this.getDisplay().map((Control)this.text, (Control)this, event.x, event.y);
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = pt.x;
                mouseEvent.y = pt.y;
                this.notifyListeners(4, mouseEvent);
                if (this.isDisposed()) break;
                event.doit = mouseEvent.doit;
                if (!event.doit) break;
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                this.defaultTextSelection();
                break;
            }
            case 37: {
                this.notifyListeners(37, event);
                event.type = 0;
                if (this.isDisposed() || !event.doit || event.count == 0) break;
                event.doit = false;
                int oldIndex = this.getSelectionIndex();
                if (event.count > 0) {
                    this.select(Math.max(oldIndex - 1, 0));
                } else {
                    this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                }
                if (oldIndex != this.getSelectionIndex()) {
                    Event e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(13, e);
                }
                if (!this.isDisposed()) break;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: {
                        event.doit = SWT_FACADE.traverse((Control)this, 8);
                        event.detail = 0;
                        return;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                SWT_FACADE.copyEventKeyLocation(event, e);
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 25: {
                Event e = new Event();
                e.text = event.text;
                e.start = event.start;
                e.end = event.end;
                e.character = event.character;
                e.keyCode = event.keyCode;
                SWT_FACADE.copyEventKeyLocation(event, e);
                e.stateMask = event.stateMask;
                this.notifyListeners(25, e);
                event.text = e.text;
                event.doit = e.doit;
                break;
            }
        }
    }

    private String buildPrefixOnBackSpace(Point selection) {
        String result;
        String theText = this.text.getText();
        if (this.isAllowMissmatch()) {
            int end = Math.max(0, selection.x - 1);
            result = String.valueOf(theText.substring(0, end)) + theText.substring(selection.y);
        } else {
            String prefix = theText.substring(0, selection.x);
            int end = Math.max(0, prefix.length() - 1);
            result = prefix.substring(0, end);
        }
        return result;
    }

    private String buildPrefixForInput(char typedChar, Point selection) {
        String prefix = this.text.getText().substring(0, selection.x);
        prefix = this.isAllowMissmatch() ? String.valueOf(this.text.getText().substring(0, selection.x)) + typedChar + this.text.getText().substring(selection.y) : String.valueOf(prefix) + typedChar;
        return prefix;
    }

    private void clearImage() {
        if (this.label != null) {
            this.label.setImage(null);
        }
    }

    private void closeDropDownAfterDeactivatingShell() {
        final Display display = this.getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (display.getActiveShell() == null) {
                    CompletionCombo.this.dropDown(false);
                }
            }
        });
    }

    private void defaultTextSelection() {
        if (this.autoCompletionMode == AutoCompletionMode.FIRST_LETTER_MATCH) {
            this.text.setSelection(0, 0);
        } else {
            this.text.selectAll();
        }
    }

    private String getFirstCharFromTextWidget() {
        String result = null;
        if (this.text.getText().length() > 0) {
            result = this.text.getText().substring(0, 1);
        }
        return result;
    }

    private void handleAutoCompletion(Event event) {
        event.doit = false;
        if (event.stateMask == 65536 || event.stateMask == 262144) {
            event.doit = this.handleClipboardOperations(event);
        } else if (event.character == '\u007f' && this.isAllowMissmatch()) {
            event.doit = true;
        } else if (this.isControlChar(event)) {
            event.doit = true;
        } else if (this.isInputChar(event.character)) {
            Point selection = this.getSelection();
            String newPrefix = event.character == '\b' ? this.buildPrefixOnBackSpace(selection) : this.buildPrefixForInput(event.character, selection);
            boolean matched = this.matchPrefixWithList(newPrefix);
            if (!matched) {
                if (this.isAllowMissmatch()) {
                    this.clearImage();
                    if (this.getSelectionIndex() != -1) {
                        this.deselectAll(this.list);
                        this.sendSelectionEvent();
                    }
                    event.doit = true;
                } else if (this.flashDelegate != null) {
                    this.flashDelegate.flash();
                }
            }
        }
    }

    private boolean handleClipboardOperations(Event event) {
        boolean result = true;
        if (event.stateMask == 262144) {
            if (event.keyCode == 118) {
                this.handlePaste();
                result = false;
            } else if (event.keyCode == 120) {
                this.handleCut();
                result = false;
            }
        }
        return result;
    }

    private void handleCut() {
        Point selection = this.text.getSelection();
        String oldText = this.text.getText();
        String newText = String.valueOf(oldText.substring(0, selection.x)) + oldText.substring(selection.y, oldText.length());
        int index = this.indexOf(newText);
        if (index != -1 || newText.length() == 0) {
            ClipboardFacade.getDefault().cut(this.text);
            if (index == -1) {
                this.clearImage();
            } else {
                this.setImage(index);
            }
            this.text.setText(newText);
            this.text.setSelection(newText.length());
            this.setSelection(this.list, index);
            this.sendSelectionEvent();
        } else if (index == -1 && this.isAllowMissmatch()) {
            this.clearImage();
            this.text.setText(newText);
            this.text.setSelection(newText.length());
        }
    }

    private void handleFirstLetterMatch(Event event) {
        event.doit = false;
        if (event.stateMask == 65536 || event.stateMask == 262144) {
            event.doit = this.handleClipboardOperations(event);
        } else if (this.isControlChar(event)) {
            event.doit = true;
        } else if (this.isInputChar(event.character)) {
            String item;
            String firstChar;
            boolean matched = false;
            int startIndex = 0;
            String keyChar = String.valueOf(event.character);
            if (keyChar.equalsIgnoreCase(firstChar = this.getFirstCharFromTextWidget())) {
                startIndex = this.getSelectionIndex() + 1;
            }
            String prefix = String.valueOf(event.character);
            String[] items = this.getItems(this.list);
            int i = startIndex;
            while (i < items.length) {
                item = items[i];
                if (this.matchesWord(prefix, item)) {
                    this.setMatchingTextAndSelection(0, 0, item);
                    matched = true;
                    break;
                }
                ++i;
            }
            i = 0;
            while (!matched && i < startIndex) {
                item = items[i];
                if (this.matchesWord(prefix, item)) {
                    this.setMatchingTextAndSelection(0, 0, item);
                    matched = true;
                    break;
                }
                ++i;
            }
            if (!matched && this.flashDelegate != null) {
                this.flashDelegate.flash();
            }
        }
    }

    private void handlePaste() {
        String data = ClipboardFacade.getDefault().getTextFromClipboard(this.getDisplay());
        if (data != null) {
            Point selection = this.text.getSelection();
            String oldText = this.text.getText();
            String newText = String.valueOf(oldText.substring(0, selection.x)) + data + oldText.substring(selection.y, oldText.length());
            int index = this.indexOf(newText);
            if (index != -1) {
                this.setImage(index);
                this.text.setText(newText);
                this.text.setSelection(newText.length());
                this.setSelection(this.list, index);
                this.sendSelectionEvent();
            } else if (index == -1 && this.isAllowMissmatch()) {
                this.clearImage();
                this.text.setText(newText);
                this.text.setSelection(newText.length());
            }
        }
    }

    private boolean isAllowMissmatch() {
        return this.autoCompletionMode == AutoCompletionMode.ALLOW_MISSMATCH;
    }

    private boolean isControlChar(Event event) {
        int[] keyCodes;
        char[] chars;
        char[] cArray = chars = new char[]{'\u001b', '\r'};
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (ch == event.character) {
                return true;
            }
            ++n2;
        }
        int[] nArray = keyCodes = new int[]{0x1000001, 0x1000002, 0x1000003, 0x1000004, 0x1000007, 0x1000008};
        int n3 = keyCodes.length;
        n = 0;
        while (n < n3) {
            int keycode = nArray[n];
            if (keycode == event.keyCode) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean isInputChar(char ch) {
        int type;
        if (Character.isLetterOrDigit(ch) || ch == '\b') {
            return true;
        }
        Character character = Character.valueOf(ch);
        if (this.inputChars.contains(character)) {
            return true;
        }
        return this.isAllowMissmatch() && ((type = Character.getType(ch)) == 10 || type == 11 || type >= 20 && type < 30);
    }

    private boolean matchesWord(String prefix, String word) {
        if (prefix == null || word == null) {
            return false;
        }
        return word.toLowerCase().startsWith(prefix.toLowerCase());
    }

    private boolean matchPrefixWithList(String prefix) {
        boolean result = false;
        if (prefix != null) {
            if (prefix.length() == 0) {
                this.clearImage();
                this.text.setText("");
                if (this.getSelectionIndex() > -1) {
                    this.deselectAll(this.list);
                    this.sendSelectionEvent();
                }
                result = true;
            } else {
                String[] stringArray = this.getItems(this.list);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (this.matchesWord(prefix, item)) {
                        this.setMatchingTextAndSelection(prefix.length(), item.length(), item);
                        result = true;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return result;
    }

    private void updateInputChars(String string) {
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            if (!Character.isLetterOrDigit(ch)) {
                this.inputChars.add(Character.valueOf(ch));
            }
            ++i;
        }
    }

    private void sendSelectionEvent() {
        Event event = new Event();
        event.widget = this;
        event.type = 13;
        this.notifyListeners(event.type, event);
    }

    private void setImage(int index) {
        if (this.label != null) {
            this.label.setImage(this.getImage(this.list, index));
        }
    }

    private void setMatchingTextAndSelection(int selectionStart, int selectionEnd, String item) {
        int index = this.indexOf(item);
        Assert.isLegal((index > -1 ? 1 : 0) != 0);
        this.setImage(index);
        this.text.setText(item);
        this.text.setSelection(selectionStart, selectionEnd);
        this.setSelection(this.list, index);
        this.sendSelectionEvent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AutoCompletionMode {
        ALLOW_MISSMATCH,
        NO_MISSMATCH,
        FIRST_LETTER_MATCH;

    }
}

