/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.cache.LRUHashMap;
import org.eclipse.riena.ui.swt.facades.GCFacade;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public final class SwtUtilities {
    private static final String THREE_DOTS = "...";
    private static final Map<GCString, Integer> TEXT_WIDTH_CACHE = LRUHashMap.createLRUHashMap((int)2048);
    private static final Map<GCChar, Integer> CHAR_WIDTH_CACHE = LRUHashMap.createLRUHashMap((int)1024);

    private SwtUtilities() {
        throw new Error("SwtUtilities is just a container for static methods");
    }

    public static String clipText(GC gc, String text, int maxWidth) {
        int textwidth = SwtUtilities.calcTextWidth(gc, text);
        if (textwidth <= maxWidth) {
            return text;
        }
        int threeDotsWidth = SwtUtilities.calcTextWidth(gc, THREE_DOTS);
        StringBuilder shortenedText = new StringBuilder(text);
        while (textwidth + threeDotsWidth > maxWidth && shortenedText.length() != 0) {
            shortenedText.setLength(shortenedText.length() - 1);
            textwidth = SwtUtilities.calcTextWidth(gc, shortenedText);
        }
        shortenedText.append(THREE_DOTS);
        return shortenedText.toString();
    }

    public static int calcTextWidth(GC gc, CharSequence text) {
        if (text == null) {
            return 0;
        }
        GCString lookupKey = new GCString(gc, text);
        Integer width = TEXT_WIDTH_CACHE.get(lookupKey);
        if (width == null) {
            int w = 0;
            int i = 0;
            while (i < text.length()) {
                w += SwtUtilities.calcCharWidth(gc, text.charAt(i));
                ++i;
            }
            width = w;
            TEXT_WIDTH_CACHE.put(lookupKey, width);
        }
        return width;
    }

    public static int calcCharWidth(GC gc, char ch) {
        GCChar lookupKey = new GCChar(gc, ch);
        Integer width = CHAR_WIDTH_CACHE.get(lookupKey);
        if (width == null) {
            width = GCFacade.getDefault().getAdvanceWidth(gc, ch);
            CHAR_WIDTH_CACHE.put(lookupKey, width);
        }
        return width;
    }

    public static void dispose(Resource resource) {
        if (!SwtUtilities.isDisposed(resource)) {
            resource.dispose();
        }
    }

    public static void dispose(Widget widget) {
        if (!SwtUtilities.isDisposed(widget)) {
            widget.dispose();
        }
    }

    public static int findColumn(Table table, Point pt) {
        int width = 0;
        int[] colOrder = table.getColumnOrder();
        TableColumn[] columns = new TableColumn[colOrder.length];
        int i = 0;
        while (i < colOrder.length) {
            int idx = colOrder[i];
            columns[i] = table.getColumn(idx);
            ++i;
        }
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            int colWidth = col.getWidth();
            if (width < pt.x && pt.x < width + colWidth) {
                return table.indexOf(col);
            }
            width += colWidth;
            ++n2;
        }
        return -1;
    }

    public static boolean hasStyle(Widget widget, int styleBit) {
        return widget == null ? false : (widget.getStyle() & styleBit) == styleBit;
    }

    public static boolean isDisposed(Widget widget) {
        return widget == null || widget.isDisposed();
    }

    public static boolean isDisposed(Resource resource) {
        return resource == null || resource.isDisposed();
    }

    public static Color makeBrighter(Color color, float f) {
        Assert.isNotNull((Object)color);
        Assert.isTrue(((double)f >= 0.0 ? 1 : 0) != 0);
        float[] hsb = color.getRGB().getHSB();
        float h = hsb[0];
        float s = hsb[1];
        float b = hsb[2];
        b *= f;
        if (b > 1.0f) {
            b = 1.0f;
        }
        RGB rgb = new RGB(h, s, b);
        return new Color(color.getDevice(), rgb);
    }

    private static final class GCChar {
        private final char ch;
        private final Font font;

        private GCChar(GC gc, char ch) {
            this.font = gc.getFont();
            this.ch = ch;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.ch;
            result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            GCChar other = (GCChar)obj;
            if (this.ch != other.ch) {
                return false;
            }
            return !(this.font == null ? other.font != null : !this.font.equals((Object)other.font));
        }
    }

    private static final class GCString {
        private final String text;
        private final Font font;

        private GCString(GC gc, CharSequence seq) {
            this.font = gc.getFont();
            this.text = seq.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            GCString other = (GCString)obj;
            if (this.font == null ? other.font != null : !this.font.equals((Object)other.font)) {
                return false;
            }
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }
    }
}

