/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.workarea;

import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.controller.IControllerFactory;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkareaDefinition
implements IWorkareaDefinition {
    private final Class<? extends IController> controllerClass;
    private final IControllerFactory controllerFactory;
    private final Object viewId;
    private boolean viewShared;
    private boolean requiredPreparation;

    public WorkareaDefinition(Object viewId) {
        this((Class<? extends IController>)null, viewId);
    }

    public WorkareaDefinition(Class<? extends IController> controllerClass, Object viewId) {
        this.controllerClass = controllerClass;
        this.controllerFactory = null;
        this.viewId = viewId;
    }

    public WorkareaDefinition(IControllerFactory controllerFactory, Object viewId) {
        this.controllerFactory = controllerFactory;
        this.controllerClass = null;
        this.viewId = viewId;
    }

    @Override
    public Class<? extends IController> getControllerClass() {
        return this.controllerClass;
    }

    @Override
    public IController createController() throws IllegalAccessException, InstantiationException {
        if (this.getControllerClass() != null) {
            IController controller = this.getControllerClass().newInstance();
            Wire.instance((Object)controller).andStart();
            return controller;
        }
        if (this.controllerFactory != null) {
            return this.controllerFactory.createController();
        }
        return null;
    }

    @Override
    public Object getViewId() {
        return this.viewId;
    }

    @Override
    public boolean isViewShared() {
        return this.viewShared;
    }

    @Override
    public boolean isRequiredPreparation() {
        return this.requiredPreparation;
    }

    @Override
    public void setViewShared(boolean shared) {
        this.viewShared = shared;
    }

    @Override
    public void setRequiredPreparation(boolean required) {
        this.requiredPreparation = required;
    }
}

