/*
 * Decompiled with CFR 0.152.
 */
package test.swt;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.swt.SWTRepaintTimeline;

public class Snake {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setSize(430, 240);
        shell.setText("SWT Snake");
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        new SnakePanel((Composite)shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static class SnakePanel
    extends Canvas {
        private SnakePanelRectangle[][] grid = new SnakePanelRectangle[this.COLUMNS][this.ROWS];
        private int ROWS = 10;
        private int COLUMNS = 20;
        private int DIM = 20;

        public SnakePanel(Composite parent) {
            super(parent, 0x20000000);
            int i = 0;
            while (i < this.COLUMNS) {
                int j = 0;
                while (j < this.ROWS) {
                    this.grid[i][j] = new SnakePanelRectangle();
                    ++j;
                }
                ++i;
            }
            SWTRepaintTimeline repaint = new SWTRepaintTimeline((Control)this);
            repaint.playLoop(Timeline.RepeatBehavior.LOOP);
            this.addMouseMoveListener(new MouseMoveListener(){
                int rowOld = -1;
                int colOld = -1;

                public void mouseMove(MouseEvent e) {
                    int x = e.x;
                    int y = e.y;
                    int column = x / (SnakePanel.this.DIM + 1);
                    int row = y / (SnakePanel.this.DIM + 1);
                    if (column >= SnakePanel.this.COLUMNS || row >= SnakePanel.this.ROWS) {
                        return;
                    }
                    if (column != this.colOld || row != this.rowOld) {
                        if (this.colOld >= 0 && this.rowOld >= 0) {
                            SnakePanel.this.grid[this.colOld][this.rowOld].setRollover(false);
                        }
                        SnakePanel.this.grid[column][row].setRollover(true);
                    }
                    this.colOld = column;
                    this.rowOld = row;
                }
            });
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    gc.setBackground(e.display.getSystemColor(2));
                    gc.fillRectangle(e.x, e.y, e.width, e.height);
                    int i = 0;
                    while (i < SnakePanel.this.COLUMNS) {
                        int j = 0;
                        while (j < SnakePanel.this.ROWS) {
                            SnakePanelRectangle rect = SnakePanel.this.grid[i][j];
                            Color backgr = rect.getBackgroundColor();
                            gc.setBackground(backgr);
                            gc.fillRectangle(i * (SnakePanel.this.DIM + 1), j * (SnakePanel.this.DIM + 1), SnakePanel.this.DIM, SnakePanel.this.DIM);
                            ++j;
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public static class SnakePanelRectangle {
        private Color backgroundColor = Display.getDefault().getSystemColor(2);
        private boolean isRollover = false;
        private Timeline rolloverTimeline = new Timeline(this);

        public SnakePanelRectangle() {
            this.rolloverTimeline.addPropertyToInterpolate("backgroundColor", Display.getDefault().getSystemColor(7), Display.getDefault().getSystemColor(2));
            this.rolloverTimeline.setDuration(2500L);
        }

        public void setRollover(boolean isRollover) {
            if (this.isRollover == isRollover) {
                return;
            }
            this.isRollover = isRollover;
            if (this.isRollover) {
                this.rolloverTimeline.replay();
            }
        }

        public void setBackgroundColor(Color backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public Color getBackgroundColor() {
            return this.backgroundColor;
        }
    }
}

