/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.jface.gridviewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.nebula.jface.gridviewer.GridViewerEditor;
import org.eclipse.nebula.jface.gridviewer.GridViewerRow;
import org.eclipse.nebula.jface.gridviewer.internal.CellSelection;
import org.eclipse.nebula.jface.gridviewer.internal.SelectionWithFocusRow;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class GridTableViewer
extends AbstractTableViewer {
    private Grid grid;
    private GridViewerRow cachedRow;
    private CellLabelProvider rowHeaderLabelProvider;
    private boolean autoPreferredHeight = false;

    public GridTableViewer(Composite parent) {
        this(parent, 2818);
    }

    public GridTableViewer(Composite parent, int style) {
        this(new Grid(parent, style));
    }

    public GridTableViewer(Grid grid) {
        this.grid = grid;
        this.hookControl((Control)grid);
    }

    public Grid getGrid() {
        return this.grid;
    }

    protected ViewerRow internalCreateNewRowPart(int style, int rowIndex) {
        GridItem item = rowIndex >= 0 ? new GridItem(this.grid, style, rowIndex) : new GridItem(this.grid, style);
        return this.getViewerRowFromItem((Widget)item);
    }

    protected ColumnViewerEditor createViewerEditor() {
        return new GridViewerEditor((ColumnViewer)this, new ColumnViewerEditorActivationStrategy((ColumnViewer)this), 1);
    }

    protected void doClear(int index) {
    }

    protected void doClearAll() {
    }

    protected void doSetItemCount(int count) {
    }

    protected void doDeselectAll() {
        this.grid.deselectAll();
    }

    protected Widget doGetColumn(int index) {
        return this.grid.getColumn(index);
    }

    protected int doGetColumnCount() {
        return this.grid.getColumnCount();
    }

    protected Item doGetItem(int index) {
        return this.grid.getItem(index);
    }

    protected int doGetItemCount() {
        return this.grid.getItemCount();
    }

    protected Item[] doGetItems() {
        return this.grid.getItems();
    }

    protected Item[] doGetSelection() {
        return this.grid.getSelection();
    }

    protected int[] doGetSelectionIndices() {
        return this.grid.getSelectionIndices();
    }

    protected int doIndexOf(Item item) {
        return this.grid.indexOf((GridItem)item);
    }

    protected void doRemove(int[] indices) {
        this.grid.remove(indices);
    }

    protected void doRemove(int start, int end) {
        this.grid.remove(start, end);
    }

    protected void doRemoveAll() {
        this.grid.removeAll();
    }

    protected void doSetSelection(Item[] items) {
        GridItem[] items2 = new GridItem[items.length];
        int i = 0;
        while (i < items.length) {
            items2[i] = (GridItem)items[i];
            ++i;
        }
        this.grid.setSelection(items2);
        this.grid.showSelection();
    }

    protected void doSetSelection(int[] indices) {
        this.grid.setSelection(indices);
    }

    protected void doShowItem(Item item) {
        this.grid.showItem((GridItem)item);
    }

    protected void doShowSelection() {
        this.grid.showSelection();
    }

    protected Item getItemAt(Point point) {
        return this.grid.getItem(point);
    }

    public Control getControl() {
        return this.grid;
    }

    protected ViewerRow getViewerRowFromItem(Widget item) {
        if (this.cachedRow == null) {
            this.cachedRow = new GridViewerRow((GridItem)item);
        } else {
            this.cachedRow.setItem((GridItem)item);
        }
        return this.cachedRow;
    }

    protected void doResetItem(Item item) {
        GridItem gridItem = (GridItem)item;
        int columnCount = Math.max(1, this.grid.getColumnCount());
        int i = 0;
        while (i < columnCount) {
            gridItem.setText(i, "");
            gridItem.setImage(null);
            ++i;
        }
    }

    protected void doSelect(int[] indices) {
        this.grid.select(indices);
    }

    public void setAutoPreferredHeight(boolean autoPreferredHeight) {
        this.autoPreferredHeight = autoPreferredHeight;
    }

    public boolean getAutoPreferredHeight() {
        return this.autoPreferredHeight;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        super.doUpdateItem(widget, element, fullMap);
        this.updateRowHeader(widget);
        if (this.autoPreferredHeight && !widget.isDisposed()) {
            ((GridItem)widget).pack();
        }
    }

    private void updateRowHeader(Widget widget) {
        if (this.rowHeaderLabelProvider != null) {
            ViewerCell cell = this.getViewerRowFromItem(widget).getCell(Integer.MAX_VALUE);
            this.rowHeaderLabelProvider.update(cell);
        }
    }

    public void setRowHeaderLabelProvider(CellLabelProvider rowHeaderLabelProvider) {
        this.rowHeaderLabelProvider = rowHeaderLabelProvider;
    }

    public void refreshRowHeaders(Object element) {
        boolean refresh = element == null;
        GridItem[] items = this.getGrid().getItems();
        int i = 0;
        while (i < items.length) {
            if (refresh || element.equals(items[i].getData())) {
                refresh = true;
                this.updateRowHeader((Widget)items[i]);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void editElement(Object element, int column) {
        try {
            ViewerCell cell;
            ViewerRow row;
            this.getControl().setRedraw(false);
            Widget item = this.findItem(element);
            if (item != null && (row = this.getViewerRowFromItem(item)) != null && (cell = row.getCell(column)) != null) {
                this.triggerEditorActivationEvent(new ColumnViewerEditorActivationEvent(cell));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.getControl().setRedraw(true);
    }

    protected void setSelectionToWidget(ISelection selection, boolean reveal) {
        block8: {
            block9: {
                Object el;
                if (this.grid.isCellSelectionEnabled() && selection instanceof CellSelection) break block9;
                super.setSelectionToWidget(selection, reveal);
                if (!(selection instanceof SelectionWithFocusRow) || (el = ((SelectionWithFocusRow)selection).getFocusElement()) == null) break block8;
                GridItem[] items = this.grid.getItems();
                int i = 0;
                while (i < items.length) {
                    GridItem item = items[i];
                    if (item.getData() == el || item.getData().equals(el) || this.getComparer() != null && this.getComparer().equals(item.getData(), el)) {
                        this.grid.setFocusItem(item);
                        break block8;
                    }
                    ++i;
                }
                break block8;
            }
            CellSelection cellSelection = (CellSelection)selection;
            List l = cellSelection.toList();
            GridItem[] items = this.grid.getItems();
            ArrayList<Point> pts = new ArrayList<Point>();
            int i = 0;
            while (i < items.length) {
                Iterator it = l.iterator();
                Object itemObject = items[i].getData();
                while (it.hasNext()) {
                    Object checkObject = it.next();
                    if (itemObject != checkObject && (this.getComparer() == null || !this.getComparer().equals(itemObject, checkObject))) continue;
                    Iterator idxIt = cellSelection.getIndices(checkObject).iterator();
                    while (idxIt.hasNext()) {
                        Integer idx = (Integer)idxIt.next();
                        pts.add(new Point(idx.intValue(), i));
                    }
                }
                ++i;
            }
            Point[] tmp = new Point[pts.size()];
            pts.toArray(tmp);
            this.grid.setCellSelection(tmp);
            if (cellSelection.getFocusElement() != null) {
                Object el = cellSelection.getFocusElement();
                int i2 = 0;
                while (i2 < items.length) {
                    GridItem item = items[i2];
                    if (item.getData() == el || item.getData().equals(el) || this.getComparer() != null && this.getComparer().equals(item.getData(), el)) {
                        this.grid.setFocusItem(item);
                        break;
                    }
                    ++i2;
                }
            }
        }
    }

    public ISelection getSelection() {
        if (!this.grid.isCellSelectionEnabled()) {
            IStructuredSelection selection = (IStructuredSelection)super.getSelection();
            Object el = null;
            if (this.grid.getFocusItem() != null) {
                el = this.grid.getFocusItem().getData();
            }
            return new SelectionWithFocusRow(selection.toList(), el, this.getComparer());
        }
        return this.createCellSelection();
    }

    private CellSelection createCellSelection() {
        Point[] ps = this.grid.getCellSelection();
        Arrays.sort(ps, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Point a = (Point)arg0;
                Point b = (Point)arg1;
                int rv = a.y - b.y;
                if (rv == 0) {
                    rv = a.x - b.x;
                }
                return rv;
            }
        });
        ArrayList<Object> objectList = new ArrayList<Object>();
        ArrayList indiceLists = new ArrayList();
        ArrayList<Integer> indiceList = new ArrayList<Integer>();
        int curLine = -1;
        int i = 0;
        while (i < ps.length) {
            if (curLine != ps[i].y) {
                curLine = ps[i].y;
                indiceList = new ArrayList();
                indiceLists.add(indiceList);
                objectList.add(this.grid.getItem(curLine).getData());
            }
            indiceList.add(new Integer(ps[i].x));
            ++i;
        }
        Object focusElement = null;
        if (this.grid.getFocusItem() != null) {
            focusElement = this.grid.getFocusItem().getData();
        }
        return new CellSelection(objectList, indiceLists, focusElement, this.getComparer());
    }
}

