/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.jface.gridviewer;

import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class GridViewerRow
extends ViewerRow {
    private GridItem item;

    GridViewerRow(GridItem item) {
        this.item = item;
    }

    public Rectangle getBounds(int columnIndex) {
        if (columnIndex == Integer.MAX_VALUE) {
            return null;
        }
        if (!this.item.getParent().getColumn(columnIndex).isVisible()) {
            return new Rectangle(0, 0, 0, 0);
        }
        return this.item.getBounds(columnIndex);
    }

    public Rectangle getBounds() {
        return this.item.getBounds(0);
    }

    public int getColumnCount() {
        return this.item.getParent().getColumnCount();
    }

    public Color getBackground(int columnIndex) {
        if (columnIndex == Integer.MAX_VALUE) {
            return null;
        }
        return this.item.getBackground(columnIndex);
    }

    public Font getFont(int columnIndex) {
        if (columnIndex == Integer.MAX_VALUE) {
            return null;
        }
        return this.item.getFont(columnIndex);
    }

    public Color getForeground(int columnIndex) {
        if (columnIndex == Integer.MAX_VALUE) {
            return null;
        }
        return this.item.getForeground(columnIndex);
    }

    public Image getImage(int columnIndex) {
        if (columnIndex == Integer.MAX_VALUE) {
            return null;
        }
        return this.item.getImage(columnIndex);
    }

    public String getText(int columnIndex) {
        if (columnIndex == Integer.MAX_VALUE) {
            return this.item.getHeaderText();
        }
        return this.item.getText(columnIndex);
    }

    public void setBackground(int columnIndex, Color color) {
        if (columnIndex == Integer.MAX_VALUE) {
            this.item.setHeaderBackground(color);
        } else {
            this.item.setBackground(columnIndex, color);
        }
    }

    public void setFont(int columnIndex, Font font) {
        if (columnIndex != Integer.MAX_VALUE) {
            this.item.setFont(columnIndex, font);
        }
    }

    public void setForeground(int columnIndex, Color color) {
        if (columnIndex == Integer.MAX_VALUE) {
            this.item.setHeaderForeground(color);
        } else {
            this.item.setForeground(columnIndex, color);
        }
    }

    public void setImage(int columnIndex, Image image) {
        if (columnIndex == Integer.MAX_VALUE) {
            this.item.setHeaderImage(image);
        } else {
            this.item.setImage(columnIndex, image);
        }
    }

    public void setText(int columnIndex, String text) {
        if (columnIndex == Integer.MAX_VALUE) {
            this.item.setHeaderText(text);
        } else {
            this.item.setText(columnIndex, text == null ? "" : text);
        }
    }

    public Control getControl() {
        return this.item.getParent();
    }

    public ViewerRow getNeighbor(int direction, boolean sameLevel) {
        if (direction == 1) {
            return this.getRowAbove();
        }
        if (direction == 2) {
            return this.getRowBelow();
        }
        throw new IllegalArgumentException("Illegal value of direction argument.");
    }

    private ViewerRow getRowAbove() {
        int index = this.item.getParent().indexOf(this.item) - 1;
        if (index >= 0) {
            return new GridViewerRow(this.item.getParent().getItem(index));
        }
        return null;
    }

    private ViewerRow getRowBelow() {
        GridItem tmp;
        int index = this.item.getParent().indexOf(this.item) + 1;
        if (index < this.item.getParent().getItemCount() && (tmp = this.item.getParent().getItem(index)) != null) {
            return new GridViewerRow(tmp);
        }
        return null;
    }

    public TreePath getTreePath() {
        return new TreePath(new Object[]{this.item.getData()});
    }

    public Object clone() {
        return new GridViewerRow(this.item);
    }

    public Object getElement() {
        return this.item.getData();
    }

    void setItem(GridItem item) {
        this.item = item;
    }

    public Widget getItem() {
        return this.item;
    }

    public int getVisualIndex(int creationIndex) {
        int[] order = this.item.getParent().getColumnOrder();
        int i = 0;
        while (i < order.length) {
            if (order[i] == creationIndex) {
                return i;
            }
            ++i;
        }
        return super.getVisualIndex(creationIndex);
    }

    public int getCreationIndex(int visualIndex) {
        if (this.item != null && !this.item.isDisposed() && this.hasColumns() && this.isValidOrderIndex(visualIndex)) {
            return this.item.getParent().getColumnOrder()[visualIndex];
        }
        return super.getCreationIndex(visualIndex);
    }

    private boolean hasColumns() {
        return this.item.getParent().getColumnCount() != 0;
    }

    private boolean isValidOrderIndex(int currentIndex) {
        return currentIndex < this.item.getParent().getColumnOrder().length;
    }

    protected boolean isColumnVisible(int columnIndex) {
        return this.item.getParent().getColumn(columnIndex).isVisible();
    }
}

