/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal;

import org.eclipse.swt.graphics.GC;

public class TextUtils {
    public static String getShortText(GC gc, String t, int width) {
        int pivot;
        if (t == null) {
            return null;
        }
        if (t.equals("")) {
            return "";
        }
        if (width >= gc.textExtent((String)t).x) {
            return t;
        }
        int w = gc.textExtent((String)"...").x;
        String text = t;
        int l = text.length();
        int s = pivot = l / 2;
        int e = pivot + 1;
        while (s >= 0 && e < l) {
            String s1 = text.substring(0, s);
            String s2 = text.substring(e, l);
            int l1 = gc.textExtent((String)s1).x;
            int l2 = gc.textExtent((String)s2).x;
            if (l1 + w + l2 < width) {
                text = String.valueOf(s1) + "..." + s2;
                break;
            }
            --s;
            ++e;
        }
        if (s == 0 || e == l) {
            text = String.valueOf(text.substring(0, 1)) + "..." + text.substring(l - 1, l);
        }
        return text;
    }

    public static String getShortString(GC gc, String t, int width) {
        int pivot;
        if (t == null) {
            return null;
        }
        if (t.equals("")) {
            return "";
        }
        if (width >= gc.stringExtent((String)t).x) {
            return t;
        }
        int w = gc.stringExtent((String)"...").x;
        String text = t;
        int l = text.length();
        int s = pivot = l / 2;
        int e = pivot + 1;
        while (s >= 0 && e < l) {
            String s1 = text.substring(0, s);
            String s2 = text.substring(e, l);
            int l1 = gc.stringExtent((String)s1).x;
            int l2 = gc.stringExtent((String)s2).x;
            if (l1 + w + l2 < width) {
                text = String.valueOf(s1) + "..." + s2;
                break;
            }
            --s;
            ++e;
        }
        if (s == 0 || e == l) {
            text = String.valueOf(text.substring(0, 1)) + "..." + text.substring(l - 1, l);
        }
        return text;
    }

    protected TextUtils() {
    }
}

