/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.publisher.hessian;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.communication.core.zipsupport.ReusableBufferedInputStream;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.internal.communication.factory.hessian.serializer.RienaSerializerFactory;
import org.eclipse.riena.internal.communication.publisher.hessian.Activator;
import org.eclipse.riena.internal.communication.publisher.hessian.HessianRemoteServicePublisher;
import org.eclipse.riena.internal.communication.publisher.hessian.MessageContext;
import org.eclipse.riena.internal.communication.publisher.hessian.MessageContextHolder;

public class RienaHessianDispatcherServlet
extends GenericServlet {
    private SerializerFactory serializerFactory = null;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), RienaHessianDispatcherServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.serializerFactory = new SerializerFactory();
        this.serializerFactory.setAllowNonSerializable(true);
        this.serializerFactory.addFactory((AbstractSerializerFactory)new RienaSerializerFactory());
        LOGGER.log(4, "initialized");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        block22: {
            httpReq = (HttpServletRequest)req;
            httpRes = (HttpServletResponse)res;
            MessageContextHolder.setMessageContext(new MessageContext(httpReq, httpRes));
            publisher = this.getPublisher();
            if (publisher == null) {
                if (httpReq.getMethod().equals("GET")) {
                    if (httpReq.getRemoteHost().equals("127.0.0.1")) {
                        pw = new PrintWriter((OutputStream)res.getOutputStream());
                        pw.write("no webservices available");
                        pw.flush();
                        pw.close();
                        return;
                    }
                    httpRes.sendError(405, "Hessian requires POST");
                    return;
                }
                httpRes.sendError(404, "webservice not found");
                return;
            }
            requestURI = httpReq.getRequestURI();
            contextPath = httpReq.getContextPath();
            if (contextPath.length() > 1) {
                requestURI = requestURI.substring(contextPath.length());
            }
            rsd = publisher.findService(requestURI);
            this.log("call " + rsd);
            if (httpReq.getMethod().equals("GET")) {
                if (httpReq.getRemoteHost().equals("127.0.0.1")) {
                    pw = new PrintWriter((OutputStream)res.getOutputStream());
                    if (rsd == null) {
                        pw.write("call received from browser, no remote service registered with this URL");
                    } else {
                        pw.write("calls " + rsd);
                    }
                    pw.flush();
                    pw.close();
                    return;
                }
                httpRes.sendError(405, "Hessian requires POST");
                return;
            }
            if (rsd == null) {
                httpRes.sendError(404, "unknown url :" + httpReq.getRequestURI());
                return;
            }
            gzip = httpReq.getHeader("Content-Encoding");
            gzipFlag = "x-hessian-gzip".equals(gzip);
            inputWasGZIP = false;
            requestInputStream = httpReq.getInputStream();
            if (gzipFlag) {
                tempInput = new ReusableBufferedInputStream((InputStream)requestInputStream);
                if (tempInput.markSupported()) {
                    tempInput.mark(20);
                    readMAGIC = tempInput.read() + tempInput.read() * 256;
                    inputWasGZIP = readMAGIC == 35615;
                    tempInput.reset();
                }
                requestInputStream = inputWasGZIP != false ? new GZIPInputStream((InputStream)tempInput) : tempInput;
            }
            inp = new Hessian2Input((InputStream)requestInputStream);
            inp.setSerializerFactory(this.serializerFactory);
            inp.setCloseStreamOnClose(true);
            code = inp.read();
            if (code != 99) {
                throw new IOException("expected 'c' in hessian input at " + code);
            }
            major = inp.read();
            inp.read();
            if (gzipFlag) {
                httpRes.setHeader("Content-Encoding", "x-hessian-gzip");
            }
            outputStream /* !! */  = httpRes.getOutputStream();
            if (gzipFlag) {
                outputStream /* !! */  = new GZIPOutputStream((OutputStream)outputStream /* !! */ );
            }
            if (major >= 2) {
                out = new Hessian2Output((OutputStream)outputStream /* !! */ );
                out.setCloseStreamOnClose(true);
            } else {
                out = new HessianOutput((OutputStream)outputStream /* !! */ );
            }
            out.setSerializerFactory(this.serializerFactory);
            try {
                try {
                    sk = new HessianSkeleton(rsd.getService(), rsd.getServiceInterfaceClass());
                    sk.invoke((AbstractHessianInput)inp, (AbstractHessianOutput)out);
                    break block22;
                }
                catch (Throwable t) {
                    t2 = t;
                    ** while (t2.getCause() != null)
                }
lbl-1000:
                // 1 sources

                {
                    t2 = t2.getCause();
                    continue;
                }
lbl80:
                // 1 sources

                RienaHessianDispatcherServlet.LOGGER.log(1, t.getMessage(), t2);
                ((IExceptionHandlerManager)Service.get(IExceptionHandlerManager.class)).handleException(t2);
                throw new ServletException(t);
            }
            finally {
                inp.close();
                out.close();
            }
        }
    }

    protected HessianRemoteServicePublisher getPublisher() {
        return Activator.getDefault().getPublisher();
    }
}

