/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerationalListenerList<E>
implements Iterable<E> {
    private int generation = 0;
    private boolean modified;
    private int size;
    private Entry<E> tail = new Entry(null, this.generation);
    private final Entry<E> head = this.tail;
    private int outStandigIterators;
    private final int iteratorReturnedThreshold;
    private final float removedSizeRatioThreshold;
    private final int sizeThreshold;
    private int iteratorsReturned;
    private int virtuallyRemoved;
    private static final int NEVER_GC = -1;
    private static boolean printStats = true;
    private static int statsCounter;
    private int statsListNumber = ++statsCounter;
    private int statsAdded = 0;
    private int statsRemoved = 0;
    private int statsIterated = 0;

    public GenerationalListenerList() {
        this(-1, 1.0f, Integer.MAX_VALUE);
    }

    public GenerationalListenerList(int iteratorReturnedThreshold, float removedSizeRatioThreshold, int sizeThreshold) {
        this.iteratorReturnedThreshold = iteratorReturnedThreshold;
        this.removedSizeRatioThreshold = removedSizeRatioThreshold;
        this.sizeThreshold = sizeThreshold;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Entry next = this.head;
        while (next != null) {
            if (next.isVisible(this.generation) && o.equals(next.item)) {
                return true;
            }
            next = next.nextEntry;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        ++this.statsIterated;
        this.stats();
        ++this.outStandigIterators;
        StableIterator stableIterator = new StableIterator(this.generation);
        if (this.modified) {
            this.modified = false;
            ++this.generation;
        }
        return stableIterator;
    }

    private void iteratorhasFinished() {
        --this.outStandigIterators;
        if (this.iteratorReturnedThreshold == -1) {
            return;
        }
        ++this.iteratorsReturned;
        if (this.outStandigIterators == 0 && this.iteratorsReturned >= this.iteratorReturnedThreshold && this.size >= this.sizeThreshold && (float)this.virtuallyRemoved / (float)this.size >= this.removedSizeRatioThreshold) {
            this.iteratorsReturned = 0;
            this.gc();
        }
    }

    private void gc() {
        Entry next;
        System.out.println(">>>>>>>>>>>>>>>>>>>>>>>> GC <<<<<<<<<<<<<<<<<<<<<");
        Entry before = next = this.head;
        while (next != null) {
            if (next.isRemoved()) {
                System.out.println("Removing: " + next.item);
                before.nextEntry = next.nextEntry;
            }
            before = next;
            next = next.nextEntry;
        }
        this.virtuallyRemoved = 0;
    }

    public boolean add(E o) {
        Assert.isLegal((o != null ? 1 : 0) != 0, (String)"o nust not be null");
        ++this.size;
        Entry entry = new Entry(o, this.generation);
        ((Entry)this.tail).nextEntry = entry;
        this.tail = entry;
        this.modified = true;
        ++this.statsAdded;
        this.stats();
        return true;
    }

    private void stats() {
        if (!printStats) {
            return;
        }
        System.out.println(String.valueOf(this.statsListNumber) + " - add: " + this.statsAdded + ", remove: " + this.statsRemoved + ", iterator: " + this.statsIterated);
    }

    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        ++this.statsRemoved;
        this.stats();
        Entry next = this.head;
        while (next != null) {
            if (next.isVisible(this.generation) && o.equals(next.item)) {
                next.removedGeneration = this.generation;
                --this.size;
                this.modified = true;
                ++this.virtuallyRemoved;
                return true;
            }
            next = next.nextEntry;
        }
        return false;
    }

    public void clear() {
        Entry next = this.head;
        while (next != null) {
            if (next.isVisible(this.generation)) {
                next.removedGeneration = this.generation;
            }
            next = next.nextEntry;
        }
        this.size = 0;
    }

    public void printDebugList(String header) {
        Entry next = this.head;
        System.out.println(String.valueOf(header) + "(debug)");
        while (next != null) {
            if (next != this.head) {
                System.out.println(" - " + next);
            }
            next = next.nextEntry;
        }
    }

    public void printList(String header) {
        Entry next = this.head;
        System.out.println(header);
        while (next != null) {
            if (next != this.head && next.isVisible(this.generation)) {
                System.out.println(" - " + next);
            }
            next = next.nextEntry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Entry<E> {
        private final E item;
        private final int addedGeneration;
        private int removedGeneration = -1;
        private Entry<E> nextEntry;

        private Entry(E item, int generation) {
            this.item = item;
            this.addedGeneration = generation;
        }

        private boolean isRemoved() {
            return this.removedGeneration != -1;
        }

        private boolean isVisible(int generation) {
            return this.addedBefore(generation) && !this.removedBefore(generation);
        }

        private boolean addedBefore(int generation) {
            return this.addedGeneration <= generation;
        }

        private boolean removedBefore(int generation) {
            return this.removedGeneration != -1 && this.removedGeneration <= generation;
        }

        public String toString() {
            return "Entry [item=" + this.item + ", addedGeneration=" + this.addedGeneration + ", removedGeneration=" + this.removedGeneration + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StableIterator
    implements Iterator<E> {
        private final int generation;
        private Entry<E> next;

        public StableIterator(int generation) {
            this.next = GenerationalListenerList.this.head.nextEntry;
            this.generation = generation;
        }

        @Override
        public boolean hasNext() {
            while (this.next != null) {
                if (this.next.isVisible(this.generation)) {
                    return true;
                }
                this.next = this.next.nextEntry;
            }
            GenerationalListenerList.this.iteratorhasFinished();
            return false;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object item = this.next.item;
            this.next = this.next.nextEntry;
            return item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("StableIterator.remove");
        }
    }
}

