/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.singleton;

import java.lang.reflect.Constructor;
import org.eclipse.riena.core.singleton.ISingletonInitializer;
import org.eclipse.riena.core.singleton.SingletonFailure;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.wire.Wire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RCPSingletonProvider {
    private RCPSingletonProvider() {
        Nop.reason("utility");
    }

    public static <S> S getInstance(Class<S> singletonClass) {
        return RCPSingletonProvider.getInstance(singletonClass, null);
    }

    public static <S> S getInstance(Class<S> singletonClass, ISingletonInitializer<S> initializer) {
        boolean isAccessible = true;
        Constructor<S> constructor = null;
        try {
            constructor = singletonClass.getDeclaredConstructor(new Class[0]);
            isAccessible = constructor.isAccessible();
            if (!isAccessible) {
                constructor.setAccessible(true);
            }
            S result = constructor.newInstance(new Object[0]);
            if (initializer != null) {
                initializer.init(result);
            }
            Wire.instance(result).andStart();
            S s = result;
            return s;
        }
        catch (Exception e) {
            throw new SingletonFailure("Could not instantiate RCP controlled singleton.", e);
        }
        finally {
            if (!isAccessible && constructor != null) {
                constructor.setAccessible(false);
            }
        }
    }
}

