/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.optional.controllers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.beans.common.WordNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.swt.ColumnFormatter;
import org.eclipse.riena.ui.ridgets.swt.NumberColumnFormatter;
import org.eclipse.riena.ui.ridgets.swt.optional.IGridRidget;
import org.eclipse.riena.ui.swt.StatusMeter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridSubModuleController
extends SubModuleController {
    private ITableRidget grid;
    private List<WordNode> input;
    private Color green;
    private Color darkGreen;
    private IActionRidget buttonRename;

    public GridSubModuleController() {
        this(null);
        Display display = Display.getCurrent();
        this.green = display.getSystemColor(5);
        this.darkGreen = display.getSystemColor(6);
    }

    public GridSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void configureRidgets() {
        this.grid = (ITableRidget)this.getRidget(IGridRidget.class, "gridTable");
        final IToggleButtonRidget buttonPrintSelection = (IToggleButtonRidget)this.getRidget(IToggleButtonRidget.class, "buttonPrintSelection");
        IActionRidget buttonAddSibling = (IActionRidget)this.getRidget(IActionRidget.class, "buttonAddSibling");
        this.buttonRename = (IActionRidget)this.getRidget(IActionRidget.class, "buttonRename");
        IActionRidget buttonDelete = (IActionRidget)this.getRidget(IActionRidget.class, "buttonDelete");
        this.grid.addDoubleClickListener(new IActionListener(){

            public void callback() {
                WordNode node = (WordNode)GridSubModuleController.this.grid.getSingleSelectionObservable().getValue();
                if (node != null) {
                    boolean isUpperCase = !node.isUpperCase();
                    node.setUpperCase(isUpperCase);
                }
            }
        });
        this.grid.addSelectionListener(new ISelectionListener(){

            public void ridgetSelected(SelectionEvent event) {
                if (buttonPrintSelection.isSelected()) {
                    System.out.println(event);
                }
            }
        });
        buttonPrintSelection.setText("&Echo Selection");
        buttonPrintSelection.setSelected(true);
        buttonAddSibling.setText("&Add");
        buttonAddSibling.addListener(new IActionListener(){

            public void callback() {
                WordNode newNode = new WordNode("A_NEW_SIBLING");
                GridSubModuleController.this.input.add(newNode);
                GridSubModuleController.this.grid.updateFromModel();
                GridSubModuleController.this.grid.setSelection((Object)newNode);
            }
        });
        this.buttonRename.setText("&Modify");
        this.buttonRename.addListener(new IActionListener(){

            public void callback() {
                String newValue;
                WordNode node = (WordNode)GridSubModuleController.this.grid.getSingleSelectionObservable().getValue();
                if (node != null && (newValue = GridSubModuleController.this.getNewValue(node.getWordIgnoreUppercase())) != null) {
                    node.setWord(newValue);
                }
            }
        });
        buttonDelete.setText("&Delete");
        buttonDelete.addListener(new IActionListener(){

            public void callback() {
                WordNode node = (WordNode)GridSubModuleController.this.grid.getSingleSelectionObservable().getValue();
                GridSubModuleController.this.input.remove(node);
                GridSubModuleController.this.grid.updateFromModel();
            }
        });
        final IObservableValue viewerSelection = this.grid.getSingleSelectionObservable();
        ComputedValue hasSelection = new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                return viewerSelection.getValue() != null;
            }
        };
        DataBindingContext dbc = new DataBindingContext();
        this.bindEnablementToValue(dbc, (IRidget)buttonDelete, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IRidget)this.buttonRename, (IObservableValue)hasSelection);
        this.bindModel();
    }

    private void bindEnablementToValue(DataBindingContext dbc, IRidget ridget, IObservableValue value) {
        dbc.bindValue(BeansObservables.observeValue((Object)ridget, (String)"enabled"), value, null, null);
    }

    private void bindModel() {
        this.input = this.createInput();
        String[] columnPropertyNames = new String[]{"word", "upperCase", "ACount", "AQuota", "AQuota"};
        String[] columnHeaders = new String[]{"Word", "Uppercase", "A Count", "A Quota [%]", "S"};
        this.grid.bindToModel((IObservableList)new WritableList(this.input, WordNode.class), WordNode.class, columnPropertyNames, columnHeaders);
        this.grid.updateFromModel();
        this.grid.setComparator(0, (Comparator)new TypedComparator());
        this.grid.setComparator(1, (Comparator)new TypedComparator());
        this.grid.setColumnSortable(2, false);
        this.grid.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        this.grid.setSelection(0);
        this.grid.setColumnFormatter(3, (IColumnFormatter)new NumberColumnFormatter(Float.class, 2){

            protected Number getValue(Object element) {
                return Float.valueOf(((WordNode)element).getAQuota());
            }
        });
        this.grid.setColumnFormatter(4, (IColumnFormatter)new ColumnFormatter(){

            public String getText(Object element) {
                return "";
            }

            public String getToolTip(Object element) {
                if (((WordNode)element).isUpperCase()) {
                    return null;
                }
                int value = (int)((WordNode)element).getAQuota();
                return "approx. " + value + "%";
            }

            public Color getToolTipForegroundColor(Object element) {
                if (((WordNode)element).isUpperCase()) {
                    return Display.getDefault().getSystemColor(2);
                }
                return Display.getDefault().getSystemColor(9);
            }

            public Color getToolTipBackgroundColor(Object element) {
                return Display.getDefault().getSystemColor(1);
            }

            public ImageData getImage(Object element) {
                if (((WordNode)element).isUpperCase()) {
                    return StatusMeter.imageFinished().width(16).gradientStartColor(GridSubModuleController.this.green).gradientEndColor(GridSubModuleController.this.darkGreen).getImageData();
                }
                int value = (int)((WordNode)element).getAQuota();
                return StatusMeter.imageDefault().width(16).value(value).getImageData();
            }
        });
    }

    private List<WordNode> createInput() {
        String[] words = new String[]{"Adventure", "Acclimatisation", "Aardwark", "Binoculars", "Beverage", "Boredom", "Ballistics", "Calculation", "Coexistence", "Cinnamon", "Celebration", "Disney", "Dictionary", "Delta", "Desperate", "Elf", "Electronics", "Elwood", "Enemy"};
        ArrayList<WordNode> result = new ArrayList<WordNode>(words.length);
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            WordNode node = new WordNode(word);
            result.add(node);
            ++n2;
        }
        ((WordNode)result.get(0)).setUpperCase(true);
        ((WordNode)result.get(1)).setUpperCase(true);
        return result;
    }

    private String getNewValue(Object oldValue) {
        String newValue = null;
        if (oldValue != null) {
            Shell shell = ((Button)this.buttonRename.getUIControl()).getShell();
            IInputValidator validator = new IInputValidator(){

                public String isValid(String newText) {
                    boolean isValid = newText.trim().length() > 0;
                    return isValid ? null : "Word cannot be empty!";
                }
            };
            InputDialog dialog = new InputDialog(shell, "Modify", "Enter a new word:", String.valueOf(oldValue), validator);
            int result = dialog.open();
            if (result == 0) {
                newValue = dialog.getValue();
            }
        }
        return newValue;
    }
}

