/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.uiprocess.UIProcess;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ILabelRidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingSubModuleController
extends SubModuleController {
    public static final String RIDGET_BLOCK_MODULE = "blockModule";
    public static final String RIDGET_BLOCK_SUB_MODULE = "blockSubModule";
    public static final String RIDGET_BLOCK_SUB_APP = "blockSubApplication";
    public static final String RIDGET_DISABLE_MODULE = "disableModule";
    public static final String RIDGET_STATUS = "status";
    private ILabelRidget status;

    public BlockingSubModuleController() {
    }

    public BlockingSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void configureRidgets() {
        super.configureRidgets();
        IActionRidget blockSubModule = (IActionRidget)this.getRidget(IActionRidget.class, RIDGET_BLOCK_SUB_MODULE);
        blockSubModule.setText("Block current SubModule = Blocking");
        blockSubModule.addListener(new IActionListener(){

            public void callback() {
                BlockingSubModuleController.this.blockNode(BlockingSubModuleController.this.getNavigationNode());
            }
        });
        IActionRidget blockModule = (IActionRidget)this.getRidget(IActionRidget.class, RIDGET_BLOCK_MODULE);
        blockModule.setText("Block current Module = Playground");
        blockModule.addListener(new IActionListener(){

            public void callback() {
                BlockingSubModuleController.this.blockNode(BlockingSubModuleController.this.getModuleNode());
            }
        });
        IActionRidget blockSubApp = (IActionRidget)this.getRidget(IActionRidget.class, RIDGET_BLOCK_SUB_APP);
        blockSubApp.setText("Block current SubApplication = Playground Tab");
        blockSubApp.addListener(new IActionListener(){

            public void callback() {
                BlockingSubModuleController.this.blockNode(BlockingSubModuleController.this.getSubApplicationNode());
            }
        });
        IActionRidget disableModule = (IActionRidget)this.getRidget(IActionRidget.class, RIDGET_DISABLE_MODULE);
        disableModule.setText("Disable current Module = Playground");
        disableModule.addListener(new IActionListener(){

            public void callback() {
                INavigationNode moduleNode = BlockingSubModuleController.this.getModuleNode();
                BlockingSubModuleController.this.disableNode(moduleNode);
            }
        });
        this.status = (ILabelRidget)this.getRidget(ILabelRidget.class, RIDGET_STATUS);
    }

    private void blockNode(INavigationNode<?> node) {
        BlockerUIProcess process = new BlockerUIProcess(node, this.status);
        process.setBlock(true);
        process.start();
    }

    private void disableNode(INavigationNode<?> node) {
        BlockerUIProcess process = new BlockerUIProcess(node, this.status);
        process.setDisable(true);
        process.start();
    }

    private INavigationNode<?> getModuleNode() {
        return ((ISubModuleNode)this.getNavigationNode()).getParentOfType(IModuleNode.class);
    }

    private INavigationNode<?> getSubApplicationNode() {
        return ((ISubModuleNode)this.getNavigationNode()).getParentOfType(ISubApplicationNode.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlockerUIProcess
    extends UIProcess {
        private final INavigationNode<?> node;
        private final ILabelRidget labelRidget;
        private boolean disable;
        private boolean block;
        private String subAppToolTip;

        public BlockerUIProcess(INavigationNode<?> node, ILabelRidget labelRidget) {
            super("block", false);
            this.node = node;
            this.labelRidget = labelRidget;
        }

        private ISubApplicationNode getSubApplication() {
            return (ISubApplicationNode)this.node.getParentOfType(ISubApplicationNode.class);
        }

        public void setBlock(boolean doBlock) {
            this.block = doBlock;
        }

        public void setDisable(boolean doDisable) {
            this.disable = doDisable;
        }

        public void initialUpdateUI(int totalWork) {
            this.subAppToolTip = this.getSubApplication().getToolTipText();
            this.getSubApplication().setToolTipText(String.format("Node '%s' is blocked", this.node.getLabel()));
            this.labelRidget.setText(String.format("Changing '%s' for 10s", this.node.getLabel()));
            if (this.block) {
                this.node.setBlocked(true);
            }
            if (this.disable) {
                this.node.setEnabled(false);
            }
        }

        public void finalUpdateUI() {
            this.labelRidget.setText(String.format("Restored '%s'", this.node.getLabel()));
            if (this.block) {
                this.node.setBlocked(false);
            }
            if (this.disable) {
                this.node.setEnabled(true);
                this.node.activate();
            }
            this.getSubApplication().setToolTipText(this.subAppToolTip);
        }

        public boolean runJob(IProgressMonitor monitor) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            return true;
        }
    }
}

