/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.beans.common.ListBean;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.StringBean;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ICompositeRidget;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.IMultipleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;

public class LayoutSubModuleController
extends SubModuleController {
    private String[] ridgets;
    private String[] captions;
    private int length = 1;

    public void configureRidgets() {
        ISingleChoiceRidget ccGender = (ISingleChoiceRidget)this.getRidget(ISingleChoiceRidget.class, "ccGender");
        ccGender.bindToModel(Arrays.asList("female", "male"), null, (Object)new StringBean(), "value");
        ccGender.updateFromModel();
        IMultipleChoiceRidget ccPets = (IMultipleChoiceRidget)this.getRidget(IMultipleChoiceRidget.class, "ccPets");
        ccPets.bindToModel(Arrays.asList(Person.Pets.values()), null, (Object)new ListBean(), "values");
        ccPets.updateFromModel();
        IActionRidget btnMore = (IActionRidget)this.getRidget(IActionRidget.class, "btnMore");
        final IActionRidget btnLess = (IActionRidget)this.getRidget(IActionRidget.class, "btnLess");
        btnMore.addListener(new IActionListener(){

            public void callback() {
                LayoutSubModuleController layoutSubModuleController = LayoutSubModuleController.this;
                layoutSubModuleController.length = layoutSubModuleController.length + 1;
                btnLess.setEnabled(true);
                LayoutSubModuleController.this.updateCaptions(LayoutSubModuleController.this.ridgets, LayoutSubModuleController.this.captions, LayoutSubModuleController.this.length);
                ((ICompositeRidget)LayoutSubModuleController.this.getRidget(ICompositeRidget.class, "parent")).layout();
            }
        });
        btnLess.addListener(new IActionListener(){

            public void callback() {
                LayoutSubModuleController layoutSubModuleController = LayoutSubModuleController.this;
                layoutSubModuleController.length = layoutSubModuleController.length - 1;
                btnLess.setEnabled(LayoutSubModuleController.this.length > 1);
                LayoutSubModuleController.this.updateCaptions(LayoutSubModuleController.this.ridgets, LayoutSubModuleController.this.captions, LayoutSubModuleController.this.length);
                LayoutSubModuleController.this.layout();
            }
        });
        btnLess.setEnabled(false);
    }

    public void afterBind() {
        super.afterBind();
        this.ridgets = new String[]{"lblFirst", "lblLast", "lblGender", "lblPets"};
        this.captions = this.getCaptions(this.ridgets);
    }

    private String[] getCaptions(String[] ridgets) {
        String[] result = new String[ridgets.length];
        int i = 0;
        while (i < result.length) {
            result[i] = ((ILabelRidget)this.getRidget(ridgets[i])).getText();
            ++i;
        }
        return result;
    }

    private void updateCaptions(String[] ridgets, String[] texts, int length) {
        Assert.isLegal((length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < ridgets.length) {
            ILabelRidget ridget = (ILabelRidget)this.getRidget(ridgets[i]);
            StringBuilder caption = new StringBuilder();
            int j = 0;
            while (j < length) {
                caption.append(texts[i]);
                ++j;
            }
            ridget.setText(caption.toString());
            ++i;
        }
    }
}

