/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.beans.common.StringBean;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.example.client.Activator;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.holder.SelectableEnumHolder;

public class LogCollectorSubModuleController
extends SubModuleController {
    private final SelectableEnumHolder<LogLevel> logLevels;
    private final SelectableEnumHolder<CustomLogLevel> customLevels;
    private final StringBean logMessageBean = new StringBean("Log text");
    private final StringBean customMessageBean = new StringBean("Custom text");
    private final StringBean exceptionBean = new StringBean(NullPointerException.class.getName());
    private IComboRidget logLevelCombo;
    private IComboRidget customLevelCombo;
    private ITextRidget logMessage;
    private ITextRidget customMessage;
    private ITextRidget logException;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), LogCollectorSubModuleController.class);

    public LogCollectorSubModuleController() {
        this(null);
    }

    public LogCollectorSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
        this.logLevels = new SelectableEnumHolder(LogLevel.class);
        this.logLevels.setSelection((Object)LogLevel.DEBUG);
        this.customLevels = new SelectableEnumHolder(CustomLogLevel.class);
        this.customLevels.setSelection((Object)CustomLogLevel.USAGE);
    }

    public void afterBind() {
        super.afterBind();
        this.bindModels();
    }

    private void bindModels() {
        this.logLevelCombo.bindToModel(this.logLevels, null);
        this.logLevelCombo.updateFromModel();
        this.logMessage.bindToModel((Object)this.logMessageBean, "value");
        this.logMessage.updateFromModel();
        this.logException.bindToModel((Object)this.exceptionBean, "value");
        this.logException.updateFromModel();
        this.customLevelCombo.bindToModel(this.customLevels, null);
        this.customLevelCombo.updateFromModel();
        this.customMessage.bindToModel((Object)this.customMessageBean, "value");
        this.customMessage.updateFromModel();
    }

    public void configureRidgets() {
        this.logLevelCombo = (IComboRidget)this.getRidget(IComboRidget.class, "logLevelCombo");
        this.logMessage = (ITextRidget)this.getRidget(ITextRidget.class, "logMessage");
        this.logException = (ITextRidget)this.getRidget(ITextRidget.class, "logException");
        IActionRidget logButtonSave = (IActionRidget)this.getRidget(IActionRidget.class, "logButton");
        logButtonSave.setText("&Log");
        logButtonSave.addListener(new IActionListener(){

            public void callback() {
                Throwable throwable = null;
                try {
                    if (!StringUtils.isDeepEmpty((String)LogCollectorSubModuleController.this.logException.getText())) {
                        throwable = (Throwable)Class.forName(LogCollectorSubModuleController.this.logException.getText()).newInstance();
                    }
                }
                catch (Exception e) {
                    throwable = new IllegalArgumentException("Can not instantiate logException: " + LogCollectorSubModuleController.this.logException.getText(), e);
                }
                LOGGER.log(4 - LogCollectorSubModuleController.this.logLevelCombo.getSelectionIndex(), LogCollectorSubModuleController.this.logMessage.getText(), throwable);
            }
        });
        this.customLevelCombo = (IComboRidget)this.getRidget(IComboRidget.class, "customLevelCombo");
        this.customMessage = (ITextRidget)this.getRidget(ITextRidget.class, "customMessage");
        IActionRidget customButtonSave = (IActionRidget)this.getRidget(IActionRidget.class, "customButton");
        customButtonSave.setText("&CustomLog");
        customButtonSave.addListener(new IActionListener(){

            public void callback() {
                LOGGER.log(-LogCollectorSubModuleController.this.customLevelCombo.getSelectionIndex(), LogCollectorSubModuleController.this.customMessage.getText());
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CustomLogLevel {
        USAGE,
        STATS,
        SEND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

