/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitor;
import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitorRegistry;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.example.client.communication.IInfoService;
import org.eclipse.riena.example.client.communication.InfoServiceFake;
import org.eclipse.riena.example.client.communication.RemoteCallProcess;
import org.eclipse.riena.example.client.communication.ServiceProgressVisualizer;
import org.eclipse.riena.internal.example.client.Activator;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.uiprocess.UISynchronizer;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;

public class RemoteServiceProgressSubModuleController
extends SubModuleController {
    public static final String SERVICE_CALL_ACTION_MANUAL = "serviceCallActionManual";
    public static final String SERVICE_CALL_ACTION_UIPROCESS = "serviceCallActionUIProcess";
    private IRemoteProgressMonitorRegistry remoteProgressMonitorRegistry;
    private final IInfoService remoteService = new InfoServiceFake();

    public RemoteServiceProgressSubModuleController() {
        Inject.service(IRemoteProgressMonitorRegistry.class).useRanking().into((Object)this).andStart(Activator.getDefault().getContext());
    }

    public void bind(IRemoteProgressMonitorRegistry remoteProgressMonitorRegistry) {
        this.remoteProgressMonitorRegistry = remoteProgressMonitorRegistry;
    }

    public void unbind(IRemoteProgressMonitorRegistry remoteProgressMonitorRegistry) {
        this.remoteProgressMonitorRegistry = null;
    }

    public void configureRidgets() {
        this.getActionRidgetManual().setText("[Manual Way]");
        this.registerManualRemoteServiceCallback();
        this.getActionRidgetUIProcess().setText("[UIProcess Way]");
        this.registerUIProcessRemoteServiceCallback();
    }

    private IActionRidget getActionRidgetManual() {
        return (IActionRidget)this.getRidget(IActionRidget.class, SERVICE_CALL_ACTION_MANUAL);
    }

    private IActionRidget getActionRidgetUIProcess() {
        return (IActionRidget)this.getRidget(IActionRidget.class, SERVICE_CALL_ACTION_UIPROCESS);
    }

    private void registerManualRemoteServiceCallback() {
        this.getActionRidgetManual().addListener((IActionListener)new RemoteServiceManualCallbackAdapter());
    }

    private void simulateManualRemoteServiceCall() {
        new CommunicationSimulator().start();
    }

    private void registerUIProcessRemoteServiceCallback() {
        this.getActionRidgetUIProcess().addListener((IActionListener)new RemoteServiceUIProcessCallbackAdapter());
    }

    private void simulateUIProcessRemoteServiceCall() {
        RemoteCallProcess<IInfoService> process = new RemoteCallProcess<IInfoService>("remote", true, (Object)this.getNavigationNode()){

            public void initialUpdateUI(int totalWork) {
                super.initialUpdateUI(totalWork);
                RemoteServiceProgressSubModuleController.this.setBlocked(true);
            }

            public boolean runJob(IProgressMonitor monitor) {
                this.getService().getInfo("foo");
                return true;
            }

            public void finalUpdateUI() {
                super.finalUpdateUI();
                RemoteServiceProgressSubModuleController.this.setBlocked(false);
            }

            @Override
            protected IInfoService getService() {
                return RemoteServiceProgressSubModuleController.this.remoteService;
            }
        };
        process.start();
    }

    class CommunicationSimulator
    extends Thread {
        CommunicationSimulator() {
        }

        public void run() {
            this.blockSubModule(true);
            ServiceProgressVisualizer serviceProgress = new ServiceProgressVisualizer("remote");
            RemoteServiceProgressSubModuleController.this.remoteProgressMonitorRegistry.addProgressMonitor((Object)RemoteServiceProgressSubModuleController.this.remoteService, (IRemoteProgressMonitor)serviceProgress, IRemoteProgressMonitorRegistry.RemovalPolicy.AFTER_ALL_CALLS);
            RemoteServiceProgressSubModuleController.this.remoteService.getInfo("foo");
            RemoteServiceProgressSubModuleController.this.remoteProgressMonitorRegistry.removeAllProgressMonitors((Object)RemoteServiceProgressSubModuleController.this.remoteService);
            this.blockSubModule(false);
        }

        private void blockSubModule(final boolean block) {
            UISynchronizer.createSynchronizer().syncExec(new Runnable(){

                public void run() {
                    RemoteServiceProgressSubModuleController.this.setBlocked(block);
                }
            });
        }
    }

    class RemoteServiceManualCallbackAdapter
    implements IActionListener {
        RemoteServiceManualCallbackAdapter() {
        }

        public void callback() {
            RemoteServiceProgressSubModuleController.this.simulateManualRemoteServiceCall();
        }
    }

    class RemoteServiceUIProcessCallbackAdapter
    implements IActionListener {
        RemoteServiceUIProcessCallbackAdapter() {
        }

        public void callback() {
            RemoteServiceProgressSubModuleController.this.simulateUIProcessRemoteServiceCall();
        }
    }
}

