/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.listener.ApplicationNodeListener;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.ui.swt.component.SubApplicationItem;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.SubApplicationSwitcherRenderer;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubApplicationSwitcherWidget
extends Canvas {
    private final List<SubApplicationItem> items;
    private TabSelector tabSelector;
    private MnemonicListener mnemonicListener;
    private PaintDelegation paintDelegation;
    private final Control control = this;
    private final ApplicationListener applicationListener;
    private final SubApplicationListener subApplicationListener;

    public SubApplicationSwitcherWidget(Composite parent, int style, IApplicationNode application) {
        super(parent, style | 0x20000000);
        this.items = new ArrayList<SubApplicationItem>();
        this.applicationListener = new ApplicationListener();
        this.subApplicationListener = new SubApplicationListener();
        this.registerItems(application);
        SWTFacade.getDefault().createSubApplicationToolTip((Control)this);
        this.addListeners();
    }

    private void addListeners() {
        this.mnemonicListener = new MnemonicListener();
        this.addTraverseListener(this.mnemonicListener);
        this.tabSelector = new TabSelector();
        this.addMouseListener((MouseListener)this.tabSelector);
        this.paintDelegation = new PaintDelegation();
        this.addPaintListener(this.paintDelegation);
    }

    private void removeListeners() {
        this.removePaintListener(this.paintDelegation);
        this.removeMouseListener((MouseListener)this.tabSelector);
        this.removeTraverseListener(this.mnemonicListener);
    }

    private boolean activateItem(SubApplicationItem item) {
        if (this.isTabEnabled(item)) {
            item.getSubApplicationNode().activate();
            this.redraw();
            return true;
        }
        return false;
    }

    public SubApplicationItem getItem(Point point) {
        for (SubApplicationItem item : this.getItems()) {
            if (!item.getBounds().contains(point)) continue;
            return item;
        }
        return null;
    }

    private SubApplicationItem getItem(char mnemonic) {
        String mnemonicStrg = "&" + mnemonic;
        mnemonicStrg = mnemonicStrg.toLowerCase();
        for (SubApplicationItem item : this.getItems()) {
            String label = item.getLabel();
            if (label == null || !(label = label.toLowerCase()).contains(mnemonicStrg) || label.indexOf(38) != label.indexOf(mnemonicStrg)) continue;
            return item;
        }
        return null;
    }

    private boolean isTabEnabled(SubApplicationItem item) {
        if (item == null) {
            return false;
        }
        if (!item.getMarkersOfType(HiddenMarker.class).isEmpty()) {
            return false;
        }
        return item.getMarkersOfType(DisabledMarker.class).isEmpty();
    }

    private List<SubApplicationItem> getItems() {
        return this.items;
    }

    private void registerItems(IApplicationNode applicationModel) {
        applicationModel.addListener((INavigationNodeListener)this.applicationListener);
        List subApps = applicationModel.getChildren();
        for (ISubApplicationNode subApp : subApps) {
            this.registerSubApplication(subApp);
        }
    }

    private void registerSubApplication(ISubApplicationNode subApp) {
        subApp.addListener((INavigationNodeListener)this.subApplicationListener);
        SubApplicationItem item = new SubApplicationItem((Composite)this, subApp);
        this.getItems().add(item);
        IApplicationNode applicationNode = this.findApplicationNode(this.getItems());
        if (applicationNode != null) {
            this.orderItems(applicationNode);
        }
    }

    private IApplicationNode findApplicationNode(List<SubApplicationItem> items) {
        for (SubApplicationItem item : items) {
            ISubApplicationNode node = item.getSubApplicationNode();
            if (node.getParent() == null) continue;
            return (IApplicationNode)node.getParent();
        }
        return null;
    }

    private void orderItems(IApplicationNode appNode) {
        Collections.sort(this.getItems(), new SubApplicationItemComparator(appNode));
    }

    private void unregisterSubApplication(ISubApplicationNode subApp) {
        subApp.removeListener((INavigationNodeListener)this.subApplicationListener);
        SubApplicationItem itemToRemove = null;
        for (SubApplicationItem item : this.getItems()) {
            if (!item.getSubApplicationNode().equals(subApp)) continue;
            itemToRemove = item;
            break;
        }
        if (itemToRemove != null) {
            this.getItems().remove(itemToRemove);
        }
    }

    private SubApplicationSwitcherRenderer getRenderer() {
        return (SubApplicationSwitcherRenderer)LnfManager.getLnf().getRenderer("SubApplication.switcherRenderer");
    }

    public void dispose() {
        this.removeListeners();
        super.dispose();
    }

    private final class ApplicationListener
    extends ApplicationNodeListener {
        private ApplicationListener() {
        }

        public void childRemoved(IApplicationNode source, ISubApplicationNode childRemoved) {
            SubApplicationSwitcherWidget.this.unregisterSubApplication(childRemoved);
            SubApplicationSwitcherWidget.this.redraw();
        }

        public void childAdded(IApplicationNode source, ISubApplicationNode childAdded) {
            SubApplicationSwitcherWidget.this.registerSubApplication(childAdded);
            SubApplicationSwitcherWidget.this.redraw();
        }
    }

    private final class MnemonicListener
    implements TraverseListener {
        private MnemonicListener() {
        }

        public void keyTraversed(TraverseEvent evt) {
            if (evt.detail == 128) {
                SubApplicationItem item = SubApplicationSwitcherWidget.this.getItem(evt.character);
                SubApplicationSwitcherWidget.this.activateItem(item);
            }
        }
    }

    private class PaintDelegation
    implements PaintListener {
        private PaintDelegation() {
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            SubApplicationSwitcherWidget.this.getRenderer().setBounds(SubApplicationSwitcherWidget.this.getParent().getBounds());
            SubApplicationSwitcherWidget.this.getRenderer().setItems(SubApplicationSwitcherWidget.this.getItems());
            SubApplicationSwitcherWidget.this.getRenderer().paint(gc, SubApplicationSwitcherWidget.this.control);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubApplicationItemComparator
    implements Comparator<SubApplicationItem> {
        private final IApplicationNode appNode;

        public SubApplicationItemComparator(IApplicationNode appNode) {
            this.appNode = appNode;
        }

        @Override
        public int compare(SubApplicationItem item1, SubApplicationItem item2) {
            return this.appNode.getIndexOfChild((INavigationNode)item1.getSubApplicationNode()) < this.appNode.getIndexOfChild((INavigationNode)item2.getSubApplicationNode()) ? -1 : 1;
        }
    }

    private final class SubApplicationListener
    extends SubApplicationNodeListener {
        private SubApplicationListener() {
        }

        public void markerChanged(ISubApplicationNode source, IMarker marker) {
            SubApplicationSwitcherWidget.this.redraw();
        }

        public void disposed(ISubApplicationNode source) {
            SubApplicationSwitcherWidget.this.unregisterSubApplication(source);
            SubApplicationSwitcherWidget.this.redraw();
        }
    }

    private class TabSelector
    extends MouseAdapter {
        private TabSelector() {
        }

        public void mouseDown(MouseEvent e) {
            SubApplicationItem item = SubApplicationSwitcherWidget.this.getItem(new Point(e.x, e.y));
            SubApplicationSwitcherWidget.this.activateItem(item);
        }
    }
}

