/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.INavigationHistoryListener;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.IApplicationNodeListener;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.model.NavigationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationNode
extends NavigationNode<IApplicationNode, ISubApplicationNode, IApplicationNodeListener>
implements IApplicationNode {
    public static final String DEFAULT_APPLICATION_TYPEID = "application";
    private String logoPath;

    public ApplicationNode() {
        super(new NavigationNodeId(DEFAULT_APPLICATION_TYPEID));
        this.initializeNavigationProcessor();
    }

    @Override
    public Class<ISubApplicationNode> getValidChildType() {
        return ISubApplicationNode.class;
    }

    public ApplicationNode(NavigationNodeId nodeId) {
        super(nodeId);
        this.initializeNavigationProcessor();
    }

    public ApplicationNode(NavigationNodeId nodeId, String label) {
        this(nodeId);
        this.setLabel(label);
    }

    public ApplicationNode(String label) {
        this(new NavigationNodeId(DEFAULT_APPLICATION_TYPEID), label);
    }

    protected void initializeNavigationProcessor() {
        this.setNavigationProcessor(ApplicationNodeManager.getDefaultNavigationProcessor());
    }

    @Override
    public void addNavigationHistoryListener(INavigationHistoryListener listener) {
        this.getNavigationProcessor().addNavigationHistoryListener(listener);
    }

    @Override
    public void removeNavigationHistoryListener(INavigationHistoryListener listener) {
        this.getNavigationProcessor().removeNavigationHistoryListener(listener);
    }

    @Override
    public int getHistoryBackSize() {
        return this.getNavigationProcessor().getHistoryBackSize();
    }

    @Override
    public int getHistoryForwardSize() {
        return this.getNavigationProcessor().getHistoryForwardSize();
    }

    @Override
    public void setLogo(String logoPath) {
        String old = this.logoPath;
        this.logoPath = logoPath;
        this.propertyChangeSupport.firePropertyChange("logo", old, logoPath);
        this.notifyLogoChanged(logoPath);
    }

    public String getLogo() {
        return this.logoPath;
    }

    private void notifyLogoChanged(String logoPath) {
        for (INavigationNodeListener next : this.getListeners()) {
            if (!(next instanceof IApplicationNodeListener)) continue;
            ((IApplicationNodeListener)next).logoChanged(this, logoPath);
        }
    }
}

