/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction.context;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.objecttransaction.context.ContextHelper;
import org.eclipse.riena.objecttransaction.context.IContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextProxy
implements InvocationHandler {
    private final IContextHolder contextHolder;
    private final Object service;

    private ContextProxy(Object pService, IContextHolder pContextProvider) {
        this.service = pService;
        this.contextHolder = pContextProvider;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            ContextHelper.activateContext(this.contextHolder.getContext());
            method.setAccessible(true);
            Object object = method.invoke(this.service, args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            ContextHelper.passivateContext(this.contextHolder.getContext());
        }
    }

    public static <T> T cover(T pObject, IContextHolder pContextProvider) {
        Assert.isNotNull(pObject, (String)"The object to proxy must not be null");
        Assert.isNotNull((Object)pContextProvider, (String)"The context carrier must not be null");
        return (T)Proxy.newProxyInstance(pObject.getClass().getClassLoader(), ContextProxy.getInterfaces(pObject.getClass()), (InvocationHandler)new ContextProxy(pObject, pContextProvider));
    }

    public static <T extends IContextHolder> T cover(T pContextProvider) {
        Assert.isNotNull(pContextProvider, (String)"The context carrier must not be null");
        return (T)((IContextHolder)Proxy.newProxyInstance(pContextProvider.getClass().getClassLoader(), ContextProxy.getInterfaces(pContextProvider.getClass()), (InvocationHandler)new ContextProxy(pContextProvider, pContextProvider)));
    }

    private static Class<?>[] getInterfaces(Class<?> pClass) {
        Class<?>[] superinterfaces;
        Class<?>[] result = pClass.getInterfaces();
        Class<?> superclazz = pClass.getSuperclass();
        if (superclazz != null && (superinterfaces = ContextProxy.getInterfaces(superclazz)).length > 0) {
            Class[] superresult = new Class[result.length + superinterfaces.length];
            System.arraycopy(result, 0, superresult, 0, result.length);
            System.arraycopy(superinterfaces, 0, superresult, result.length, superinterfaces.length);
            result = superresult;
        }
        return result;
    }

    public Object getService() {
        return this.service;
    }
}

