/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.tests.Activator;

@NonUITestCase
public class Log4rTest
extends RienaTestCase {
    private String savedValue;

    protected void setUp() throws Exception {
        super.setUp();
        Log4rTest.assertNotNull((String)"Test must be a plugin unit test.", (Object)((Object)Activator.getDefault()));
        this.savedValue = System.getProperty("riena.development");
        System.clearProperty("riena.development");
    }

    protected void tearDown() throws Exception {
        if (this.savedValue != null) {
            System.setProperty("riena.development", this.savedValue);
        }
        super.tearDown();
    }

    public void testWithContext() {
        Logger logger = Log4r.getLogger((IRienaActivator)Activator.getDefault(), Log4rTest.class);
        Log4rTest.assertNotNull((Object)logger);
        Log4rTest.assertNotSame((Object)"ConsoleLogger", (Object)logger.getClass().getSimpleName());
        Log4rTest.assertNotSame((Object)"NullLogger", (Object)logger.getClass().getSimpleName());
    }

    public void testWithOutContextNoRienaDefaultLogging() {
        Logger logger = Log4r.getLogger(null, Log4rTest.class);
        Log4rTest.assertNotNull((Object)logger);
        String expectedLogger = this.isInOsgiDevMode() ? "ConsoleLogger" : "NullLogger";
        Log4rTest.assertEquals((String)expectedLogger, (String)logger.getClass().getSimpleName());
    }

    public void testWithOutContextWithRienaDefaultLoggingFalse() {
        System.setProperty("riena.development", Boolean.FALSE.toString());
        Logger logger = Log4r.getLogger(null, Log4rTest.class);
        Log4rTest.assertNotNull((Object)logger);
        Log4rTest.assertEquals((String)"NullLogger", (String)logger.getClass().getSimpleName());
    }

    public void testWithOutContextWithRienaDefaultLoggingTrue() {
        System.setProperty("riena.development", Boolean.TRUE.toString());
        Logger logger = Log4r.getLogger(null, Log4rTest.class);
        Log4rTest.assertNotNull((Object)logger);
        Log4rTest.assertEquals((String)"ConsoleLogger", (String)logger.getClass().getSimpleName());
    }

    public void testWithContextByName() {
        Logger logger = Log4r.getLogger((IRienaActivator)Activator.getDefault(), (String)Log4rTest.class.getName());
        Log4rTest.assertNotNull((Object)logger);
        Log4rTest.assertNotSame((Object)"ConsoleLogger", (Object)logger.getClass().getSimpleName());
        Log4rTest.assertNotSame((Object)"NullLogger", (Object)logger.getClass().getSimpleName());
    }

    public void testWithOutContextNoRienaDefaultLoggingByName() {
        Logger logger = Log4r.getLogger(null, (String)Log4rTest.class.getName());
        Log4rTest.assertNotNull((Object)logger);
        String expectedLogger = this.isInOsgiDevMode() ? "ConsoleLogger" : "NullLogger";
        Log4rTest.assertEquals((String)expectedLogger, (String)logger.getClass().getSimpleName());
    }

    public void testWithOutContextWithRienaDefaultLoggingFalseByName() {
        System.setProperty("riena.development", Boolean.FALSE.toString());
        Logger logger = Log4r.getLogger(null, (String)Log4rTest.class.getName());
        Log4rTest.assertNotNull((Object)logger);
        Log4rTest.assertEquals((String)"NullLogger", (String)logger.getClass().getSimpleName());
    }

    public void testWithOutContextWithRienaDefaultLoggingTrueByName() {
        System.setProperty("riena.development", Boolean.TRUE.toString());
        Logger logger = Log4r.getLogger(null, (String)Log4rTest.class.getName());
        Log4rTest.assertNotNull((Object)logger);
        Log4rTest.assertEquals((String)"ConsoleLogger", (String)logger.getClass().getSimpleName());
    }

    private boolean isInOsgiDevMode() {
        return System.getProperty("osgi.dev") != null;
    }
}

