/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.hessian;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonUITestCase
public abstract class AbstractSerializerFactoryTestCase
extends RienaTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.removeUnwantedSerializerFactories();
    }

    private void removeUnwantedSerializerFactories() {
        HashMap staticDeSerMap = (HashMap)ReflectionUtils.getHidden(SerializerFactory.class, (String)"_staticDeserializerMap");
        staticDeSerMap.remove(InputStream.class);
        staticDeSerMap.remove(StackTraceElement.class);
        HashMap staticSerMap = (HashMap)ReflectionUtils.getHidden(SerializerFactory.class, (String)"_staticSerializerMap");
        staticSerMap.remove(InputStream.class);
    }

    protected boolean isBackAndForthOk(Object object, Class<?> asReturnType, AbstractSerializerFactory ... abstractSerializerFactories) {
        return this.isBackAndForthOk(object, HessianSerializerVersion.One, asReturnType, abstractSerializerFactories) && this.isBackAndForthOk(object, HessianSerializerVersion.Two, asReturnType, abstractSerializerFactories);
    }

    protected boolean isBackAndForthOk(Object expected, HessianSerializerVersion version, Class<?> asReturnType, AbstractSerializerFactory ... abstractSerializerFactories) {
        Assert.isNotNull((Object)expected, (String)"expected value MUST not be null");
        try {
            return expected.equals(this.inAndOut(expected, version, asReturnType, abstractSerializerFactories));
        }
        catch (IOException e) {
            if (this.isTrace()) {
                this.println("Comparing in and out caused an IOException: " + e.getMessage());
            }
            return false;
        }
    }

    protected Object inAndOut(Object object, HessianSerializerVersion version, Class<?> asReturnType, AbstractSerializerFactory ... abstractSerializerFactories) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SerializerFactory factory = this.out(object, baos, version, asReturnType, abstractSerializerFactories);
        ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
        return this.in(is, version, asReturnType, factory);
    }

    protected SerializerFactory out(Object object, OutputStream outputStream, HessianSerializerVersion version, Class<?> asReturnType, AbstractSerializerFactory ... abstractSerializerFactories) throws IOException {
        Hessian2Output out = version == HessianSerializerVersion.Two ? new Hessian2Output(outputStream) : new HessianOutput(outputStream);
        SerializerFactory factory = out.findSerializerFactory();
        AbstractSerializerFactory[] abstractSerializerFactoryArray = abstractSerializerFactories;
        int n = abstractSerializerFactories.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractSerializerFactory serializerFactory = abstractSerializerFactoryArray[n2];
            factory.addFactory(serializerFactory);
            ++n2;
        }
        factory.setAllowNonSerializable(true);
        out.writeObject(object);
        out.close();
        return factory;
    }

    protected Object in(InputStream inputStream, HessianSerializerVersion version, Class<?> asReturnType, SerializerFactory factory) throws IOException {
        Hessian2Input in;
        Object object = in = version == HessianSerializerVersion.Two ? new Hessian2Input(inputStream) : new HessianInput(inputStream);
        if (factory != null) {
            in.setSerializerFactory(factory);
        }
        return in.readObject(asReturnType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum HessianSerializerVersion {
        One,
        Two;

    }
}

