/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.hessian;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.sun.security.auth.NTDomainPrincipal;
import com.sun.security.auth.NTSid;
import com.sun.security.auth.NTSidDomainPrincipal;
import com.sun.security.auth.NTSidGroupPrincipal;
import com.sun.security.auth.NTSidPrimaryGroupPrincipal;
import com.sun.security.auth.NTSidUserPrincipal;
import java.io.IOException;
import java.security.Principal;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;
import org.eclipse.riena.internal.communication.factory.hessian.serializer.PrincipalSerializerFactory;
import org.eclipse.riena.internal.communication.hessian.AbstractSerializerFactoryTestCase;
import org.eclipse.riena.security.common.authentication.SimplePrincipal;

public class PrincipalSerializerFactoryTest
extends AbstractSerializerFactoryTestCase {
    public void testPrincipalFail() {
        PrincipalSerializerFactoryTest.assertFalse((boolean)this.isBackAndForthOk((Object)new SimplePrincipal("Chef"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, Principal.class, new AbstractSerializerFactory[0]));
    }

    public void testPrincipal1() {
        PrincipalSerializerFactoryTest.assertTrue((boolean)this.isBackAndForthOk((Object)new SimplePrincipal("Chef"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, null, new AbstractSerializerFactory[]{new PrincipalSerializerFactory()}));
    }

    public void testPrincipal2() {
        PrincipalSerializerFactoryTest.assertTrue((boolean)this.isBackAndForthOk((Object)new SimplePrincipal("Chef"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, Principal.class, new AbstractSerializerFactory[]{new PrincipalSerializerFactory()}));
    }

    public void testPrincipal3() {
        PrincipalSerializerFactoryTest.assertTrue((boolean)this.isBackAndForthOk((Object)new SimplePrincipal("Chef"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, SimplePrincipal.class, new AbstractSerializerFactory[]{new PrincipalSerializerFactory()}));
    }

    public void testNTDomainPrincipal1() {
        PrincipalSerializerFactoryTest.assertTrue((boolean)this.isBackAndForthOk((Object)new NTDomainPrincipal("Boss"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, null, new AbstractSerializerFactory[]{new PrincipalSerializerFactory()}));
    }

    public void testNTSidFail() throws LoginException, IOException {
        PrincipalSerializerFactoryTest.assertFalse((boolean)this.isBackAndForthOk((Object)new NTSid("A"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, null, new AbstractSerializerFactory[0]));
    }

    public void testNTSid1() throws LoginException, IOException {
        PrincipalSerializerFactoryTest.assertTrue((boolean)this.isBackAndForthOk((Object)new NTSid("A"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, null, new AbstractSerializerFactory[]{new PrincipalSerializerFactory()}));
    }

    public void testNTSid2() throws LoginException, IOException {
        PrincipalSerializerFactoryTest.assertTrue((boolean)this.isBackAndForthOk((Object)new NTSid("A"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, Principal.class, new AbstractSerializerFactory[]{new PrincipalSerializerFactory()}));
    }

    public void testNTSid3() throws LoginException, IOException {
        PrincipalSerializerFactoryTest.assertTrue((boolean)this.isBackAndForthOk((Object)new NTSid("A"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, NTSid.class, new AbstractSerializerFactory[]{new PrincipalSerializerFactory()}));
    }

    public void testNTSidDomainPrincipal() throws LoginException, IOException {
        PrincipalSerializerFactoryTest.assertTrue((boolean)this.isBackAndForthOk((Object)new NTSidDomainPrincipal("DAE"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, null, new AbstractSerializerFactory[]{new PrincipalSerializerFactory()}));
    }

    public void testNTSidGroupPrincipal() throws LoginException, IOException {
        PrincipalSerializerFactoryTest.assertTrue((boolean)this.isBackAndForthOk((Object)new NTSidGroupPrincipal("DAE"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, null, new AbstractSerializerFactory[]{new PrincipalSerializerFactory()}));
    }

    public void testNTSidPrimaryGroupPrincipal() throws LoginException, IOException {
        PrincipalSerializerFactoryTest.assertTrue((boolean)this.isBackAndForthOk((Object)new NTSidPrimaryGroupPrincipal("DAE"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, null, new AbstractSerializerFactory[]{new PrincipalSerializerFactory()}));
    }

    public void testNTSidUserPrincipalReturnPrincipal() throws LoginException, IOException {
        PrincipalSerializerFactoryTest.assertTrue((boolean)this.isBackAndForthOk((Object)new NTSidUserPrincipal("DAE"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, Principal.class, new AbstractSerializerFactory[]{new PrincipalSerializerFactory()}));
    }

    public void testNTSidUserPrincipal() throws LoginException, IOException {
        PrincipalSerializerFactoryTest.assertTrue((boolean)this.isBackAndForthOk((Object)new NTSidUserPrincipal("DAE"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, null, new AbstractSerializerFactory[]{new PrincipalSerializerFactory()}));
    }

    public void testKerberosPrincipalFailsBecauseTheGenericPrincipalSerializerFactoryCanNotHandleIt() throws LoginException, IOException {
        PrincipalSerializerFactoryTest.assertFalse((boolean)this.isBackAndForthOk((Object)new KerberosPrincipal("duke@FOO.COM", 1), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, null, new AbstractSerializerFactory[]{new PrincipalSerializerFactory()}));
    }

    public void testX500PrincipalFailsBecauseTheGenericPrincipalSerializerFactoryCanNotHandleIt() throws LoginException, IOException {
        PrincipalSerializerFactoryTest.assertFalse((boolean)this.isBackAndForthOk((Object)new X500Principal("cn=hans"), AbstractSerializerFactoryTestCase.HessianSerializerVersion.Two, null, new AbstractSerializerFactory[]{new PrincipalSerializerFactory()}));
    }
}

