/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractRidgetTestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.FTClickListener;
import org.eclipse.riena.internal.ui.swt.test.UITestHelper;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IClickableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.ClickEvent;
import org.eclipse.riena.ui.ridgets.listener.FocusEvent;
import org.eclipse.riena.ui.ridgets.listener.IClickListener;
import org.eclipse.riena.ui.ridgets.listener.IFocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractSWTRidgetTest
extends AbstractRidgetTestCase {
    protected abstract Widget createWidget(Composite var1);

    protected Widget getWidget() {
        return (Widget)super.getWidget();
    }

    public void testGetToolTip() {
        if (!this.isWidgetControl()) {
            return;
        }
        this.getRidget().setUIControl(null);
        AbstractSWTRidgetTest.assertEquals((String)("Fails for " + this.getRidget()), null, (String)this.getRidget().getToolTipText());
        this.getRidget().setToolTipText("foo");
        AbstractSWTRidgetTest.assertEquals((String)("Fails for " + this.getRidget()), (String)"foo", (String)this.getRidget().getToolTipText());
        Control aControl = (Control)this.getWidget();
        aControl.setToolTipText(null);
        this.getRidget().setUIControl((Object)aControl);
        AbstractSWTRidgetTest.assertEquals((String)("Fails for " + this.getRidget()), (String)"foo", (String)this.getRidget().getToolTipText());
        AbstractSWTRidgetTest.assertEquals((String)("Fails for " + this.getRidget()), (String)"foo", (String)((Control)this.getRidget().getUIControl()).getToolTipText());
    }

    public void testGetFocusable() {
        if (!this.isWidgetControl()) {
            return;
        }
        IRidget aRidget = this.getRidget();
        AbstractSWTRidgetTest.assertTrue((String)("Fails for " + aRidget), (boolean)aRidget.isFocusable());
        aRidget.setFocusable(false);
        AbstractSWTRidgetTest.assertFalse((String)("Fails for " + aRidget), (boolean)aRidget.isFocusable());
        aRidget.setFocusable(true);
        AbstractSWTRidgetTest.assertTrue((String)("Fails for " + aRidget), (boolean)aRidget.isFocusable());
    }

    public void testSetFocusable() {
        if (!this.isWidgetControl()) {
            return;
        }
        IRidget aRidget = this.getRidget();
        Control aControl = (Control)this.getWidget();
        this.getOtherControl().moveAbove(aControl);
        aControl.setFocus();
        if (aControl.isFocusControl()) {
            aRidget.setFocusable(false);
            this.getOtherControl().setFocus();
            AbstractSWTRidgetTest.assertTrue((String)("Fails for " + this.getOtherControl()), (boolean)this.getOtherControl().isFocusControl());
            UITestHelper.sendString((Display)this.getOtherControl().getDisplay(), (String)"\t");
            AbstractSWTRidgetTest.assertFalse((String)("Fails for " + aControl), (boolean)aControl.isFocusControl());
            aRidget.setFocusable(true);
            this.getOtherControl().setFocus();
            UITestHelper.sendString((Display)this.getOtherControl().getDisplay(), (String)"\t");
            AbstractSWTRidgetTest.assertTrue((String)("Fails for " + aControl), (boolean)aControl.isFocusControl());
        }
    }

    public void testRequestFocus() throws Exception {
        if (!this.isWidgetControl()) {
            return;
        }
        Control aControl = (Control)this.getWidget();
        aControl.setFocus();
        if (aControl.isFocusControl()) {
            AbstractSWTRidgetTest.assertTrue((String)("Fails for " + this.getOtherControl()), (boolean)this.getOtherControl().setFocus());
            AbstractSWTRidgetTest.assertFalse((String)("Fails for " + aControl), (boolean)aControl.isFocusControl());
            AbstractSWTRidgetTest.assertFalse((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().hasFocus());
            final ArrayList focusGainedEvents = new ArrayList();
            final ArrayList focusLostEvents = new ArrayList();
            IFocusListener focusListener = new IFocusListener(){

                public void focusGained(FocusEvent event) {
                    focusGainedEvents.add(event);
                }

                public void focusLost(FocusEvent event) {
                    focusLostEvents.add(event);
                }
            };
            this.getRidget().addFocusListener(focusListener);
            this.getRidget().requestFocus();
            AbstractSWTRidgetTest.assertTrue((String)("Fails for " + aControl), (boolean)aControl.isFocusControl());
            AbstractSWTRidgetTest.assertTrue((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().hasFocus());
            AbstractSWTRidgetTest.assertEquals((String)("Fails for " + this.getRidget()), (int)1, (int)focusGainedEvents.size());
            AbstractSWTRidgetTest.assertEquals((String)("Fails for " + this.getRidget()), (Object)this.getRidget(), (Object)((FocusEvent)focusGainedEvents.get(0)).getNewFocusOwner());
            AbstractSWTRidgetTest.assertEquals((String)("Fails for " + this.getRidget()), (int)0, (int)focusLostEvents.size());
            AbstractSWTRidgetTest.assertTrue((String)("Fails for " + this.getOtherControl()), (boolean)this.getOtherControl().setFocus());
            AbstractSWTRidgetTest.assertFalse((String)("Fails for " + aControl), (boolean)aControl.isFocusControl());
            AbstractSWTRidgetTest.assertFalse((String)("Fails for " + this.getRidget()), (boolean)this.getRidget().hasFocus());
            AbstractSWTRidgetTest.assertEquals((String)("Fails for " + this.getRidget()), (int)1, (int)focusGainedEvents.size());
            AbstractSWTRidgetTest.assertEquals((String)("Fails for " + this.getRidget()), (int)1, (int)focusLostEvents.size());
            AbstractSWTRidgetTest.assertEquals((String)("Fails for " + this.getRidget()), (Object)this.getRidget(), (Object)((FocusEvent)focusLostEvents.get(0)).getOldFocusOwner());
            this.getRidget().removeFocusListener(focusListener);
            this.getRidget().requestFocus();
            AbstractSWTRidgetTest.assertTrue((String)("Fails for " + this.getOtherControl()), (boolean)this.getOtherControl().setFocus());
            AbstractSWTRidgetTest.assertEquals((String)("Fails for " + this.getRidget()), (int)1, (int)focusGainedEvents.size());
            AbstractSWTRidgetTest.assertEquals((String)("Fails for " + this.getRidget()), (int)1, (int)focusLostEvents.size());
        }
    }

    public void testBug257484() {
        Widget theWidget = this.getWidget();
        if (!(theWidget instanceof Control)) {
            return;
        }
        IRidget theRidget = this.getRidget();
        Control control = (Control)theWidget;
        AbstractSWTRidgetTest.assertTrue((String)("Fails for " + theRidget), (boolean)theRidget.isVisible());
        AbstractSWTRidgetTest.assertTrue((String)("Fails for " + control), (boolean)control.isVisible());
        theRidget.setVisible(false);
        AbstractSWTRidgetTest.assertFalse((String)("Fails for " + theRidget), (boolean)theRidget.isVisible());
        AbstractSWTRidgetTest.assertFalse((String)("Fails for " + control), (boolean)control.isVisible());
        theRidget.setVisible(true);
        AbstractSWTRidgetTest.assertTrue((String)("Fails for " + theRidget), (boolean)theRidget.isVisible());
        AbstractSWTRidgetTest.assertTrue((String)("Fails for " + control), (boolean)control.isVisible());
        control.setVisible(false);
        AbstractSWTRidgetTest.assertFalse((String)("Fails for " + theRidget), (boolean)theRidget.isVisible());
        theRidget.setUIControl(null);
        AbstractSWTRidgetTest.assertFalse((String)("Fails for " + theRidget), (boolean)theRidget.isVisible());
        theRidget.setUIControl((Object)control);
        control.setVisible(true);
        AbstractSWTRidgetTest.assertTrue((String)("Fails for " + theRidget), (boolean)theRidget.isVisible());
        theRidget.setUIControl(null);
        AbstractSWTRidgetTest.assertTrue((String)("Fails for " + theRidget), (boolean)theRidget.isVisible());
        theRidget.setUIControl((Object)control);
        Composite parent = control.getParent();
        if (parent != null) {
            parent.setVisible(false);
            AbstractSWTRidgetTest.assertFalse((String)("Fails for " + theRidget), (boolean)theRidget.isVisible());
            theRidget.setUIControl(null);
            parent.setVisible(true);
            AbstractSWTRidgetTest.assertFalse((String)("Fails for " + theRidget), (boolean)theRidget.isVisible());
        }
    }

    public void testHideAndUnhideMarkers() {
        if (!(this.getRidget() instanceof IBasicMarkableRidget)) {
            return;
        }
        IBasicMarkableRidget ridget = (IBasicMarkableRidget)this.getRidget();
        AbstractSWTRidgetTest.assertEquals((int)0, (int)ridget.getHiddenMarkerTypes().size());
        ridget.hideMarkersOfType(new Class[]{ErrorMarker.class});
        AbstractSWTRidgetTest.assertEquals((int)1, (int)ridget.getHiddenMarkerTypes().size());
        ridget.hideMarkersOfType(new Class[]{ErrorMarker.class});
        Set hiddenMarkers = ridget.getHiddenMarkerTypes();
        AbstractSWTRidgetTest.assertEquals((int)1, (int)hiddenMarkers.size());
        AbstractSWTRidgetTest.assertTrue((boolean)hiddenMarkers.contains(ErrorMarker.class));
        hiddenMarkers = ridget.hideMarkersOfType(new Class[]{MandatoryMarker.class});
        AbstractSWTRidgetTest.assertEquals((int)2, (int)ridget.getHiddenMarkerTypes().size());
        AbstractSWTRidgetTest.assertTrue((boolean)hiddenMarkers.contains(ErrorMarker.class));
        AbstractSWTRidgetTest.assertTrue((boolean)hiddenMarkers.contains(MandatoryMarker.class));
        hiddenMarkers = ridget.showMarkersOfType(new Class[]{ErrorMarker.class});
        AbstractSWTRidgetTest.assertEquals((int)1, (int)ridget.getHiddenMarkerTypes().size());
        AbstractSWTRidgetTest.assertTrue((boolean)hiddenMarkers.contains(MandatoryMarker.class));
        ridget.showMarkersOfType(new Class[]{MandatoryMarker.class});
        AbstractSWTRidgetTest.assertEquals((int)0, (int)ridget.getHiddenMarkerTypes().size());
    }

    public void testAddClickListener() {
        Widget control;
        if (!(this.getRidget() instanceof IClickableRidget)) {
            return;
        }
        IClickableRidget ridget = (IClickableRidget)this.getRidget();
        try {
            ridget.addClickListener(null);
            AbstractSWTRidgetTest.fail();
        }
        catch (RuntimeException runtimeException) {
            this.ok();
        }
        FTClickListener listener1 = new FTClickListener();
        ridget.addClickListener((IClickListener)listener1);
        FTClickListener listener2 = new FTClickListener();
        ridget.addClickListener((IClickListener)listener2);
        ridget.addClickListener((IClickListener)listener2);
        Event mdEvent = new Event();
        mdEvent.widget = control = this.getWidget();
        mdEvent.type = 3;
        mdEvent.button = 2;
        control.notifyListeners(3, mdEvent);
        AbstractSWTRidgetTest.assertEquals((int)0, (int)listener1.getCount());
        AbstractSWTRidgetTest.assertEquals((int)0, (int)listener2.getCount());
        mdEvent.type = 4;
        control.notifyListeners(4, mdEvent);
        AbstractSWTRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        AbstractSWTRidgetTest.assertEquals((int)1, (int)listener2.getCount());
        ClickEvent event = listener2.getEvent();
        AbstractSWTRidgetTest.assertEquals((Object)ridget, (Object)event.getSource());
        AbstractSWTRidgetTest.assertEquals((int)2, (int)event.getButton());
        AbstractSWTRidgetTest.assertEquals((int)-1, (int)event.getColumnIndex());
        AbstractSWTRidgetTest.assertNull((Object)event.getRow());
        ridget.removeClickListener((IClickListener)listener1);
        mdEvent.type = 3;
        control.notifyListeners(3, mdEvent);
        mdEvent.type = 4;
        control.notifyListeners(4, mdEvent);
        AbstractSWTRidgetTest.assertEquals((int)1, (int)listener1.getCount());
        mdEvent = new Event();
        mdEvent.widget = control;
        mdEvent.type = 3;
        mdEvent.button = 1;
        control.notifyListeners(3, mdEvent);
        AbstractSWTRidgetTest.assertEquals((int)2, (int)listener2.getCount());
        mdEvent.type = 4;
        control.notifyListeners(4, mdEvent);
        AbstractSWTRidgetTest.assertEquals((int)3, (int)listener2.getCount());
        mdEvent = new Event();
        mdEvent.widget = control;
        mdEvent.type = 3;
        mdEvent.button = 1;
        control.notifyListeners(3, mdEvent);
        AbstractSWTRidgetTest.assertEquals((int)3, (int)listener2.getCount());
        mdEvent.type = 4;
        mdEvent.button = 2;
        control.notifyListeners(4, mdEvent);
        AbstractSWTRidgetTest.assertEquals((int)3, (int)listener2.getCount());
        this.getRidget().setEnabled(false);
        mdEvent = new Event();
        mdEvent.widget = control;
        mdEvent.type = 3;
        mdEvent.button = 1;
        control.notifyListeners(3, mdEvent);
        AbstractSWTRidgetTest.assertEquals((int)3, (int)listener2.getCount());
        mdEvent.type = 4;
        control.notifyListeners(4, mdEvent);
        AbstractSWTRidgetTest.assertEquals((int)3, (int)listener2.getCount());
    }
}

