/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.internal.core.test.RienaTestCase;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.IRidgetContentFilterHolder;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSelectableRidget;

@NonUITestCase
public class AbstractSelectableRidgetTest
extends RienaTestCase {
    private MySelectableRidget ridget;

    protected void setUp() throws Exception {
        super.setUp();
        Realm.runWithDefault((Realm)new AlwaysCurrent(), (Runnable)new Runnable(){

            public void run() {
                AbstractSelectableRidgetTest.this.ridget = new MySelectableRidget();
            }
        });
    }

    public void testHasSelection() throws Exception {
        AbstractSelectableRidgetTest.assertFalse((boolean)this.ridget.hasSelection());
        this.ridget.getSingleSelectionObservable().setValue(PersonFactory.createPersonList().get(0));
        AbstractSelectableRidgetTest.assertTrue((boolean)this.ridget.hasSelection());
    }

    public void testGetSingleSelection() throws Exception {
        AbstractSelectableRidgetTest.assertNull((Object)this.ridget.getSingleSelection());
        Person value = (Person)PersonFactory.createPersonList().get(0);
        this.ridget.getSingleSelectionObservable().setValue((Object)value);
        AbstractSelectableRidgetTest.assertSame((Object)value, (Object)this.ridget.getSingleSelection());
        this.ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        AbstractSelectableRidgetTest.assertNull((Object)this.ridget.getSingleSelection());
    }

    public void testGeMultiSelection() throws Exception {
        this.ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        AbstractSelectableRidgetTest.assertNull((Object)this.ridget.getMultiSelection());
        List<Person> value = Arrays.asList((Person)PersonFactory.createPersonList().get(0), (Person)PersonFactory.createPersonList().get(1));
        this.ridget.getMultiSelectionObservable().addAll(value);
        AbstractSelectableRidgetTest.assertEquals((int)2, (int)this.ridget.getMultiSelection().size());
        this.ridget.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        AbstractSelectableRidgetTest.assertNull((Object)this.ridget.getMultiSelection());
        this.ridget.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        this.ridget.getMultiSelectionObservable().clear();
        AbstractSelectableRidgetTest.assertNull((Object)this.ridget.getMultiSelection());
    }

    class AlwaysCurrent
    extends Realm {
        AlwaysCurrent() {
        }

        public boolean isCurrent() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MySelectableRidget
    extends AbstractSelectableRidget {
        MySelectableRidget() {
        }

        protected List<?> getRowObservables() {
            return null;
        }

        protected void checkUIControl(Object uiControl) {
        }

        protected void bindUIControl() {
        }

        public boolean isDisableMandatoryMarker() {
            return false;
        }

        protected IRidgetContentFilterHolder<?> getFilterHolder() {
            return null;
        }
    }
}

