/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.easymock.EasyMock;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractRidgetSharedTestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IControlDecoration;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class MarkerViewSharedTest
extends AbstractRidgetSharedTestCase {
    private final IControlDecoration[] decorationMocks = new IControlDecoration[2];
    private int mockIndex = 0;

    protected Control createWidget(Composite parent) {
        return new Text(parent, 0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.mockIndex = 0;
    }

    protected IRidget createRidget() {
        return new TextRidget(){

            protected AbstractMarkerSupport createMarkerSupport() {
                return new MarkerSupport((IBasicMarkableRidget)this, this.propertyChangeSupport){

                    protected IControlDecoration createErrorDecoration(Control control) {
                        ((MarkerViewSharedTest)(this).MarkerViewSharedTest.this).decorationMocks[((MarkerViewSharedTest)(this).MarkerViewSharedTest.this).mockIndex] = (IControlDecoration)EasyMock.createNiceMock(IControlDecoration.class);
                        IControlDecoration[] iControlDecorationArray = MarkerViewSharedTest.this.decorationMocks;
                        MarkerViewSharedTest markerViewSharedTest = MarkerViewSharedTest.this;
                        int n = markerViewSharedTest.mockIndex;
                        markerViewSharedTest.mockIndex = n + 1;
                        return iControlDecorationArray[n];
                    }
                };
            }
        };
    }

    protected TextRidget getRidget1() {
        return (TextRidget)super.getRidget1();
    }

    protected TextRidget getRidget2() {
        return (TextRidget)super.getRidget2();
    }

    public void testMandatoryMarker() throws Exception {
        Color bg = this.getWidget().getBackground();
        this.activateRidget1();
        this.getRidget1().setMandatory(true);
        MarkerViewSharedTest.assertFalse((boolean)bg.equals((Object)this.getWidget().getBackground()));
        this.activateRidget2();
        MarkerViewSharedTest.assertFalse((boolean)this.getRidget2().isMandatory());
        MarkerViewSharedTest.assertEquals((Object)bg, (Object)this.getWidget().getBackground());
    }

    public void testErrorMarker() throws Exception {
        this.activateRidget1();
        MarkerViewSharedTest.assertNull((Object)this.decorationMocks[0]);
        this.getRidget1().setErrorMarked(true);
        EasyMock.reset((Object[])new Object[]{this.decorationMocks[0]});
        this.decorationMocks[0].hide();
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.decorationMocks[0]});
        this.activateRidget2();
        EasyMock.verify((Object[])new Object[]{this.decorationMocks[0]});
        EasyMock.reset((Object[])new Object[]{this.decorationMocks[0]});
        this.decorationMocks[0].show();
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.decorationMocks[0]});
        this.activateRidget1();
        EasyMock.verify((Object[])new Object[]{this.decorationMocks[0]});
    }

    public void testOutputMarker() throws Exception {
        Color bg = this.getWidget().getBackground();
        this.activateRidget1();
        this.getRidget1().setOutputOnly(true);
        MarkerViewSharedTest.assertFalse((boolean)bg.equals((Object)this.getWidget().getBackground()));
        this.activateRidget2();
        MarkerViewSharedTest.assertFalse((boolean)this.getRidget2().isMandatory());
        MarkerViewSharedTest.assertEquals((Object)bg, (Object)this.getWidget().getBackground());
    }

    public void testVisibleMarker() throws Exception {
        this.activateRidget1();
        this.getRidget1().setVisible(false);
        MarkerViewSharedTest.assertFalse((boolean)this.getWidget().isVisible());
        this.activateRidget2();
        MarkerViewSharedTest.assertTrue((boolean)this.getWidget().isVisible());
    }

    public void testDisabledMarker() throws Exception {
        this.activateRidget1();
        this.getRidget1().setEnabled(false);
        MarkerViewSharedTest.assertFalse((boolean)this.getWidget().isEnabled());
        this.activateRidget2();
        MarkerViewSharedTest.assertTrue((boolean)this.getWidget().isEnabled());
    }
}

