/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.TreeRidget;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.swt.views.SWTModuleController;
import org.eclipse.riena.ui.ridgets.ITreeRidget;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonUITestCase
public class SWTModuleControllerTest
extends TestCase {
    private TestSWTModuleController controller;
    private IModuleNode moduleNode;

    protected void setUp() throws Exception {
        super.setUp();
        this.moduleNode = new ModuleNode();
        this.controller = new TestSWTModuleController(this.moduleNode);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.moduleNode.dispose();
        this.moduleNode = null;
        this.controller = null;
    }

    public void testCollapseSibling() {
        SubModuleNode sm0 = new SubModuleNode(new NavigationNodeId("sm0"));
        this.moduleNode.addChild((INavigationNode)sm0);
        SubModuleNode sm1 = new SubModuleNode(new NavigationNodeId("sm1"));
        this.moduleNode.addChild((INavigationNode)sm1);
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("sm2"));
        this.moduleNode.addChild((INavigationNode)sm2);
        SubModuleNode sm3 = new SubModuleNode(new NavigationNodeId("sm3"));
        this.moduleNode.addChild((INavigationNode)sm3);
        SubModuleNode sm11 = new SubModuleNode(new NavigationNodeId("sm11"));
        sm1.addChild((INavigationNode)sm11);
        SubModuleNode sm12 = new SubModuleNode(new NavigationNodeId("sm12"));
        sm1.addChild((INavigationNode)sm12);
        SubModuleNode sm21 = new SubModuleNode(new NavigationNodeId("sm21"));
        sm2.addChild((INavigationNode)sm21);
        SubModuleNode sm22 = new SubModuleNode(new NavigationNodeId("sm22"));
        sm2.addChild((INavigationNode)sm22);
        SubModuleNode sm31 = new SubModuleNode(new NavigationNodeId("sm31"));
        sm3.addChild((INavigationNode)sm31);
        SubModuleNode sm32 = new SubModuleNode(new NavigationNodeId("sm32"));
        sm3.addChild((INavigationNode)sm32);
        SubModuleNode sm111 = new SubModuleNode(new NavigationNodeId("sm111"));
        sm11.addChild((INavigationNode)sm111);
        SubModuleNode sm121 = new SubModuleNode(new NavigationNodeId("sm121"));
        sm12.addChild((INavigationNode)sm121);
        SubModuleNode sm211 = new SubModuleNode(new NavigationNodeId("sm211"));
        sm21.addChild((INavigationNode)sm211);
        SubModuleNode sm221 = new SubModuleNode(new NavigationNodeId("sm221"));
        sm22.addChild((INavigationNode)sm221);
        SubModuleNode sm311 = new SubModuleNode(new NavigationNodeId("sm311"));
        sm31.addChild((INavigationNode)sm311);
        SubModuleNode sm321 = new SubModuleNode(new NavigationNodeId("sm321"));
        sm32.addChild((INavigationNode)sm321);
        this.expandAll((INavigationNode<?>)this.moduleNode, true);
        ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"collapseSibling", (Object[])new Object[]{sm0});
        SWTModuleControllerTest.assertTrue((boolean)sm1.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm11.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm111.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm12.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm121.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm2.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm3.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm21.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm211.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm22.isExpanded());
        this.expandAll((INavigationNode<?>)this.moduleNode, true);
        sm111.setCloseSubTree(true);
        ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"collapseSibling", (Object[])new Object[]{sm0});
        SWTModuleControllerTest.assertTrue((boolean)sm1.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm11.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm111.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm12.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm121.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm2.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm3.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm21.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm211.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm22.isExpanded());
        this.expandAll((INavigationNode<?>)this.moduleNode, true);
        sm1.setCloseSubTree(true);
        ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"collapseSibling", (Object[])new Object[]{sm211});
        SWTModuleControllerTest.assertFalse((boolean)sm1.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm11.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm111.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm12.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm121.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm2.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm3.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm21.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm211.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm22.isExpanded());
        this.expandAll((INavigationNode<?>)this.moduleNode, true);
        sm11.setCloseSubTree(true);
        ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"collapseSibling", (Object[])new Object[]{sm211});
        SWTModuleControllerTest.assertTrue((boolean)sm1.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm11.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm2.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm3.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm31.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm32.isExpanded());
        this.expandAll((INavigationNode<?>)this.moduleNode, false);
        sm221.setExpanded(true);
        sm22.setCloseSubTree(true);
        ReflectionUtils.invokeHidden((Object)((Object)this.controller), (String)"collapseSibling", (Object[])new Object[]{sm0});
        SWTModuleControllerTest.assertFalse((boolean)sm1.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm11.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm111.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm12.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm121.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm22.isExpanded());
        SWTModuleControllerTest.assertTrue((boolean)sm221.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm21.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm211.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm31.isExpanded());
        SWTModuleControllerTest.assertFalse((boolean)sm32.isExpanded());
    }

    public void testExpandNode() {
        SubModuleNode sm0 = new SubModuleNode(new NavigationNodeId("sm0"));
        SubModuleNode sm1 = new SubModuleNode(new NavigationNodeId("sm1"));
        sm1.setExpanded(true);
        sm0.addChild((INavigationNode)sm1);
        SubModuleNode sm2 = new SubModuleNode(new NavigationNodeId("sm2"));
        sm1.addChild((INavigationNode)sm2);
        sm2.setExpanded(true);
        SubModuleNode sm3 = new SubModuleNode(new NavigationNodeId("sm3"));
        sm3.setExpanded(true);
        sm2.addChild((INavigationNode)sm3);
        this.moduleNode.addChild((INavigationNode)sm0);
        this.controller.reset();
        Realm.runWithDefault((Realm)new DefaultRealm(), (Runnable)new Runnable(){

            public void run() {
                SWTModuleControllerTest.this.controller.setTree((ITreeRidget)new TreeRidget());
            }
        });
        sm0.setExpanded(true);
        SWTModuleControllerTest.assertEquals((int)4, (int)this.controller.expandCalledTimes);
    }

    public void testModuleGroupListenerisAddedRemoved() {
        ModuleGroupNode mg = new ModuleGroupNode();
        List listeners = (List)ReflectionUtils.invokeHidden((Object)mg, (String)"getListeners", (Object[])new Object[0]);
        SWTModuleControllerTest.assertTrue((boolean)listeners.isEmpty());
        this.moduleNode.setParent((INavigationNode)mg);
        listeners = (List)ReflectionUtils.invokeHidden((Object)mg, (String)"getListeners", (Object[])new Object[0]);
        SWTModuleControllerTest.assertEquals((int)1, (int)listeners.size());
        this.moduleNode.setParent(null);
        listeners = (List)ReflectionUtils.invokeHidden((Object)mg, (String)"getListeners", (Object[])new Object[0]);
        SWTModuleControllerTest.assertTrue((boolean)listeners.isEmpty());
    }

    private void expandAll(INavigationNode<?> node, boolean expanded) {
        node.setExpanded(expanded);
        for (INavigationNode child : node.getChildren()) {
            this.expandAll(child, expanded);
        }
    }

    private class TestSWTModuleController
    extends SWTModuleController {
        int expandCalledTimes;

        public TestSWTModuleController(IModuleNode node) {
            super(node);
            this.expandCalledTimes = 0;
        }

        void reset() {
            this.expandCalledTimes = 0;
        }

        protected void expandTree(ISubModuleNode source) {
            ++this.expandCalledTimes;
        }
    }
}

