/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.databinding;

import java.util.GregorianCalendar;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.ValueBindingSupport;
import org.eclipse.riena.ui.ridgets.databinding.GregorianCalendarToStringConverter;
import org.eclipse.riena.ui.ridgets.databinding.RidgetUpdateValueStrategy;
import org.eclipse.riena.ui.ridgets.databinding.StringToGregorianCalendarConverter;
import org.eclipse.riena.ui.ridgets.databinding.StringToNumberAllowingNullConverter;

@NonUITestCase
public class RidgetUpdateValueStrategyTest
extends TestCase {
    public void testCreateConverter() throws Exception {
        RidgetUpdateValueStrategy strategy = new RidgetUpdateValueStrategy(new ValueBindingSupport((IObservableValue)EasyMock.createNiceMock(IObservableValue.class)));
        IConverter converter = (IConverter)ReflectionUtils.invokeHidden((Object)strategy, (String)"createConverter", (Object[])new Object[]{String.class, Double.TYPE});
        RidgetUpdateValueStrategyTest.assertTrue((boolean)(converter instanceof StringToNumberAllowingNullConverter));
        converter = (IConverter)ReflectionUtils.invokeHidden((Object)strategy, (String)"createConverter", (Object[])new Object[]{String.class, Float.TYPE});
        RidgetUpdateValueStrategyTest.assertTrue((boolean)(converter instanceof StringToNumberAllowingNullConverter));
        converter = (IConverter)ReflectionUtils.invokeHidden((Object)strategy, (String)"createConverter", (Object[])new Object[]{String.class, Long.TYPE});
        RidgetUpdateValueStrategyTest.assertTrue((boolean)(converter instanceof StringToNumberAllowingNullConverter));
        converter = (IConverter)ReflectionUtils.invokeHidden((Object)strategy, (String)"createConverter", (Object[])new Object[]{String.class, Integer.TYPE});
        RidgetUpdateValueStrategyTest.assertTrue((boolean)(converter instanceof StringToNumberAllowingNullConverter));
        converter = (IConverter)ReflectionUtils.invokeHidden((Object)strategy, (String)"createConverter", (Object[])new Object[]{String.class, GregorianCalendar.class});
        RidgetUpdateValueStrategyTest.assertTrue((boolean)(converter instanceof StringToGregorianCalendarConverter));
        converter = (IConverter)ReflectionUtils.invokeHidden((Object)strategy, (String)"createConverter", (Object[])new Object[]{GregorianCalendar.class, String.class});
        RidgetUpdateValueStrategyTest.assertTrue((boolean)(converter instanceof GregorianCalendarToStringConverter));
        converter = (IConverter)ReflectionUtils.invokeHidden((Object)strategy, (String)"createConverter", (Object[])new Object[]{Integer.class, String.class});
        RidgetUpdateValueStrategyTest.assertTrue((boolean)(converter instanceof NumberToStringConverter));
    }

    public void testConstructors() throws Exception {
        try {
            new RidgetUpdateValueStrategy(null);
            RidgetUpdateValueStrategyTest.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {}
        try {
            new RidgetUpdateValueStrategy(null, UpdateValueStrategy.POLICY_UPDATE);
            RidgetUpdateValueStrategyTest.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {}
        try {
            new RidgetUpdateValueStrategy(null, true, UpdateValueStrategy.POLICY_UPDATE);
            RidgetUpdateValueStrategyTest.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testValidateAfterSetWithSetError() throws Exception {
        RidgetUpdateValueStrategy strategy = new RidgetUpdateValueStrategy(new ValueBindingSupport((IObservableValue)EasyMock.createNiceMock(IObservableValue.class)));
        Status setStatus = new Status(4, "plugin.id", "some message");
        RidgetUpdateValueStrategyTest.assertSame((Object)setStatus, (Object)ReflectionUtils.invokeHidden((Object)strategy, (String)"validateAfterSet", (Object[])new Object[]{setStatus}));
        strategy.setAfterSetValidator((IValidator)EasyMock.createMock(IValidator.class));
        RidgetUpdateValueStrategyTest.assertSame((Object)setStatus, (Object)ReflectionUtils.invokeHidden((Object)strategy, (String)"validateAfterSet", (Object[])new Object[]{setStatus}));
    }

    public void testValidateAfterSetWithSetOk() throws Exception {
        RidgetUpdateValueStrategy strategy = new RidgetUpdateValueStrategy(new ValueBindingSupport((IObservableValue)EasyMock.createNiceMock(IObservableValue.class)));
        IStatus setStatus = Status.OK_STATUS;
        RidgetUpdateValueStrategyTest.assertSame((Object)setStatus, (Object)ReflectionUtils.invokeHidden((Object)strategy, (String)"validateAfterSet", (Object[])new Object[]{setStatus}));
        Status s1 = new Status(4, "plugin.id", "some message");
        IValidator validator = (IValidator)EasyMock.createMock(IValidator.class);
        EasyMock.expect((Object)validator.validate(EasyMock.anyObject())).andReturn((Object)s1);
        EasyMock.replay((Object[])new Object[]{validator});
        strategy.setAfterSetValidator(validator);
        RidgetUpdateValueStrategyTest.assertSame((Object)s1, (Object)ReflectionUtils.invokeHidden((Object)strategy, (String)"validateAfterSet", (Object[])new Object[]{setStatus}));
        EasyMock.verify((Object[])new Object[]{validator});
    }
}

