/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.facades.internal;

import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.core.test.collect.UITestCase;
import org.eclipse.riena.ui.swt.GrabCorner;
import org.eclipse.riena.ui.swt.facades.internal.GrabCornerListenerWithTracker;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class GrabCornerListenerWithTrackerTest
extends TestCase {
    private Shell shell;
    private Tracker tracker;
    private GrabCornerListenerWithTracker grabCornerListener;
    private GrabCorner corner;

    protected void setUp() throws Exception {
        this.shell = new Shell();
        this.corner = new GrabCorner((Composite)this.shell, 0);
        this.grabCornerListener = new GrabCornerListenerWithTracker((Control)this.corner);
        this.tracker = new Tracker((Composite)this.shell, 132112);
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.corner);
        this.grabCornerListener = null;
        SwtUtilities.dispose((Widget)this.tracker);
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testGetTrackerBounds() {
        Rectangle rec1 = new Rectangle(1, 2, 3, 4);
        Rectangle rec2 = new Rectangle(10, 20, 30, 40);
        Rectangle[] recs = new Rectangle[]{rec1, rec2};
        this.tracker.setRectangles(recs);
        Rectangle bounds = (Rectangle)ReflectionUtils.invokeHidden((Object)this.grabCornerListener, (String)"getTrackerBounds", (Object[])new Object[]{this.tracker});
        GrabCornerListenerWithTrackerTest.assertEquals((Object)rec1, (Object)bounds);
        recs = new Rectangle[]{};
        this.tracker.setRectangles(recs);
        bounds = (Rectangle)ReflectionUtils.invokeHidden((Object)this.grabCornerListener, (String)"getTrackerBounds", (Object[])new Object[]{this.tracker});
        GrabCornerListenerWithTrackerTest.assertNull((Object)bounds);
    }

    public void testSetMinimumBounds() {
        Point miniSize = new Point(200, 300);
        this.shell.setMinimumSize(miniSize);
        Rectangle rec1 = new Rectangle(1, 2, 3, 4);
        Rectangle[] recs = new Rectangle[]{rec1};
        this.tracker.setRectangles(recs);
        ReflectionUtils.invokeHidden((Object)this.grabCornerListener, (String)"setMinimumBounds", (Object[])new Object[]{this.tracker});
        Rectangle bounds = (Rectangle)ReflectionUtils.invokeHidden((Object)this.grabCornerListener, (String)"getTrackerBounds", (Object[])new Object[]{this.tracker});
        GrabCornerListenerWithTrackerTest.assertEquals((int)miniSize.x, (int)bounds.width);
        GrabCornerListenerWithTrackerTest.assertEquals((int)miniSize.y, (int)bounds.height);
        rec1 = new Rectangle(1, 2, 300, 400);
        recs = new Rectangle[]{rec1};
        this.tracker.setRectangles(recs);
        ReflectionUtils.invokeHidden((Object)this.grabCornerListener, (String)"setMinimumBounds", (Object[])new Object[]{this.tracker});
        bounds = (Rectangle)ReflectionUtils.invokeHidden((Object)this.grabCornerListener, (String)"getTrackerBounds", (Object[])new Object[]{this.tracker});
        GrabCornerListenerWithTrackerTest.assertEquals((int)rec1.width, (int)bounds.width);
        GrabCornerListenerWithTrackerTest.assertEquals((int)rec1.height, (int)bounds.height);
        rec1 = new Rectangle(1, 2, 30, 400);
        recs = new Rectangle[]{rec1};
        this.tracker.setRectangles(recs);
        ReflectionUtils.invokeHidden((Object)this.grabCornerListener, (String)"setMinimumBounds", (Object[])new Object[]{this.tracker});
        bounds = (Rectangle)ReflectionUtils.invokeHidden((Object)this.grabCornerListener, (String)"getTrackerBounds", (Object[])new Object[]{this.tracker});
        GrabCornerListenerWithTrackerTest.assertEquals((int)miniSize.x, (int)bounds.width);
        GrabCornerListenerWithTrackerTest.assertEquals((int)rec1.height, (int)bounds.height);
        rec1 = new Rectangle(1, 2, 300, 40);
        recs = new Rectangle[]{rec1};
        this.tracker.setRectangles(recs);
        ReflectionUtils.invokeHidden((Object)this.grabCornerListener, (String)"setMinimumBounds", (Object[])new Object[]{this.tracker});
        bounds = (Rectangle)ReflectionUtils.invokeHidden((Object)this.grabCornerListener, (String)"getTrackerBounds", (Object[])new Object[]{this.tracker});
        GrabCornerListenerWithTrackerTest.assertEquals((int)rec1.width, (int)bounds.width);
        GrabCornerListenerWithTrackerTest.assertEquals((int)miniSize.y, (int)bounds.height);
    }
}

