/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.core.internal.databinding.property.value.SimplePropertyObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.databinding.swt.ButtonSelectionProperty;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractToggleButtonRidget;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class ToggleButtonRidget
extends AbstractToggleButtonRidget {
    private static final String TOGGLE_BUTTON_RIDGET = "tbr";
    private IObservableValue selectionObservable;

    protected void bindUIControl() {
        super.bindUIControl();
        Button control = this.getUIControl();
        if (control != null) {
            control.setData(TOGGLE_BUTTON_RIDGET, (Object)this);
            this.updateMandatoryMarkers();
        }
    }

    protected void checkUIControl(Object uiControl) {
        Button button;
        this.checkType(uiControl, Button.class);
        if (!(uiControl == null || SwtUtilities.hasStyle((Widget)(button = (Button)uiControl), (int)32) || SwtUtilities.hasStyle((Widget)button, (int)16) || SwtUtilities.hasStyle((Widget)button, (int)2))) {
            throw new BindingException("Button must be a check box, a radio button or a toggle button");
        }
    }

    public Button getUIControl() {
        return (Button)super.getUIControl();
    }

    protected IObservableValue getUIControlSelectionObservable() {
        if (this.selectionObservable == null) {
            this.selectionObservable = new SelectionObservableWithOutputOnly(this.getUIControl());
        }
        return this.selectionObservable;
    }

    public boolean isDisableMandatoryMarker() {
        boolean isSelected = this.isSelected();
        if (!isSelected && this.getUIControl() != null) {
            isSelected = this.siblingsAreSelected();
        }
        return isSelected;
    }

    protected void unbindUIControl() {
        if (this.selectionObservable != null) {
            this.selectionObservable.dispose();
            this.selectionObservable = null;
        }
        super.unbindUIControl();
    }

    protected void setUIControlSelection(boolean selected) {
        this.getUIControl().setSelection(selected);
    }

    protected String getUIControlText() {
        return this.getUIControl().getText();
    }

    protected void setUIControlText(String text) {
        this.getUIControl().setText(text);
    }

    protected void setUIControlImage(Image image) {
        this.getUIControl().setImage(image);
    }

    public void setSelected(boolean selected) {
        Button selectedUIControl = this.getUIControl();
        if (!this.isSelected() && selected && this.isRadioSingleSelection((Control)selectedUIControl)) {
            Button[] buttonArray = this.getSiblings(selectedUIControl);
            int n = buttonArray.length;
            int n2 = 0;
            while (n2 < n) {
                Button sibling = buttonArray[n2];
                String bindingId = SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)sibling);
                IToggleButtonRidget siblingRidget = (IToggleButtonRidget)this.getController().getRidget(IToggleButtonRidget.class, bindingId);
                siblingRidget.setSelected(false);
                ++n2;
            }
        }
        super.setSelected(selected);
    }

    protected void updateMandatoryMarkers() {
        boolean disableMarker = this.isDisableMandatoryMarker();
        Button control = this.getUIControl();
        if (control != null) {
            Button[] siblings;
            Button[] buttonArray = siblings = this.getSiblings(control);
            int n = siblings.length;
            int n2 = 0;
            while (n2 < n) {
                Button sibling = buttonArray[n2];
                Object ridget = sibling.getData(TOGGLE_BUTTON_RIDGET);
                if (ridget instanceof ToggleButtonRidget) {
                    ((ToggleButtonRidget)((Object)ridget)).disableMandatoryMarkers(disableMarker);
                }
                ++n2;
            }
        }
        this.disableMandatoryMarkers(disableMarker);
    }

    private Button[] getSiblings(Button control) {
        Control[] siblings;
        ArrayList<Button> result = new ArrayList<Button>();
        boolean isCheck = this.isCheck((Control)control);
        boolean isRadio = this.isRadio((Control)control);
        boolean isPush = this.isToggle((Control)control);
        Control[] controlArray = siblings = control.getParent().getChildren();
        int n = siblings.length;
        int n2 = 0;
        while (n2 < n) {
            Control candidate = controlArray[n2];
            if (candidate != control && candidate instanceof Button && (isCheck && this.isCheck(candidate) || isRadio && this.isRadio(candidate) || isPush && this.isToggle(candidate))) {
                result.add((Button)candidate);
            }
            ++n2;
        }
        return result.toArray(new Button[result.size()]);
    }

    private boolean isCheck(Control control) {
        return control != null && (control.getStyle() & 0x20) > 0;
    }

    private boolean isRadio(Control control) {
        return control != null && (control.getStyle() & 0x10) > 0;
    }

    private boolean isRadioSingleSelection(Control control) {
        return this.isRadio(control) && (control.getStyle() & 0x400000) == 0;
    }

    private boolean isToggle(Control control) {
        return control != null && (control.getStyle() & 2) > 0;
    }

    private boolean siblingsAreSelected() {
        boolean result = false;
        Button control = this.getUIControl();
        Button[] siblings = this.getSiblings(control);
        int i = 0;
        while (!result && i < siblings.length) {
            Button sibling = siblings[i];
            if (sibling.isEnabled()) {
                result = sibling.getSelection();
            }
            ++i;
        }
        return result;
    }

    private final class SelectionObservableWithOutputOnly
    extends SimplePropertyObservableValue
    implements SelectionListener {
        private final Button button;

        public SelectionObservableWithOutputOnly(Button source) {
            super(ToggleButtonRidget.this.getValueBindingSupport().getContext().getValidationRealm(), (Object)source, (SimpleValueProperty)new ButtonSelectionProperty());
            Assert.isNotNull((Object)source);
            this.button = source;
            this.button.addSelectionListener((SelectionListener)this);
        }

        protected Object doGetValue() {
            return ToggleButtonRidget.this.isOutputOnly() ? Boolean.valueOf(ToggleButtonRidget.this.isSelected()) : super.doGetValue();
        }

        public void widgetSelected(SelectionEvent e) {
            if (ToggleButtonRidget.this.isOutputOnly()) {
                this.button.setSelection(ToggleButtonRidget.this.isSelected());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public synchronized void dispose() {
            if (!this.button.isDisposed()) {
                this.button.removeSelectionListener((SelectionListener)this);
            }
        }
    }
}

