/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt.uiprocess;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.core.uiprocess.IProgressVisualizer;
import org.eclipse.riena.ui.swt.uiprocess.ProcessState;
import org.eclipse.riena.ui.swt.uiprocess.ProgressInfoDataObject;

public class ProcessDetail {
    private static volatile int keyDec = 0;
    private static final int PENDING_MAXWORK = 100;
    private static final int PENDING_STEP = 10;
    private final IProgressVisualizer visualizer;
    private ProcessState state = ProcessState.PENDING;
    private int pendingProgress = 0;
    private int progress = 0;
    private final long startupTS;
    private final int key = ProcessDetail.nextKey();

    private static int nextKey() {
        return keyDec++;
    }

    public ProcessDetail(long startupTS, IProgressVisualizer visualizer) {
        this.startupTS = startupTS;
        this.visualizer = visualizer;
    }

    public IProgressVisualizer getVisualizer() {
        return this.visualizer;
    }

    public long getStartupTS() {
        return this.startupTS;
    }

    public boolean isPending() {
        return ProcessState.PENDING.equals((Object)this.state) || this.getVisualizer().getProcessInfo().getMaxProgress() < 0;
    }

    public void triggerPending() {
        Assert.isTrue((boolean)this.isPending(), (String)":-( triggerPending called in working state");
        this.pendingProgress = this.pendingProgress <= 100 ? (this.pendingProgress += 10) : 0;
    }

    public int getMaxValue() {
        return this.isPending() ? 100 : this.getVisualizer().getProcessInfo().getMaxProgress();
    }

    public int getValue() {
        return this.isPending() ? this.pendingProgress : this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setState(ProcessState state) {
        this.state = state;
    }

    public ProcessState getState() {
        return this.state;
    }

    private int calculatePercentage() {
        return ProcessDetail.calculatePercentage(this.getValue(), this.getMaxValue());
    }

    private static int calculatePercentage(int ivalue, int imaxValue) {
        double dmaxValue = imaxValue;
        double dValue = ivalue;
        return (int)(dValue / dmaxValue * 100.0);
    }

    public ProgressInfoDataObject toPido() {
        return new ProgressInfoDataObject(this.key, this.getMaxValue(), this.calculatePercentage(), this.getVisualizer().getProcessInfo().getTitle(), this.state);
    }
}

