/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.riena.internal.ui.ridgets.swt.OutputAwareValidator;
import org.eclipse.riena.ui.common.ISortableByColumn;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.IListRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.ClickEvent;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSelectableIndexedRidget;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.ridgets.swt.SortableComparator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListRidget
extends AbstractSelectableIndexedRidget
implements IListRidget {
    protected SelectionListener selectionTypeEnforcer;
    private DataBindingContext dbc;
    private Binding viewerSSB;
    private Binding viewerMSB;
    private Class<?> rowBeanClass;
    private IObservableList modelObservables;
    private IObservableList viewerObservables;
    private String renderingMethod;
    private boolean isSortedAscending = true;
    private int sortedColumn = -1;
    private ViewerComparator comparator;

    public AbstractListRidget() {
        this.getSingleSelectionObservable().addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                AbstractListRidget.this.disableMandatoryMarkers(AbstractListRidget.this.hasInput());
            }
        });
        this.getMultiSelectionObservable().addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                AbstractListRidget.this.disableMandatoryMarkers(AbstractListRidget.this.hasInput());
            }
        });
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean isEnabled = (Boolean)evt.getNewValue();
                AbstractListRidget.this.updateEnabled(isEnabled);
            }
        });
        this.addPropertyChangeListener("output", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (AbstractListRidget.this.isOutputOnly()) {
                    AbstractListRidget.this.disposeMultipleSelectionBinding();
                } else {
                    AbstractListRidget.this.createMultipleSelectionBinding();
                }
            }
        });
    }

    public void bindToModel(IObservableList rowValues, Class<? extends Object> rowClass, String columnPropertyName) {
        Assert.isNotNull((Object)columnPropertyName, (String)"columnPropertyName");
        String[] columns = new String[]{columnPropertyName};
        this.bindToModel(rowValues, rowClass, columns, null);
    }

    public void bindToModel(Object listHolder, String listPropertyName, Class<? extends Object> rowClass, String columnPropertyName) {
        Assert.isNotNull((Object)columnPropertyName, (String)"columnPropertyName");
        String[] columns = new String[]{columnPropertyName};
        this.bindToModel(listHolder, listPropertyName, rowClass, columns, null);
    }

    public void bindToModel(Object listHolder, String listPropertyName) {
        this.bindToModel(listHolder, listPropertyName, Object.class, new String[0], null);
    }

    public void bindToModel(IObservableList rowValues, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] columnHeaders) {
        this.unbindUIControl();
        this.rowBeanClass = rowClass;
        this.modelObservables = rowValues;
        this.viewerObservables = null;
        this.renderingMethod = columnPropertyNames.length > 0 ? columnPropertyNames[0] : null;
        this.bindUIControl();
    }

    public void bindToModel(Object listHolder, String listPropertyName, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] columnHeaders) {
        IObservableList rowValues = AbstractSWTWidgetRidget.isBean(rowClass) ? BeansObservables.observeList((Object)listHolder, (String)listPropertyName) : PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        this.bindToModel(rowValues, rowClass, columnPropertyNames, columnHeaders);
    }

    public IObservableList getObservableList() {
        return this.viewerObservables;
    }

    @Override
    public Object getOption(int index) {
        if (this.getRowObservables() == null || index < 0 || index >= this.getOptionCount()) {
            throw new IllegalArgumentException("index: " + index);
        }
        AbstractListViewer viewer = this.getViewer();
        if (viewer != null) {
            return viewer.getElementAt(index);
        }
        return this.getRowObservables().get(index);
    }

    @Override
    public int getSelectionIndex() {
        return this.getUIControl() == null ? -1 : this.getUIControlSelectionIndex();
    }

    @Override
    public int[] getSelectionIndices() {
        return this.getUIControl() == null ? new int[]{} : this.getUIControlSelectionIndices();
    }

    public int getSortedColumn() {
        return this.comparator != null && this.sortedColumn == 0 ? 0 : -1;
    }

    public final boolean hasMoveableColumns() {
        return false;
    }

    @Override
    public int indexOfOption(Object option) {
        if (this.getUIControl() != null) {
            int optionCount = this.getUIControlItemCount();
            int i = 0;
            while (i < optionCount) {
                if (this.getViewer().getElementAt(i).equals(option)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean isColumnSortable(int columnIndex) {
        Assert.isLegal((columnIndex == 0 ? 1 : 0) != 0, (String)"columnIndex out of bounds (must be 0)");
        return this.comparator != null;
    }

    @Override
    public boolean isDisableMandatoryMarker() {
        return this.hasInput();
    }

    public boolean isSortedAscending() {
        return this.isSortedAscending;
    }

    public void refresh(Object node) {
        AbstractListViewer viewer = this.getViewer();
        if (viewer != null) {
            viewer.refresh(node, true);
        }
    }

    public void setColumnFormatter(int columnIndex, IColumnFormatter formatter) {
        throw new UnsupportedOperationException();
    }

    public final void setColumnSortable(int columnIndex, boolean sortable) {
        throw new UnsupportedOperationException();
    }

    public void clearColumnFormatters() {
        throw new UnsupportedOperationException();
    }

    public final void setColumnWidths(Object[] widths) {
        throw new UnsupportedOperationException();
    }

    public void setComparator(int columnIndex, Comparator<?> comparator) {
        Assert.isLegal((columnIndex == 0 ? 1 : 0) != 0, (String)"columnIndex out of bounds (must be 0)");
        if (comparator != null) {
            SortableComparator sortableComparator = new SortableComparator((ISortableByColumn)this, comparator);
            this.comparator = new ViewerComparator(sortableComparator);
        } else {
            this.comparator = null;
        }
        this.updateComparator();
    }

    public final void setMoveableColumns(boolean moveableColumns) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void setSortedAscending(boolean ascending) {
        if (ascending != this.isSortedAscending) {
            boolean oldSortedAscending = this.isSortedAscending;
            this.isSortedAscending = ascending;
            if (this.hasViewer()) {
                this.refreshViewer();
            }
            this.firePropertyChange("sortAscending", oldSortedAscending, this.isSortedAscending);
        }
    }

    public final void setSortedColumn(int columnIndex) {
        String msg = "columnIndex out of range (-1 - 0): " + columnIndex;
        Assert.isLegal((columnIndex >= -1 && columnIndex <= 0 ? 1 : 0) != 0, (String)msg);
        if (this.sortedColumn != columnIndex) {
            int oldSortedColumn = this.sortedColumn;
            this.sortedColumn = columnIndex;
            this.updateComparator();
            this.firePropertyChange("sortedColumn", oldSortedColumn, this.sortedColumn);
        }
    }

    public void updateFromModel() {
        super.updateFromModel();
        if (this.modelObservables != null) {
            ArrayList copy = new ArrayList(this.modelObservables);
            this.viewerObservables = new WritableList(copy, this.rowBeanClass);
        }
        if (this.viewerObservables != null) {
            if (this.hasViewer()) {
                AbstractListViewer viewer = this.getViewer();
                viewer.getControl().setRedraw(false);
                StructuredSelection currentSelection = new StructuredSelection(this.getSelection());
                try {
                    this.configureViewer(viewer);
                }
                finally {
                    viewer.setSelection((ISelection)currentSelection);
                    viewer.getControl().setRedraw(true);
                }
            } else {
                this.refreshSelection();
            }
        }
    }

    protected void configureViewer(AbstractListViewer viewer) {
        ObservableListContentProvider viewerCP = new ObservableListContentProvider();
        String[] propertyNames = new String[]{this.renderingMethod};
        IObservableMap[] attributeMap = null;
        if (this.renderingMethod != null) {
            attributeMap = AbstractSWTWidgetRidget.isBean(this.rowBeanClass) ? BeansObservables.observeMaps((IObservableSet)viewerCP.getKnownElements(), this.rowBeanClass, (String[])propertyNames) : PojoObservables.observeMaps((IObservableSet)viewerCP.getKnownElements(), this.rowBeanClass, (String[])propertyNames);
        }
        viewer.setLabelProvider((IBaseLabelProvider)new ListLabelProvider(attributeMap));
        viewer.setContentProvider((IContentProvider)viewerCP);
        viewer.setInput((Object)this.viewerObservables);
    }

    protected void createSelectionBindings() {
        this.dbc = new DataBindingContext();
        IViewerObservableValue viewerSelection = ViewersObservables.observeSingleSelection((Viewer)this.getViewer());
        this.viewerSSB = this.dbc.bindValue((IObservableValue)viewerSelection, this.getSingleSelectionObservable(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterGetValidator((IValidator)new OutputAwareValidator((IMarkableRidget)this)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        this.viewerMSB = null;
        if (!this.isOutputOnly()) {
            this.createMultipleSelectionBinding();
        }
    }

    @Override
    protected List<?> getRowObservables() {
        return this.viewerObservables;
    }

    protected abstract int getUIControlItemCount();

    protected abstract int getUIControlSelectionIndex();

    protected abstract int[] getUIControlSelectionIndices();

    protected abstract AbstractListViewer getViewer();

    protected void disposeSelectionBindings() {
        if (this.viewerSSB != null && !this.viewerSSB.isDisposed()) {
            this.viewerSSB.dispose();
        }
        this.disposeMultipleSelectionBinding();
    }

    protected boolean hasViewer() {
        return this.getViewer() != null;
    }

    protected boolean hasViewerModel() {
        return this.viewerObservables != null;
    }

    protected void refreshViewer() {
        this.getViewer().refresh();
    }

    @Override
    protected void unbindUIControl() {
        super.unbindUIControl();
        if (this.dbc != null) {
            this.disposeSelectionBindings();
            this.dbc.dispose();
            this.dbc = null;
        }
    }

    protected void updateComparator() {
        if (this.hasViewer()) {
            if (this.sortedColumn == 0) {
                this.getViewer().setComparator(this.comparator);
            } else {
                this.getViewer().setComparator(null);
            }
        }
    }

    @Override
    protected ClickEvent createClickEvent(MouseEvent e) {
        int index = this.getUIControlSelectionIndex();
        Object rowData = index > -1 ? this.getViewer().getElementAt(index) : null;
        return new ClickEvent((IRidget)this, e.button, 0, rowData);
    }

    public void setColumnEditable(int columnIndex, boolean editable) {
        throw new UnsupportedOperationException("not supported");
    }

    protected abstract void updateEnabled(boolean var1);

    private void createMultipleSelectionBinding() {
        if (this.viewerMSB == null && this.dbc != null && this.hasViewer()) {
            StructuredSelection currentSelection = new StructuredSelection(this.getSelection());
            IViewerObservableList viewerSelections = ViewersObservables.observeMultiSelection((Viewer)this.getViewer());
            this.viewerMSB = this.dbc.bindList((IObservableList)viewerSelections, this.getMultiSelectionObservable(), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE), new UpdateListStrategy(UpdateListStrategy.POLICY_UPDATE));
            this.getViewer().setSelection((ISelection)currentSelection);
        }
    }

    private void disposeMultipleSelectionBinding() {
        if (this.viewerMSB != null) {
            this.viewerMSB.dispose();
            this.dbc.removeBinding(this.viewerMSB);
            this.viewerMSB = null;
        }
    }

    private boolean hasInput() {
        return !this.getSelection().isEmpty();
    }

    private final class ListLabelProvider
    extends ObservableMapLabelProvider {
        private final boolean useToString;

        public ListLabelProvider(IObservableMap[] attributeMap) {
            super(attributeMap == null ? new IObservableMap[]{} : attributeMap);
            this.useToString = attributeMap == null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = MarkerSupport.isHideDisabledRidgetContent() && !AbstractListRidget.this.isEnabled() ? "" : (this.useToString ? this.toString(element) : super.getColumnText(element, columnIndex));
            return result;
        }

        private String toString(Object element) {
            if (element == null) {
                throw new NullPointerException("Row-element in ListRidget is null");
            }
            String result = element.toString();
            if (result == null) {
                throw new NullPointerException("Row-element.toString() returned null");
            }
            return result;
        }
    }
}

