/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.annotation.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.annotation.handler.IRidgetContainerAnnotationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRidgetContainerAnnotationHandler
implements IRidgetContainerAnnotationHandler {
    protected IRidget getRidget(Annotation annotation, Method method, IRidgetContainer ridgetContainer, String ridgetId) {
        Object ridget = ridgetContainer.getRidget(ridgetId);
        if (ridget != null) {
            return ridget;
        }
        throw new IllegalStateException(annotation + " defined unknown ridget id on method '" + method + "'.");
    }

    protected void errorUnsupportedRidgetType(Annotation annotation, IRidget ridget) {
        throw new IllegalStateException(annotation + " defined for incompatible ridget type '" + ridget.getClass().getName() + "' with id '" + ridget.getID() + "'.");
    }

    protected <L> L createListener(Class<L> listenerClazz, String listenerMethodName, Object target, Method targetMethod) {
        return (L)Proxy.newProxyInstance(target.getClass().getClassLoader(), new Class[]{listenerClazz}, (InvocationHandler)new ListenerHandler(target, listenerClazz, listenerMethodName, targetMethod));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListenerHandler
    implements InvocationHandler {
        private final Object target;
        private final Class<?> listenerClazz;
        private final String listenerMethodName;
        private final Method targetMethod;

        public ListenerHandler(Object target, Class<?> listenerClazz, String listenerMethodName, Method targetMethod) {
            this.target = target;
            this.listenerClazz = listenerClazz;
            this.listenerMethodName = listenerMethodName;
            this.targetMethod = targetMethod;
            if (!targetMethod.isAccessible()) {
                targetMethod.setAccessible(true);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (method.getDeclaringClass() == Object.class) {
                if (methodName.equals("hashCode")) {
                    return System.identityHashCode(proxy);
                }
                if (methodName.equals("equals")) {
                    if (proxy == args[0]) {
                        return true;
                    }
                    return false;
                }
                if (methodName.equals("toString")) {
                    return "Proxy for " + this.listenerClazz.getName() + " " + proxy.getClass().getName() + '@' + Integer.toHexString(proxy.hashCode());
                }
            }
            if (methodName.equals(this.listenerMethodName)) {
                try {
                    if (this.targetMethod.getParameterTypes().length == 0) {
                        return this.targetMethod.invoke(this.target, new Object[0]);
                    }
                    return this.targetMethod.invoke(this.target, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return null;
        }
    }
}

