/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.databinding;

import java.util.GregorianCalendar;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.ui.ridgets.ValueBindingSupport;
import org.eclipse.riena.ui.ridgets.databinding.GregorianCalendarToStringConverter;
import org.eclipse.riena.ui.ridgets.databinding.StringToGregorianCalendarConverter;
import org.eclipse.riena.ui.ridgets.databinding.StringToNumberAllowingNullConverter;

public class RidgetUpdateValueStrategy
extends UpdateValueStrategy {
    private IValidator afterSetValidator;
    private final ValueBindingSupport valueBindingSupport;

    public RidgetUpdateValueStrategy(ValueBindingSupport valueBindingSupport) {
        Assert.isNotNull((Object)valueBindingSupport);
        this.valueBindingSupport = valueBindingSupport;
    }

    public RidgetUpdateValueStrategy(ValueBindingSupport valueBindingSupport, int updatePolicy) {
        super(updatePolicy);
        Assert.isNotNull((Object)valueBindingSupport);
        this.valueBindingSupport = valueBindingSupport;
    }

    public RidgetUpdateValueStrategy(ValueBindingSupport valueBindingSupport, boolean provideDefaults, int updatePolicy) {
        super(provideDefaults, updatePolicy);
        Assert.isNotNull((Object)valueBindingSupport);
        this.valueBindingSupport = valueBindingSupport;
    }

    protected IConverter createConverter(Object fromType, Object toType) {
        if (fromType == String.class) {
            if (toType == Double.TYPE) {
                return StringToNumberAllowingNullConverter.toPrimitiveDouble();
            }
            if (toType == Float.TYPE) {
                return StringToNumberAllowingNullConverter.toPrimitiveFloat();
            }
            if (toType == Long.TYPE) {
                return StringToNumberAllowingNullConverter.toPrimitiveLong();
            }
            if (toType == Integer.TYPE) {
                return StringToNumberAllowingNullConverter.toPrimitiveInteger();
            }
            if (toType == GregorianCalendar.class) {
                return new StringToGregorianCalendarConverter();
            }
        }
        if (fromType == GregorianCalendar.class && toType == String.class) {
            return new GregorianCalendarToStringConverter();
        }
        return super.createConverter(fromType, toType);
    }

    public void setAfterSetValidator(IValidator validator) {
        this.afterSetValidator = validator;
    }

    protected IStatus doSet(IObservableValue destination, Object convertedValue) {
        IStatus status = super.doSet(destination, convertedValue);
        return this.validateAfterSet(status);
    }

    private IStatus validateAfterSet(IStatus status) {
        if (status.isOK() && this.afterSetValidator != null) {
            IObservableValue targetOV = this.valueBindingSupport.getTargetOV();
            return this.afterSetValidator.validate(targetOV.getValue());
        }
        return status;
    }
}

